/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification;

import org.apache.tuscany.sca.assembly.DefaultAssemblyFactory;
import org.apache.tuscany.sca.binding.notification.DefaultNotificationBindingFactory;
import org.apache.tuscany.sca.binding.notification.NotificationBindingProcessor;
import org.apache.tuscany.sca.binding.notification.NotificationBindingProviderFactory;
import org.apache.tuscany.sca.binding.notification.encoding.DefaultEncodingRegistry;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ModuleActivator;
import org.apache.tuscany.sca.host.http.ExtensibleServletHost;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.policy.DefaultPolicyFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;

public class NotificationBindingModuleActivator
implements ModuleActivator {
    private NotificationBindingProcessor bindingProcessor;
    private DefaultEncodingRegistry encodingRegistry;
    private ServletHost servletHost;

    public void start(ExtensionPointRegistry registry) {
        this.encodingRegistry = new DefaultEncodingRegistry();
        this.servletHost = new ExtensibleServletHost(registry.getExtensionPoint(ServletHostExtensionPoint.class));
        DefaultAssemblyFactory assemblyFactory = new DefaultAssemblyFactory();
        DefaultPolicyFactory policyFactory = new DefaultPolicyFactory();
        DefaultNotificationBindingFactory bindingFactory = new DefaultNotificationBindingFactory();
        this.bindingProcessor = new NotificationBindingProcessor(assemblyFactory, policyFactory, bindingFactory);
        StAXArtifactProcessorExtensionPoint processors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        processors.addArtifactProcessor(this.bindingProcessor);
        NotificationBindingProviderFactory nbpf = new NotificationBindingProviderFactory(this.servletHost, this.encodingRegistry);
        ProviderFactoryExtensionPoint providerFactories = registry.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        providerFactories.addProviderFactory(nbpf);
    }

    public void stop(ExtensionPointRegistry registry) {
        this.encodingRegistry.stop();
        StAXArtifactProcessorExtensionPoint processors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        processors.removeArtifactProcessor(this.bindingProcessor);
    }
}

