/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification;

import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.binding.notification.NotificationBinding;
import org.apache.tuscany.sca.binding.notification.NotificationBrokerManager;
import org.apache.tuscany.sca.binding.notification.NotificationReferenceBindingProvider;
import org.apache.tuscany.sca.binding.notification.NotificationServiceBindingProvider;
import org.apache.tuscany.sca.binding.notification.NotificationTypeManagerImpl;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerConsumerReferenceEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerID;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerIDEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerProducerReferenceEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.BrokersEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.ConnectionOverrideEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.ConnectionOverrideResponseEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.ConsumerReferenceEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;
import org.apache.tuscany.sca.binding.notification.encoding.EndConsumersEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.EndProducersEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointAddressEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointReference;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointReferenceEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.NeighborBrokerConsumersEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.NeighborsEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.NewBrokerAckEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.NewBrokerEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.NewBrokerResponseEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.NewConsumerEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.NewConsumerResponseEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.NewProducerEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.NewProducerResponseEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.ReferencePropertiesEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.RemoveBrokerEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.RemovedBrokerEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.ReplaceBrokerConnectionEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.SubscribeEnDeCoder;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationBindingProviderFactory
implements BindingProviderFactory<NotificationBinding>,
NotificationBrokerManager {
    private static final String DEFAULT_PORT = "8083";
    private ServletHost servletHost;
    private NotificationTypeManagerImpl notificationTypeManager;
    private EncodingRegistry encodingRegistry;
    private String httpUrl;
    private Map<URI, NotificationReferenceBindingProvider> referenceBindingProviders;
    private Map<URI, NotificationServiceBindingProvider> serviceBindingProviders;
    private static NotificationBindingProviderFactory factoryInstance = null;

    public NotificationBindingProviderFactory(ServletHost servletHost, EncodingRegistry encodingRegistry) {
        this.servletHost = servletHost;
        this.encodingRegistry = encodingRegistry;
        this.referenceBindingProviders = new HashMap<URI, NotificationReferenceBindingProvider>();
        this.serviceBindingProviders = new HashMap<URI, NotificationServiceBindingProvider>();
        factoryInstance = this;
    }

    @Override
    public Class<NotificationBinding> getModelType() {
        return NotificationBinding.class;
    }

    @Override
    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, NotificationBinding binding) {
        this.init();
        URI notificationType = binding.getNotificationType();
        if (!this.validReferenceBinding(binding)) {
            throw new RuntimeException("Binding not valid");
        }
        NotificationReferenceBindingProvider referenceBindingProvider = this.referenceBindingProviders.get(notificationType);
        if (referenceBindingProvider == null) {
            referenceBindingProvider = new NotificationReferenceBindingProvider(binding, component, reference, this.servletHost, this.notificationTypeManager, this.encodingRegistry, this.httpUrl, this);
            this.referenceBindingProviders.put(notificationType, referenceBindingProvider);
        }
        return referenceBindingProvider;
    }

    @Override
    public ServiceBindingProvider createServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, NotificationBinding binding) {
        this.init();
        URI notificationType = binding.getNotificationType();
        if (!this.validServiceBinding(binding)) {
            throw new RuntimeException("Binding not valid");
        }
        NotificationServiceBindingProvider serviceBindingProvider = this.serviceBindingProviders.get(notificationType);
        if (serviceBindingProvider == null) {
            serviceBindingProvider = new NotificationServiceBindingProvider(binding, component, service, this.servletHost, this.notificationTypeManager, this.encodingRegistry, this.httpUrl, this);
            this.serviceBindingProviders.put(notificationType, serviceBindingProvider);
        }
        return serviceBindingProvider;
    }

    private boolean validServiceBinding(NotificationBinding binding) {
        URI notificationType = binding.getNotificationType();
        NotificationReferenceBindingProvider referenceBindingProvider = this.referenceBindingProviders.get(notificationType);
        if (referenceBindingProvider != null) {
            return this.validBinding(binding, referenceBindingProvider.getBinding());
        }
        return true;
    }

    private boolean validReferenceBinding(NotificationBinding binding) {
        URI notificationType = binding.getNotificationType();
        NotificationServiceBindingProvider serviceBindingProvider = this.serviceBindingProviders.get(notificationType);
        if (serviceBindingProvider != null) {
            return this.validBinding(binding, serviceBindingProvider.getBinding());
        }
        return true;
    }

    private boolean validBinding(NotificationBinding binding1, NotificationBinding binding2) {
        String binding1NtmAddress = binding1.getNtmAddress();
        String binding2NtmAddress = binding2.getNtmAddress();
        if (binding1NtmAddress == null && binding2NtmAddress == null) {
            return true;
        }
        if (binding1NtmAddress == null || binding2NtmAddress == null) {
            return false;
        }
        return binding1NtmAddress.equals(binding2NtmAddress);
    }

    @Override
    public void serviceProviderStarted(URI notificationType, NotificationServiceBindingProvider serviceBindingProvider, URL remoteNtmUrl) {
        NotificationReferenceBindingProvider referenceBindingProvider = this.referenceBindingProviders.get(notificationType);
        if (referenceBindingProvider == null) {
            serviceBindingProvider.deployConsumer();
        } else if (referenceBindingProvider.isStarted()) {
            String brokerID = BrokerID.generate();
            this.deployBroker(notificationType, serviceBindingProvider, referenceBindingProvider, brokerID, remoteNtmUrl);
        }
    }

    @Override
    public void referenceProviderStarted(URI notificationType, NotificationReferenceBindingProvider referenceBindingProvider, URL remoteNtmUrl) {
        NotificationServiceBindingProvider serviceBindingProvider = this.serviceBindingProviders.get(notificationType);
        if (serviceBindingProvider == null) {
            referenceBindingProvider.deployProducer();
        } else if (serviceBindingProvider.isStarted()) {
            String brokerID = BrokerID.generate();
            this.deployBroker(notificationType, serviceBindingProvider, referenceBindingProvider, brokerID, remoteNtmUrl);
        }
    }

    private void deployBroker(URI notificationType, NotificationServiceBindingProvider serviceBindingProvider, NotificationReferenceBindingProvider referenceBindingProvider, String brokerID, URL remoteNtmUrl) {
        ArrayList<EndpointReference> producerList;
        ArrayList<EndpointReference> consumerList;
        URL producerUrl;
        URL consumerUrl = serviceBindingProvider.getURL();
        boolean firstBroker = this.notificationTypeManager.newBroker(notificationType, consumerUrl, producerUrl = referenceBindingProvider.getURL(), brokerID, remoteNtmUrl, consumerList = new ArrayList<EndpointReference>(), producerList = new ArrayList<EndpointReference>());
        if (firstBroker) {
            serviceBindingProvider.deployBroker(brokerID, null, producerList);
            referenceBindingProvider.deployBroker(brokerID, null, consumerList);
            if (!consumerList.isEmpty() || !producerList.isEmpty()) {
                this.notificationTypeManager.newBrokerAck(remoteNtmUrl);
            }
        } else {
            int index = consumerList.size() - 1;
            EndpointReference brokerConsumerEPR = (EndpointReference)consumerList.get(index);
            EndpointReference brokerProducerEPR = (EndpointReference)producerList.get(index);
            serviceBindingProvider.deployBroker(brokerID, brokerProducerEPR, null);
            referenceBindingProvider.deployBroker(brokerID, brokerConsumerEPR, null);
        }
    }

    @Override
    public void replaceConsumersBrokerConnection(URI notificationType, EndpointReference chosenBrokerProducerEpr) {
        NotificationServiceBindingProvider serviceBindingProvider = this.serviceBindingProviders.get(notificationType);
        if (serviceBindingProvider == null) {
            throw new RuntimeException("Missing service binding provider for [" + notificationType + "]");
        }
        serviceBindingProvider.replaceBrokerConnection(chosenBrokerProducerEpr);
    }

    public static void removeBroker(URI notificationType) {
        if (factoryInstance == null) {
            throw new RuntimeException("Missing factory instance");
        }
        NotificationReferenceBindingProvider referenceBindingProvider = NotificationBindingProviderFactory.factoryInstance.referenceBindingProviders.get(notificationType);
        NotificationServiceBindingProvider serviceBindingProvider = NotificationBindingProviderFactory.factoryInstance.serviceBindingProviders.get(notificationType);
        if (referenceBindingProvider == null || serviceBindingProvider == null) {
            throw new RuntimeException("Not a broker for [" + notificationType + "]");
        }
        referenceBindingProvider.undeployBroker(serviceBindingProvider.getURL());
    }

    private String getBaseURI() {
        if (this.httpUrl == null) {
            String httpPort = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("notification.httpPort");
                }
            });
            if (httpPort == null) {
                httpPort = DEFAULT_PORT;
            }
            String localHost = null;
            try {
                localHost = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                e.printStackTrace();
                localHost = "localhost";
            }
            this.httpUrl = "http://" + localHost + (httpPort != null ? ":" + httpPort : "");
        }
        return this.httpUrl;
    }

    public void init() {
        if (this.notificationTypeManager == null) {
            SubscribeEnDeCoder subscribeEnDeCoder = new SubscribeEnDeCoder(this.encodingRegistry);
            subscribeEnDeCoder.start();
            ConsumerReferenceEnDeCoder consumerReferenceEnDeCoder = new ConsumerReferenceEnDeCoder(this.encodingRegistry);
            consumerReferenceEnDeCoder.start();
            EndpointAddressEnDeCoder endpointAddressEnDeCoder = new EndpointAddressEnDeCoder(this.encodingRegistry);
            endpointAddressEnDeCoder.start();
            NewConsumerEnDeCoder newConsumerEnDeCoder = new NewConsumerEnDeCoder(this.encodingRegistry);
            newConsumerEnDeCoder.start();
            NewProducerEnDeCoder newProducerEnDeCoder = new NewProducerEnDeCoder(this.encodingRegistry);
            newProducerEnDeCoder.start();
            NewConsumerResponseEnDeCoder newConsumerResponseEnDeCoder = new NewConsumerResponseEnDeCoder(this.encodingRegistry);
            newConsumerResponseEnDeCoder.start();
            NewProducerResponseEnDeCoder newProducerResponseEnDeCoder = new NewProducerResponseEnDeCoder(this.encodingRegistry);
            newProducerResponseEnDeCoder.start();
            NewBrokerEnDeCoder newBrokerEnDeCoder = new NewBrokerEnDeCoder(this.encodingRegistry);
            newBrokerEnDeCoder.start();
            BrokerConsumerReferenceEnDeCoder brokerConsumerReferenceEnDeCoder = new BrokerConsumerReferenceEnDeCoder(this.encodingRegistry);
            brokerConsumerReferenceEnDeCoder.start();
            BrokerProducerReferenceEnDeCoder brokerProducerReferenceEnDeCoder = new BrokerProducerReferenceEnDeCoder(this.encodingRegistry);
            brokerProducerReferenceEnDeCoder.start();
            NewBrokerResponseEnDeCoder newBrokerResponseEnDeCoder = new NewBrokerResponseEnDeCoder(this.encodingRegistry);
            newBrokerResponseEnDeCoder.start();
            BrokersEnDeCoder brokersEnDeCoder = new BrokersEnDeCoder(this.encodingRegistry);
            brokersEnDeCoder.start();
            BrokerEnDeCoder brokerEnDeCoder = new BrokerEnDeCoder(this.encodingRegistry);
            brokerEnDeCoder.start();
            EndConsumersEnDeCoder endConsumersEnDeCoder = new EndConsumersEnDeCoder(this.encodingRegistry);
            endConsumersEnDeCoder.start();
            EndProducersEnDeCoder endProducersEnDeCoder = new EndProducersEnDeCoder(this.encodingRegistry);
            endProducersEnDeCoder.start();
            EndpointReferenceEnDeCoder endpointReferenceEnDeCoder = new EndpointReferenceEnDeCoder(this.encodingRegistry);
            endpointReferenceEnDeCoder.start();
            ReferencePropertiesEnDeCoder referencePropertiesEnDeCoder = new ReferencePropertiesEnDeCoder(this.encodingRegistry);
            referencePropertiesEnDeCoder.start();
            BrokerIDEnDeCoder brokerIDEnDeCoder = new BrokerIDEnDeCoder(this.encodingRegistry);
            brokerIDEnDeCoder.start();
            ConnectionOverrideEnDeCoder connectionOverrideEnDeCoder = new ConnectionOverrideEnDeCoder(this.encodingRegistry);
            connectionOverrideEnDeCoder.start();
            ConnectionOverrideResponseEnDeCoder connectionOverrideResponseEnDeCoder = new ConnectionOverrideResponseEnDeCoder(this.encodingRegistry);
            connectionOverrideResponseEnDeCoder.start();
            NewBrokerAckEnDeCoder newBrokerAckEnDeCoder = new NewBrokerAckEnDeCoder(this.encodingRegistry);
            newBrokerAckEnDeCoder.start();
            NeighborBrokerConsumersEnDeCoder neighborBrokerConsumersEnDeCoder = new NeighborBrokerConsumersEnDeCoder(this.encodingRegistry);
            neighborBrokerConsumersEnDeCoder.start();
            RemoveBrokerEnDeCoder removeBrokerEnDeCoder = new RemoveBrokerEnDeCoder(this.encodingRegistry);
            removeBrokerEnDeCoder.start();
            RemovedBrokerEnDeCoder removedBrokerEnDeCoder = new RemovedBrokerEnDeCoder(this.encodingRegistry);
            removedBrokerEnDeCoder.start();
            NeighborsEnDeCoder neighborsEnDeCoder = new NeighborsEnDeCoder(this.encodingRegistry);
            neighborsEnDeCoder.start();
            ReplaceBrokerConnectionEnDeCoder replaceBrokerConnectionEnDeCoder = new ReplaceBrokerConnectionEnDeCoder(this.encodingRegistry);
            replaceBrokerConnectionEnDeCoder.start();
            this.notificationTypeManager = new NotificationTypeManagerImpl();
            this.notificationTypeManager.setServletHost(this.servletHost);
            this.notificationTypeManager.setEncodingRegistry(this.encodingRegistry);
            this.notificationTypeManager.init();
            this.getBaseURI();
        }
    }
}

