/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.apache.tuscany.sca.binding.notification.NotificationTypeManager;
import org.apache.tuscany.sca.binding.notification.encoding.Broker;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerConsumerReference;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerID;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerProducerReference;
import org.apache.tuscany.sca.binding.notification.encoding.Brokers;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingException;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingObject;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingUtils;
import org.apache.tuscany.sca.binding.notification.encoding.EndConsumers;
import org.apache.tuscany.sca.binding.notification.encoding.EndProducers;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointAddress;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointReference;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointReferenceWrapper;
import org.apache.tuscany.sca.binding.notification.encoding.NeighborBrokerConsumers;
import org.apache.tuscany.sca.binding.notification.encoding.Neighbors;
import org.apache.tuscany.sca.binding.notification.encoding.NewBroker;
import org.apache.tuscany.sca.binding.notification.encoding.NewBrokerAck;
import org.apache.tuscany.sca.binding.notification.encoding.NewBrokerResponse;
import org.apache.tuscany.sca.binding.notification.encoding.NewConsumer;
import org.apache.tuscany.sca.binding.notification.encoding.NewConsumerResponse;
import org.apache.tuscany.sca.binding.notification.encoding.NewProducer;
import org.apache.tuscany.sca.binding.notification.encoding.NewProducerResponse;
import org.apache.tuscany.sca.binding.notification.encoding.RemoveBroker;
import org.apache.tuscany.sca.binding.notification.encoding.RemovedBroker;
import org.apache.tuscany.sca.binding.notification.encoding.ReplaceBrokerConnection;
import org.apache.tuscany.sca.binding.notification.util.IOUtils;
import org.apache.tuscany.sca.binding.notification.util.NotificationServlet;
import org.apache.tuscany.sca.binding.notification.util.URIUtil;
import org.apache.tuscany.sca.host.http.ServletHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationTypeManagerImpl
implements NotificationTypeManager {
    private static final String ntmPathBase = "/ntm";
    private ServletHost servletHost;
    private EncodingRegistry encodingRegistry;
    private Map<URI, NotificationTypeManagerHandler> ntmHandlers;

    public void setServletHost(ServletHost servletHost) {
        this.servletHost = servletHost;
    }

    public void setEncodingRegistry(EncodingRegistry encodingRegistry) {
        this.encodingRegistry = encodingRegistry;
    }

    public void init() {
        this.ntmHandlers = new HashMap<URI, NotificationTypeManagerHandler>();
    }

    @Override
    public String newConsumer(URI notificationType, URL consumerUrl, URL remoteNtmUrl, List<URL> producerListResult) {
        if (this.ntmUrlIsRemote(consumerUrl, remoteNtmUrl)) {
            try {
                WriteableEPW wEPW = new WriteableEPW(new NewConsumer(), consumerUrl);
                InputStreamDecoder isd = new InputStreamDecoder();
                NewConsumerResponse ncr = (NewConsumerResponse)IOUtils.sendHttpRequest(remoteNtmUrl, "newConsumer", (IOUtils.Writeable)wEPW, (IOUtils.ReadableContinuation)isd);
                String sequenceType = ncr.getSequenceType();
                if ("EndProducers".equals(sequenceType) || "BrokerProducers".equals(sequenceType)) {
                    for (EndpointReference epr : ncr.getReferenceSequence()) {
                        producerListResult.add(epr.getEndpointAddress().getAddress());
                    }
                }
                return sequenceType;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        NotificationTypeManagerHandler ntmHandler = this.ntmHandlers.get(notificationType);
        if (ntmHandler != null) {
            throw new RuntimeException("Trying to deploy local consumer with existing local producer, consumer or broker");
        }
        this.createNtmHandler(consumerUrl.getAuthority(), notificationType, consumerUrl, null, null);
        return "NoProducers";
    }

    private void createNtmHandler(String ntmUriAuthority, URI notificationType, URL consumerUrl, URL producerUrl, BrokerStruct broker) {
        String ntmUri = "http://" + ntmUriAuthority + ntmPathBase + URIUtil.getPath(notificationType);
        NotificationTypeManagerHandler ntmh = new NotificationTypeManagerHandler(notificationType, consumerUrl, producerUrl, broker);
        this.ntmHandlers.put(notificationType, ntmh);
        this.servletHost.addServletMapping(ntmUri, (Servlet)new NotificationServlet(ntmh));
    }

    @Override
    public String newProducer(URI notificationType, URL producerUrl, URL remoteNtmUrl, List<URL> consumerListResult) {
        if (this.ntmUrlIsRemote(producerUrl, remoteNtmUrl)) {
            try {
                WriteableEPW wEPW = new WriteableEPW(new NewProducer(), producerUrl);
                InputStreamDecoder isd = new InputStreamDecoder();
                NewProducerResponse npr = (NewProducerResponse)IOUtils.sendHttpRequest(remoteNtmUrl, "newProducer", (IOUtils.Writeable)wEPW, (IOUtils.ReadableContinuation)isd);
                String sequenceType = npr.getSequenceType();
                if ("EndConsumers".equals(sequenceType) || "BrokerConsumers".equals(sequenceType)) {
                    for (EndpointReference epr : npr.getReferenceSequence()) {
                        consumerListResult.add(epr.getEndpointAddress().getAddress());
                    }
                }
                return sequenceType;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        NotificationTypeManagerHandler ntmHandler = this.ntmHandlers.get(notificationType);
        if (ntmHandler != null) {
            throw new RuntimeException("Trying to deploy local producer with existing local producer, consumer or broker");
        }
        this.createNtmHandler(producerUrl.getAuthority(), notificationType, null, producerUrl, null);
        return "NoConsumers";
    }

    @Override
    public boolean newBroker(URI notificationType, URL consumerUrl, URL producerUrl, String brokerID, URL remoteNtmUrl, List<EndpointReference> consumerListResult, List<EndpointReference> producerListResult) {
        String ntmUriAuthority = producerUrl.getAuthority();
        if (!ntmUriAuthority.equals(consumerUrl.getAuthority())) {
            throw new RuntimeException("Producer url and consumer url do not match");
        }
        if (this.ntmUrlIsRemote(producerUrl, remoteNtmUrl)) {
            try {
                WriteableNewBroker wnb = new WriteableNewBroker(consumerUrl, producerUrl, brokerID);
                InputStreamDecoder isd = new InputStreamDecoder();
                NewBrokerResponse nbr = (NewBrokerResponse)IOUtils.sendHttpRequest(remoteNtmUrl, "newBroker", (IOUtils.Writeable)wnb, (IOUtils.ReadableContinuation)isd);
                if (nbr.isFirstBroker()) {
                    if (nbr.getEndConsumers().getSequenceType().equals("EndConsumers")) {
                        for (EndpointReference epr : nbr.getEndConsumers().getReferenceSequence()) {
                            consumerListResult.add(epr);
                        }
                    }
                    if (nbr.getEndProducers().getSequenceType().equals("EndProducers")) {
                        for (EndpointReference epr : nbr.getEndProducers().getReferenceSequence()) {
                            producerListResult.add(epr);
                        }
                    }
                } else {
                    for (Broker broker : nbr.getBrokers().getBrokerSequence()) {
                        consumerListResult.add(broker.getBrokerConsumerReference().getReference());
                        producerListResult.add(broker.getBrokerProducerReference().getReference());
                    }
                }
                return nbr.isFirstBroker();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        NotificationTypeManagerHandler ntmHandler = this.ntmHandlers.get(notificationType);
        if (ntmHandler != null) {
            throw new RuntimeException("Trying to deploy local broker with existing local producer, consumer or broker");
        }
        BrokerStruct broker = new BrokerStruct(consumerUrl, producerUrl, brokerID);
        this.createNtmHandler(ntmUriAuthority, notificationType, null, null, broker);
        return true;
    }

    private boolean ntmUrlIsRemote(URL localUrl, URL ntmUrl) {
        if (ntmUrl == null) {
            return false;
        }
        if (localUrl.getPort() != ntmUrl.getPort()) {
            return true;
        }
        String remoteNtmUrlAuthority = ntmUrl.getAuthority();
        if (remoteNtmUrlAuthority.indexOf("localhost") >= 0) {
            return false;
        }
        return !localUrl.getAuthority().equals(remoteNtmUrlAuthority);
    }

    @Override
    public void newBrokerAck(URL remoteNtmUrl) {
        try {
            IOUtils.sendHttpRequest(remoteNtmUrl, "newBrokerAck", (IOUtils.Writeable)new WriteableNewBrokerAck(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeBroker(EndpointReference brokerConsumerEpr, List<EndpointReference> neighborBrokerConsumerEprs, URL remoteNtmUrl) {
        WriteableRemoveBroker wrb = new WriteableRemoveBroker(brokerConsumerEpr, neighborBrokerConsumerEprs);
        try {
            IOUtils.sendHttpRequest(remoteNtmUrl, "removeBroker", (IOUtils.Writeable)wrb, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WriteableReplaceBrokerConnection
    implements IOUtils.Writeable {
        private ReplaceBrokerConnection replaceBrokerConnection = new ReplaceBrokerConnection();

        public WriteableReplaceBrokerConnection(EndpointReference removedBrokerEpr, List<Broker> brokerSequence) {
            RemovedBroker removedBroker = new RemovedBroker();
            removedBroker.setReference(removedBrokerEpr);
            this.replaceBrokerConnection.setRemovedBroker(removedBroker);
            if (brokerSequence != null) {
                Neighbors neighbors = new Neighbors();
                neighbors.setBrokerSequence(brokerSequence);
                this.replaceBrokerConnection.setNeighbors(neighbors);
            }
        }

        @Override
        public void write(OutputStream os) throws IOUtils.IOUtilsException {
            EncodingUtils.encodeToStream(NotificationTypeManagerImpl.this.encodingRegistry, this.replaceBrokerConnection, os);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WriteableRemoveBroker
    implements IOUtils.Writeable {
        private RemoveBroker removeBroker = new RemoveBroker();

        public WriteableRemoveBroker(EndpointReference brokerConsumerEpr, List<EndpointReference> neighborBrokerConsumerEprs) {
            BrokerConsumerReference brokerConsumerReference = new BrokerConsumerReference();
            brokerConsumerReference.setReference(brokerConsumerEpr);
            this.removeBroker.setBrokerConsumerReference(brokerConsumerReference);
            if (neighborBrokerConsumerEprs != null) {
                NeighborBrokerConsumers neighborBrokerConsumers = new NeighborBrokerConsumers();
                neighborBrokerConsumers.setReferenceSequence(neighborBrokerConsumerEprs);
                neighborBrokerConsumers.setSequenceType("BrokerConsumers");
                this.removeBroker.setNeighborBrokerConsumers(neighborBrokerConsumers);
            }
        }

        @Override
        public void write(OutputStream os) throws IOUtils.IOUtilsException {
            EncodingUtils.encodeToStream(NotificationTypeManagerImpl.this.encodingRegistry, this.removeBroker, os);
        }
    }

    class WriteableNewBrokerAck
    implements IOUtils.Writeable {
        WriteableNewBrokerAck() {
        }

        public void write(OutputStream os) throws IOUtils.IOUtilsException {
            EncodingUtils.encodeToStream(NotificationTypeManagerImpl.this.encodingRegistry, new NewBrokerAck(), os);
        }
    }

    class WriteableNewBroker
    implements IOUtils.Writeable {
        private NewBroker newBroker = new NewBroker();

        public WriteableNewBroker(URL consumerUrl, URL producerUrl, String brokerID) {
            BrokerConsumerReference bcr = new BrokerConsumerReference();
            bcr.setReference(EncodingUtils.createEndpointReference(consumerUrl, brokerID));
            this.newBroker.setBrokerConsumerReference(bcr);
            BrokerProducerReference bpr = new BrokerProducerReference();
            bpr.setReference(EncodingUtils.createEndpointReference(producerUrl, brokerID));
            this.newBroker.setBrokerProducerReference(bpr);
        }

        public void write(OutputStream os) throws IOUtils.IOUtilsException {
            EncodingUtils.encodeToStream(NotificationTypeManagerImpl.this.encodingRegistry, this.newBroker, os);
        }
    }

    class BrokerStruct {
        public URL consumerUrl;
        public URL producerUrl;
        public String brokerID;

        public BrokerStruct(URL consumerUrl, URL producerUrl, String brokerID) {
            this.consumerUrl = consumerUrl;
            this.producerUrl = producerUrl;
            this.brokerID = brokerID;
        }
    }

    class InputStreamDecoder
    implements IOUtils.ReadableContinuation {
        InputStreamDecoder() {
        }

        public Object read(InputStream istream) throws IOUtils.IOUtilsException {
            try {
                return EncodingUtils.decodeFromStream(NotificationTypeManagerImpl.this.encodingRegistry, istream);
            }
            catch (EncodingException e) {
                throw new IOUtils.IOUtilsException(e);
            }
        }
    }

    class WriteableEPW
    implements IOUtils.Writeable {
        private EndpointReferenceWrapper epw;

        public WriteableEPW(EndpointReferenceWrapper epw, URL url) {
            EndpointAddress epa = new EndpointAddress();
            epa.setAddress(url);
            EndpointReference epr = new EndpointReference();
            epr.setEndpointAddress(epa);
            epw.setReference(epr);
            this.epw = epw;
        }

        public void write(OutputStream os) throws IOUtils.IOUtilsException {
            EncodingUtils.encodeToStream(NotificationTypeManagerImpl.this.encodingRegistry, this.epw, os);
        }
    }

    class NotificationTypeLock {
        public boolean isLocked;

        NotificationTypeLock() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NotificationTypeManagerHandler
    implements NotificationServlet.NotificationServletStreamHandler {
        private URI notificationType;
        List<URL> consumerList;
        List<URL> producerList;
        List<BrokerStruct> brokerList;
        private NotificationTypeLock notificationTypeLock;
        private BrokerStruct pendingBroker;

        public NotificationTypeManagerHandler(URI notificationType) {
            this.notificationType = notificationType;
            this.notificationTypeLock = new NotificationTypeLock();
            this.pendingBroker = null;
        }

        public NotificationTypeManagerHandler(URI notificationType, URL consumerUrl, URL producerUrl, BrokerStruct broker) {
            this(notificationType);
            if (consumerUrl != null) {
                this.addConsumer(consumerUrl);
            } else if (producerUrl != null) {
                this.addProducer(producerUrl);
            } else if (broker != null) {
                this.addBroker(broker);
            }
        }

        private void addConsumer(URL consumerUrl) {
            if (this.consumerList == null) {
                this.consumerList = new ArrayList<URL>();
            }
            this.consumerList.add(consumerUrl);
        }

        private void addProducer(URL producerUrl) {
            if (this.producerList == null) {
                this.producerList = new ArrayList<URL>();
            }
            this.producerList.add(producerUrl);
        }

        private void addBroker(BrokerStruct broker) {
            if (this.brokerList == null) {
                this.brokerList = new ArrayList<BrokerStruct>();
            }
            this.brokerList.add(broker);
        }

        @Override
        public void handle(Map<String, String> headers, ServletInputStream istream, int contentLength, ServletOutputStream ostream) {
            String opHeader = headers.get("notification-operation");
            EncodingObject eo = null;
            try {
                eo = EncodingUtils.decodeFromStream(NotificationTypeManagerImpl.this.encodingRegistry, (InputStream)istream);
            }
            catch (EncodingException e) {
                throw new RuntimeException(e);
            }
            if ("newConsumer".equals(opHeader)) {
                this.handleNewConsumer((NewConsumer)eo, ostream);
            } else if ("newProducer".equals(opHeader)) {
                this.handleNewProducer((NewProducer)eo, ostream);
            } else if ("newBroker".equals(opHeader)) {
                this.handleNewBroker((NewBroker)eo, ostream);
            } else if ("newBrokerAck".equals(opHeader)) {
                this.handleNewBrokerAck();
            } else if ("removeBroker".equals(opHeader)) {
                this.handleRemoveBroker((RemoveBroker)eo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleNewConsumer(NewConsumer nc, ServletOutputStream ostream) {
            NotificationTypeLock notificationTypeLock = this.notificationTypeLock;
            synchronized (notificationTypeLock) {
                if (this.notificationTypeLock.isLocked) {
                    try {
                        this.notificationTypeLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                URL consumerUrl = nc.getReference().getEndpointAddress().getAddress();
                if (this.brokerList == null) {
                    this.addConsumer(consumerUrl);
                }
                NewConsumerResponse ncr = new NewConsumerResponse();
                if (this.producerList != null) {
                    ncr.setSequenceType("EndProducers");
                    for (URL producerUrl : this.producerList) {
                        ncr.addReferenceToSequence(EncodingUtils.createEndpointReference(producerUrl, null));
                    }
                } else if (this.brokerList != null) {
                    ncr.setSequenceType("BrokerProducers");
                    for (BrokerStruct broker : this.brokerList) {
                        ncr.addReferenceToSequence(EncodingUtils.createEndpointReference(broker.producerUrl, null));
                    }
                } else {
                    ncr.setSequenceType("NoProducers");
                }
                try {
                    EncodingUtils.encodeToStream(NotificationTypeManagerImpl.this.encodingRegistry, ncr, (OutputStream)ostream);
                }
                catch (IOUtils.IOUtilsException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleNewProducer(NewProducer np, ServletOutputStream ostream) {
            NotificationTypeLock notificationTypeLock = this.notificationTypeLock;
            synchronized (notificationTypeLock) {
                if (this.notificationTypeLock.isLocked) {
                    try {
                        this.notificationTypeLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                URL producerUrl = np.getReference().getEndpointAddress().getAddress();
                if (this.brokerList == null) {
                    this.addProducer(producerUrl);
                }
                NewProducerResponse npr = new NewProducerResponse();
                if (this.consumerList != null) {
                    npr.setSequenceType("EndConsumers");
                    for (URL consumerUrl : this.consumerList) {
                        npr.addReferenceToSequence(EncodingUtils.createEndpointReference(consumerUrl, null));
                    }
                } else if (this.brokerList != null) {
                    npr.setSequenceType("BrokerConsumers");
                    for (BrokerStruct broker : this.brokerList) {
                        npr.addReferenceToSequence(EncodingUtils.createEndpointReference(broker.consumerUrl, null));
                    }
                } else {
                    npr.setSequenceType("NoConsumers");
                }
                try {
                    EncodingUtils.encodeToStream(NotificationTypeManagerImpl.this.encodingRegistry, npr, (OutputStream)ostream);
                }
                catch (IOUtils.IOUtilsException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleNewBroker(NewBroker nb, ServletOutputStream ostream) {
            NotificationTypeLock notificationTypeLock = this.notificationTypeLock;
            synchronized (notificationTypeLock) {
                if (this.notificationTypeLock.isLocked) {
                    try {
                        this.notificationTypeLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                NewBrokerResponse nbr = new NewBrokerResponse();
                if (this.consumerList != null || this.producerList != null || this.brokerList == null) {
                    nbr.setFirstBroker(true);
                    EndConsumers endConsumers = new EndConsumers();
                    if (this.consumerList != null) {
                        endConsumers.setSequenceType("EndConsumers");
                        for (URL consumerUrl : this.consumerList) {
                            endConsumers.addReferenceToSequence(EncodingUtils.createEndpointReference(consumerUrl, null));
                        }
                    } else {
                        endConsumers.setSequenceType("NoConsumers");
                    }
                    nbr.setEndConsumers(endConsumers);
                    EndProducers endProducers = new EndProducers();
                    if (this.producerList != null) {
                        endProducers.setSequenceType("EndProducers");
                        for (URL producerUrl : this.producerList) {
                            endProducers.addReferenceToSequence(EncodingUtils.createEndpointReference(producerUrl, null));
                        }
                    } else {
                        endProducers.setSequenceType("NoProducers");
                    }
                    nbr.setEndProducers(endProducers);
                } else {
                    nbr.setFirstBroker(false);
                    Brokers brokers = new Brokers();
                    for (BrokerStruct brokerStruct : this.brokerList) {
                        Broker brokerElt = new Broker();
                        BrokerConsumerReference bcr = new BrokerConsumerReference();
                        bcr.setReference(EncodingUtils.createEndpointReference(brokerStruct.consumerUrl, brokerStruct.brokerID));
                        brokerElt.setBrokerConsumerReference(bcr);
                        BrokerProducerReference bpr = new BrokerProducerReference();
                        bpr.setReference(EncodingUtils.createEndpointReference(brokerStruct.producerUrl, brokerStruct.brokerID));
                        brokerElt.setBrokerProducerReference(bpr);
                        brokers.addBrokerToSequence(brokerElt);
                    }
                    nbr.setBrokers(brokers);
                }
                EndpointReference consumerEPR = nb.getBrokerConsumerReference().getReference();
                URL consumerUrl = consumerEPR.getEndpointAddress().getAddress();
                BrokerID consumerBrokerID = consumerEPR.getReferenceProperties().getProperty(BrokerID.class);
                EndpointReference producerEPR = nb.getBrokerProducerReference().getReference();
                URL producerUrl = producerEPR.getEndpointAddress().getAddress();
                BrokerID producerBrokerID = producerEPR.getReferenceProperties().getProperty(BrokerID.class);
                if (consumerBrokerID == null || producerBrokerID == null || !consumerBrokerID.getID().equals(producerBrokerID.getID())) {
                    throw new RuntimeException("Producer and consumer broker ids do not match");
                }
                BrokerStruct broker = new BrokerStruct(consumerUrl, producerUrl, consumerBrokerID.getID());
                if (this.consumerList == null && this.producerList == null) {
                    this.addBroker(broker);
                } else {
                    this.pendingBroker = broker;
                    this.notificationTypeLock.isLocked = true;
                }
                try {
                    EncodingUtils.encodeToStream(NotificationTypeManagerImpl.this.encodingRegistry, nbr, (OutputStream)ostream);
                }
                catch (IOUtils.IOUtilsException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleNewBrokerAck() {
            NotificationTypeLock notificationTypeLock = this.notificationTypeLock;
            synchronized (notificationTypeLock) {
                if (!this.notificationTypeLock.isLocked) {
                    this.notificationTypeLock.notifyAll();
                    throw new RuntimeException("Notification type should be locked");
                }
                if (this.brokerList != null) {
                    this.notificationTypeLock.isLocked = false;
                    this.notificationTypeLock.notifyAll();
                    throw new RuntimeException("Can't add pending broker to non-empty broker list");
                }
                if (this.pendingBroker == null) {
                    this.notificationTypeLock.isLocked = false;
                    this.notificationTypeLock.notifyAll();
                    throw new RuntimeException("Missing pending broker");
                }
                this.addBroker(this.pendingBroker);
                this.consumerList = null;
                this.producerList = null;
                this.pendingBroker = null;
                this.notificationTypeLock.isLocked = false;
                this.notificationTypeLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRemoveBroker(RemoveBroker rb) {
            NotificationTypeLock notificationTypeLock = this.notificationTypeLock;
            synchronized (notificationTypeLock) {
                if (this.notificationTypeLock.isLocked) {
                    try {
                        this.notificationTypeLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (this.brokerList == null) {
                    throw new RuntimeException("No broker to remove for [" + this.notificationType + "]");
                }
                NeighborBrokerConsumers nbcs = rb.getNeighborBrokerConsumers();
                EndpointReference rbEpr = rb.getBrokerConsumerReference().getReference();
                if (nbcs != null && nbcs.getReferenceSequence() != null) {
                    int lastIndex;
                    ArrayList<Broker> neighborBrokers = new ArrayList<Broker>();
                    for (EndpointReference neighborBrokerConsumerEpr : nbcs.getReferenceSequence()) {
                        BrokerStruct neighborBrokerStruct = null;
                        URL neighborBrokerConsumerEprUrl = neighborBrokerConsumerEpr.getEndpointAddress().getAddress();
                        for (BrokerStruct brokerStruct : this.brokerList) {
                            if (!brokerStruct.consumerUrl.equals(neighborBrokerConsumerEprUrl)) continue;
                            neighborBrokerStruct = brokerStruct;
                            break;
                        }
                        if (neighborBrokerStruct == null) {
                            throw new RuntimeException("Can't find neighbor broker for consumer EPR [" + neighborBrokerConsumerEprUrl + "]");
                        }
                        BrokerConsumerReference bcr = new BrokerConsumerReference();
                        bcr.setReference(EncodingUtils.createEndpointReference(neighborBrokerStruct.consumerUrl, neighborBrokerStruct.brokerID));
                        BrokerProducerReference bpr = new BrokerProducerReference();
                        bpr.setReference(EncodingUtils.createEndpointReference(neighborBrokerStruct.producerUrl, neighborBrokerStruct.brokerID));
                        Broker neighborBroker = new Broker();
                        neighborBroker.setBrokerConsumerReference(bcr);
                        neighborBroker.setBrokerProducerReference(bpr);
                        neighborBrokers.add(neighborBroker);
                    }
                    for (int index = lastIndex = neighborBrokers.size() - 1; index >= 0; --index) {
                        List<Broker> writeableNeighborBrokers = index > 0 ? neighborBrokers.subList(0, index) : null;
                        WriteableReplaceBrokerConnection wrbc = new WriteableReplaceBrokerConnection(rbEpr, writeableNeighborBrokers);
                        URL targetUrl = ((Broker)neighborBrokers.get(index)).getBrokerProducerReference().getReference().getEndpointAddress().getAddress();
                        try {
                            IOUtils.sendHttpRequest(targetUrl, "replaceBrokerConnection", (IOUtils.Writeable)wrbc, null);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                    }
                }
                BrokerStruct removedBrokerStruct = null;
                URL rbEprUrl = rbEpr.getEndpointAddress().getAddress();
                for (BrokerStruct brokerSruct : this.brokerList) {
                    if (!brokerSruct.consumerUrl.equals(rbEprUrl)) continue;
                    removedBrokerStruct = brokerSruct;
                    break;
                }
                if (removedBrokerStruct == null) {
                    throw new RuntimeException("Can't find broker to remove for EPR [" + rbEprUrl + "]");
                }
                if (!this.brokerList.remove(removedBrokerStruct)) {
                    throw new RuntimeException("Broker was not removed");
                }
            }
        }
    }
}

