/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.encoding;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.notification.encoding.AbstractBroker;
import org.apache.tuscany.sca.binding.notification.encoding.AbstractEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerConsumerReference;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerProducerReference;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingException;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingObject;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBrokerEnDeCoder<B extends AbstractBroker>
extends AbstractEnDeCoder<B> {
    public AbstractBrokerEnDeCoder(EncodingRegistry registry) {
        super(registry);
    }

    @Override
    public void encode(B encodingObject, XMLStreamWriter writer) throws EncodingException {
        try {
            QName qName = this.getEncodingObjectQName();
            writer.writeStartElement("wsnt", qName.getLocalPart(), qName.getNamespaceURI());
            writer.writeNamespace("wsnt", qName.getNamespaceURI());
            this.registry.encode(((AbstractBroker)encodingObject).getBrokerConsumerReference(), writer);
            this.registry.encode(((AbstractBroker)encodingObject).getBrokerProducerReference(), writer);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public B decode(XMLStreamReader reader) throws EncodingException {
        try {
            AbstractBroker brokerElement = (AbstractBroker)this.getEncodingObjectType().newInstance();
            boolean haveBCR = false;
            boolean haveBPR = false;
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        EncodingObject encodingObject = this.registry.decode(reader);
                        if (encodingObject instanceof BrokerConsumerReference && !haveBCR) {
                            brokerElement.setBrokerConsumerReference((BrokerConsumerReference)encodingObject);
                            haveBCR = true;
                            break;
                        }
                        if (encodingObject instanceof BrokerProducerReference && !haveBPR) {
                            brokerElement.setBrokerProducerReference((BrokerProducerReference)encodingObject);
                            haveBPR = true;
                            break;
                        }
                        throw new EncodingException("Invalid encoding object");
                    }
                    case 2: {
                        if (!haveBCR) {
                            throw new EncodingException("Missing broker consumer reference");
                        }
                        if (!haveBPR) {
                            throw new EncodingException("Missing broker producer reference");
                        }
                        return (B)brokerElement;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new EncodingException(ex);
        }
    }
}

