/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.encoding;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.notification.encoding.EnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingException;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingObject;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEncodingRegistry
implements EncodingRegistry {
    private final Map<Class<? extends EncodingObject>, EnDeCoder> encoderRegistry = new ConcurrentHashMap<Class<? extends EncodingObject>, EnDeCoder>();
    private final Map<QName, EnDeCoder> decoderRegistry = new ConcurrentHashMap<QName, EnDeCoder>();

    @Override
    public <E extends EncodingObject> void registerEnDeCoder(Class<E> encodingClass, QName qname, EnDeCoder<E> enDeCoder) {
        this.encoderRegistry.put(encodingClass, enDeCoder);
        this.decoderRegistry.put(qname, enDeCoder);
    }

    @Override
    public <E extends EncodingObject> void unregisterEnDeCoder(Class<E> encodingClass, QName qname) {
        this.encoderRegistry.remove(encodingClass);
        this.decoderRegistry.remove(qname);
    }

    @Override
    public void encode(EncodingObject encodingObject, XMLStreamWriter writer) throws EncodingException {
        EnDeCoder encoder = this.encoderRegistry.get(encodingObject.getClass());
        if (encoder == null) {
            throw new EncodingException("No encoder defined for " + encodingObject.getClass());
        }
        encoder.encode(encodingObject, writer);
    }

    @Override
    public EncodingObject decode(XMLStreamReader reader) throws EncodingException {
        QName qname = reader.getName();
        EnDeCoder decoder = this.decoderRegistry.get(qname);
        if (decoder == null) {
            throw new EncodingException("No decoder defined for " + qname);
        }
        return decoder.decode(reader);
    }

    public void stop() {
        this.encoderRegistry.clear();
        this.decoderRegistry.clear();
    }
}

