/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.encoding;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.notification.encoding.BrokerID;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingException;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingObject;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointAddress;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointReference;
import org.apache.tuscany.sca.binding.notification.encoding.ReferenceProperties;
import org.apache.tuscany.sca.binding.notification.util.IOUtils;

public class EncodingUtils {
    private static XMLOutputFactory xof = XMLOutputFactory.newInstance();
    private static XMLInputFactory xif = XMLInputFactory.newInstance();

    public static void encodeToStream(EncodingRegistry encodingRegistry, EncodingObject eo, OutputStream os) throws IOUtils.IOUtilsException {
        try {
            XMLStreamWriter writer = xof.createXMLStreamWriter(os);
            encodingRegistry.encode(eo, writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            throw new IOUtils.IOUtilsException(e);
        }
    }

    public static EncodingObject decodeFromStream(EncodingRegistry encodingRegistry, InputStream istream) throws EncodingException {
        EncodingObject eo = null;
        try {
            XMLStreamReader reader = xif.createXMLStreamReader(istream);
            reader.next();
            eo = encodingRegistry.decode(reader);
            reader.close();
        }
        catch (XMLStreamException e) {
            throw new EncodingException(e);
        }
        return eo;
    }

    public static EndpointReference createEndpointReference(URL address, String brokerID) {
        EndpointAddress epa = new EndpointAddress();
        epa.setAddress(address);
        EndpointReference epr = new EndpointReference();
        epr.setEndpointAddress(epa);
        if (brokerID != null) {
            BrokerID bi = new BrokerID();
            bi.setID(brokerID);
            ReferenceProperties rp = new ReferenceProperties();
            rp.addProperty(bi);
            epr.setReferenceProperties(rp);
        }
        return epr;
    }
}

