/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.encoding;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.notification.encoding.AbstractEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingException;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;
import org.apache.tuscany.sca.binding.notification.encoding.EndpointAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointAddressEnDeCoder
extends AbstractEnDeCoder<EndpointAddress> {
    public static final QName QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address");

    public EndpointAddressEnDeCoder(EncodingRegistry registry) {
        super(registry);
    }

    @Override
    public void encode(EndpointAddress encodingObject, XMLStreamWriter writer) throws EncodingException {
        try {
            writer.writeStartElement("wsa", QNAME.getLocalPart(), QNAME.getNamespaceURI());
            writer.writeNamespace("wsa", QNAME.getNamespaceURI());
            writer.writeCharacters(encodingObject.getAddress().toString());
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public EndpointAddress decode(XMLStreamReader reader) throws EncodingException {
        try {
            EndpointAddress endpointAddressElement = new EndpointAddress();
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        break;
                    }
                    case 4: {
                        if (reader.hasText()) {
                            String address = reader.getText();
                            endpointAddressElement.setAddress(address);
                            break;
                        }
                        throw new EncodingException("Endpoint address is missing address");
                    }
                    case 2: {
                        return endpointAddressElement;
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new EncodingException(ex);
        }
    }

    @Override
    public QName getEncodingObjectQName() {
        return QNAME;
    }

    @Override
    public Class<EndpointAddress> getEncodingObjectType() {
        return EndpointAddress.class;
    }
}

