/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.encoding;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.notification.encoding.AbstractEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.Brokers;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingException;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingObject;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;
import org.apache.tuscany.sca.binding.notification.encoding.EndConsumers;
import org.apache.tuscany.sca.binding.notification.encoding.EndProducers;
import org.apache.tuscany.sca.binding.notification.encoding.NewBrokerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewBrokerResponseEnDeCoder
extends AbstractEnDeCoder<NewBrokerResponse> {
    public static final QName QNAME = new QName("http://docs.oasis-open.org/wsn/b-2", "NewBrokerResponse");

    public NewBrokerResponseEnDeCoder(EncodingRegistry registry) {
        super(registry);
    }

    @Override
    public void encode(NewBrokerResponse encodingObject, XMLStreamWriter writer) throws EncodingException {
        try {
            QName qName = this.getEncodingObjectQName();
            writer.writeStartElement("wsnt", qName.getLocalPart(), qName.getNamespaceURI());
            writer.writeNamespace("wsnt", qName.getNamespaceURI());
            writer.writeAttribute("FirstBroker", String.valueOf(encodingObject.isFirstBroker()));
            if (encodingObject.isFirstBroker()) {
                this.registry.encode(encodingObject.getEndConsumers(), writer);
                this.registry.encode(encodingObject.getEndProducers(), writer);
            } else {
                this.registry.encode(encodingObject.getBrokers(), writer);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public NewBrokerResponse decode(XMLStreamReader reader) throws EncodingException {
        try {
            NewBrokerResponse newBrokerResponseElement = new NewBrokerResponse();
            boolean firstBroker = Boolean.parseBoolean(reader.getAttributeValue(null, "FirstBroker"));
            newBrokerResponseElement.setFirstBroker(firstBroker);
            boolean haveEC = false;
            boolean haveEP = false;
            boolean haveB = false;
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        EncodingObject encodingObject = this.registry.decode(reader);
                        if (encodingObject instanceof EndProducers && !haveEP && firstBroker) {
                            newBrokerResponseElement.setEndProducers((EndProducers)encodingObject);
                            haveEP = true;
                            break;
                        }
                        if (encodingObject instanceof EndConsumers && !haveEC && firstBroker) {
                            newBrokerResponseElement.setEndConsumers((EndConsumers)encodingObject);
                            haveEC = true;
                            break;
                        }
                        if (encodingObject instanceof Brokers && !haveB && !firstBroker) {
                            newBrokerResponseElement.setBrokers((Brokers)encodingObject);
                            haveB = true;
                            break;
                        }
                        throw new EncodingException("Invalid encoding object");
                    }
                    case 2: {
                        if (!haveEP && firstBroker) {
                            throw new EncodingException("Missing end producers");
                        }
                        if (!haveEC && firstBroker) {
                            throw new EncodingException("Missing end consumers");
                        }
                        if (!haveB && !firstBroker) {
                            throw new EncodingException("Missing brokers");
                        }
                        return newBrokerResponseElement;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new EncodingException(ex);
        }
    }

    @Override
    public QName getEncodingObjectQName() {
        return QNAME;
    }

    @Override
    public Class<NewBrokerResponse> getEncodingObjectType() {
        return NewBrokerResponse.class;
    }
}

