/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.encoding;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.notification.encoding.AbstractEnDeCoder;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingException;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingObject;
import org.apache.tuscany.sca.binding.notification.encoding.EncodingRegistry;
import org.apache.tuscany.sca.binding.notification.encoding.Neighbors;
import org.apache.tuscany.sca.binding.notification.encoding.RemovedBroker;
import org.apache.tuscany.sca.binding.notification.encoding.ReplaceBrokerConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceBrokerConnectionEnDeCoder
extends AbstractEnDeCoder<ReplaceBrokerConnection> {
    public static final QName QNAME = new QName("http://docs.oasis-open.org/wsn/b-2", "ReplaceBrokerConnection");

    public ReplaceBrokerConnectionEnDeCoder(EncodingRegistry registry) {
        super(registry);
    }

    @Override
    public void encode(ReplaceBrokerConnection encodingObject, XMLStreamWriter writer) throws EncodingException {
        try {
            writer.writeStartElement("wsnt", QNAME.getLocalPart(), QNAME.getNamespaceURI());
            writer.writeNamespace("wsnt", QNAME.getNamespaceURI());
            this.registry.encode(encodingObject.getRemovedBroker(), writer);
            if (encodingObject.getNeighbors() != null) {
                this.registry.encode(encodingObject.getNeighbors(), writer);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public ReplaceBrokerConnection decode(XMLStreamReader reader) throws EncodingException {
        try {
            ReplaceBrokerConnection replaceBrokerConnectionElement = new ReplaceBrokerConnection();
            boolean haveRB = false;
            boolean haveN = false;
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        EncodingObject encodingObject = this.registry.decode(reader);
                        if (encodingObject instanceof RemovedBroker && !haveRB) {
                            replaceBrokerConnectionElement.setRemovedBroker((RemovedBroker)encodingObject);
                            haveRB = true;
                            break;
                        }
                        if (encodingObject instanceof Neighbors && !haveN) {
                            replaceBrokerConnectionElement.setNeighbors((Neighbors)encodingObject);
                            haveN = true;
                            break;
                        }
                        throw new EncodingException("Invalid encoding object");
                    }
                    case 2: {
                        if (!haveRB) {
                            throw new EncodingException("Missing removed broker");
                        }
                        return replaceBrokerConnectionElement;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new EncodingException(ex);
        }
    }

    @Override
    public QName getEncodingObjectQName() {
        return QNAME;
    }

    @Override
    public Class<ReplaceBrokerConnection> getEncodingObjectType() {
        return ReplaceBrokerConnection.class;
    }
}

