/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tuscany.sca.binding.notification.util.IOUtils;

public class NotificationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private NotificationServletHandler handler;
    private NotificationServletStreamHandler servletStreamHandler;

    public NotificationServlet(NotificationServletHandler handler) {
        this.handler = handler;
        this.servletStreamHandler = null;
    }

    public NotificationServlet(NotificationServletStreamHandler servletStreamHandler) {
        this.handler = null;
        this.servletStreamHandler = servletStreamHandler;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.put(headerName, request.getHeader(headerName));
        }
        if (this.handler != null) {
            byte[] requestBody = IOUtils.readFully((InputStream)request.getInputStream(), request.getContentLength());
            byte[] handlersResponse = this.handler.handle(headers, requestBody);
            if (handlersResponse != null) {
                response.getOutputStream().write(handlersResponse);
                response.getOutputStream().flush();
            }
        } else {
            try {
                this.servletStreamHandler.handle(headers, request.getInputStream(), request.getContentLength(), response.getOutputStream());
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NotificationServletStreamHandler {
        public void handle(Map<String, String> var1, ServletInputStream var2, int var3, ServletOutputStream var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NotificationServletHandler {
        public byte[] handle(Map<String, String> var1, byte[] var2);
    }
}

