/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rmi.impl;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.tuscany.sca.binding.rmi.RMIBinding;

public class RMIBindingImpl
implements RMIBinding {
    private String name;
    private String uri;
    private String host;
    private String port;
    private String serviceName;

    public String getHost() {
        return this.host;
    }

    public void setHost(String rmiHostName) {
        this.host = rmiHostName;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String rmiPort) {
        this.port = rmiPort;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String rmiServiceName) {
        this.serviceName = rmiServiceName;
    }

    public String getName() {
        return this.name;
    }

    public String getURI() {
        this.compose();
        return this.uri;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setURI(String uri) {
        this.uri = uri;
        this.parse(uri);
    }

    public boolean isUnresolved() {
        return false;
    }

    public void setUnresolved(boolean unresolved) {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void parse(String uriStr) {
        if (uriStr == null) {
            return;
        }
        URI uri = URI.create(uriStr);
        if (this.host == null) {
            this.host = uri.getHost();
        }
        if (this.port == null) {
            this.port = String.valueOf(uri.getPort());
        }
        if (this.serviceName == null) {
            String path = uri.getPath();
            if (path != null && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            this.serviceName = path;
        }
    }

    private void compose() {
        if (this.uri == null) {
            String path;
            int p = -1;
            if (this.port != null && this.port.length() > 0) {
                p = Integer.decode(this.port);
            }
            if ((path = this.serviceName) != null) {
                path = "/" + path;
            }
            try {
                this.uri = new URI("rmi", null, this.host, p, path, null, null).toString();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

