/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rss.provider;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndLink;
import com.sun.syndication.feed.synd.SyndLinkImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RSSBindingListenerServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(RSSBindingListenerServlet.class.getName());
    private static final long serialVersionUID = 1L;
    private RuntimeWire wire;
    private Invoker getFeedInvoker;
    private Invoker getAllInvoker;
    private Invoker queryInvoker;
    private MessageFactory messageFactory;
    private Mediator mediator;
    private DataType<?> itemClassType;
    private DataType<?> itemXMLType;
    private boolean supportsFeedEntries;

    RSSBindingListenerServlet(RuntimeWire wire, MessageFactory messageFactory, Mediator mediator) {
        this.wire = wire;
        this.messageFactory = messageFactory;
        this.mediator = mediator;
        Operation getOperation = null;
        for (InvocationChain invocationChain : this.wire.getInvocationChains()) {
            invocationChain.setAllowsPassByReference(true);
            Operation operation = invocationChain.getTargetOperation();
            String operationName = operation.getName();
            if (operationName.equals("getFeed")) {
                this.getFeedInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("getAll")) {
                this.getAllInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (operationName.equals("query")) {
                this.queryInvoker = invocationChain.getHeadInvoker();
                continue;
            }
            if (!operationName.equals("get")) continue;
            getOperation = operation;
        }
        if (getOperation != null) {
            this.itemXMLType = new DataTypeImpl<Class<String>>(String.class.getName(), String.class, String.class);
            Class<?> itemClass = getOperation.getOutputType().getPhysical();
            if (itemClass == SyndEntry.class) {
                this.supportsFeedEntries = true;
            }
            DataType outputType = getOperation.getOutputType();
            QName qname = ((XMLType)outputType.getLogical()).getElementName();
            qname = new QName(qname.getNamespaceURI(), itemClass.getSimpleName());
            this.itemClassType = new DataTypeImpl<XMLType>("java:complexType", itemClass, new XMLType(qname, null));
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        logger.fine("get " + request.getRequestURI());
        if (path == null || path.length() == 0 || path.equals("/")) {
            Message responseMessage;
            Message requestMessage;
            SyndFeed feed = null;
            if (this.supportsFeedEntries) {
                requestMessage = this.messageFactory.createMessage();
                responseMessage = this.getFeedInvoker.invoke(requestMessage);
                if (responseMessage.isFault()) {
                    throw new ServletException((Throwable)responseMessage.getBody());
                }
                feed = (SyndFeed)responseMessage.getBody();
            } else {
                requestMessage = this.messageFactory.createMessage();
                if (request.getQueryString() != null) {
                    requestMessage.setBody(new Object[]{request.getQueryString()});
                    responseMessage = this.queryInvoker.invoke(requestMessage);
                } else {
                    responseMessage = this.getAllInvoker.invoke(requestMessage);
                }
                if (responseMessage.isFault()) {
                    throw new ServletException((Throwable)responseMessage.getBody());
                }
                Entry[] collection = (Entry[])responseMessage.getBody();
                if (collection != null) {
                    feed = new SyndFeedImpl();
                    feed.setTitle("Feed");
                    feed.setDescription("Feed description");
                    for (Entry entry : collection) {
                        SyndEntry feedEntry = this.createFeedEntry(entry);
                        feed.getEntries().add(feedEntry);
                    }
                }
            }
            if (feed != null) {
                response.setContentType("application/rss+xml; charset=utf-8");
                feed.setFeedType("rss_2.0");
                feed.setLink(path);
                SyndFeedOutput syndOutput = new SyndFeedOutput();
                try {
                    syndOutput.output(feed, this.getWriter(response));
                }
                catch (FeedException e) {
                    throw new ServletException((Throwable)e);
                }
            } else {
                response.sendError(404);
            }
        } else {
            response.sendError(404);
        }
    }

    private SyndEntry createFeedEntry(Entry<Object, Object> entry) {
        Object key = entry.getKey();
        Object data = entry.getData();
        if (data instanceof Item) {
            String href;
            Item item = (Item)data;
            SyndEntryImpl feedEntry = new SyndEntryImpl();
            feedEntry.setUri(key.toString());
            feedEntry.setTitle(item.getTitle());
            String value = item.getContents();
            if (value != null) {
                SyndContentImpl content = new SyndContentImpl();
                content.setType("text/xml");
                content.setValue(value);
                ArrayList<SyndContentImpl> contents = new ArrayList<SyndContentImpl>();
                contents.add(content);
                feedEntry.setContents(contents);
            }
            if ((href = item.getLink()) == null) {
                href = key.toString();
            }
            SyndLinkImpl link = new SyndLinkImpl();
            link.setRel("edit");
            link.setHref(href);
            feedEntry.getLinks().add(link);
            link = new SyndLinkImpl();
            link.setRel("alternate");
            link.setHref(href);
            feedEntry.getLinks().add(link);
            feedEntry.setLink(href);
            Date date = item.getDate();
            if (date == null) {
                date = new Date();
            }
            feedEntry.setPublishedDate(date);
            return feedEntry;
        }
        if (data != null) {
            SyndEntryImpl feedEntry = new SyndEntryImpl();
            feedEntry.setUri(key.toString());
            feedEntry.setTitle("item");
            String value = this.mediator.mediate(data, this.itemClassType, this.itemXMLType, null).toString();
            SyndContentImpl content = new SyndContentImpl();
            content.setType("text/xml");
            content.setValue(value);
            ArrayList<SyndContentImpl> contents = new ArrayList<SyndContentImpl>();
            contents.add(content);
            feedEntry.setContents(contents);
            SyndLinkImpl link = new SyndLinkImpl();
            link.setRel("edit");
            link.setHref(key.toString());
            feedEntry.getLinks().add(link);
            link = new SyndLinkImpl();
            link.setRel("alternate");
            link.setHref(key.toString());
            feedEntry.getLinks().add(link);
            feedEntry.setPublishedDate(new Date());
            return feedEntry;
        }
        return null;
    }

    private Entry<Object, Object> createEntry(SyndEntry feedEntry) {
        if (feedEntry != null) {
            if (this.itemClassType.getPhysical() == Item.class) {
                String key = feedEntry.getUri();
                Item item = new Item();
                item.setTitle(feedEntry.getTitle());
                List contents = feedEntry.getContents();
                if (!contents.isEmpty()) {
                    SyndContent content = (SyndContent)contents.get(0);
                    String value = content.getValue();
                    item.setContents(value);
                }
                for (Object l : feedEntry.getLinks()) {
                    SyndLink link = (SyndLink)l;
                    if (link.getRel() != null && !"edit".equals(link.getRel())) continue;
                    String href = link.getHref();
                    if (href.startsWith("null/")) {
                        href = href.substring(5);
                    }
                    item.setLink(href);
                    break;
                }
                item.setDate(feedEntry.getPublishedDate());
                return new Entry<Object, Object>(key, item);
            }
            String key = feedEntry.getUri();
            List contents = feedEntry.getContents();
            if (contents.isEmpty()) {
                return null;
            }
            SyndContent content = (SyndContent)contents.get(0);
            String value = content.getValue();
            Object data = this.mediator.mediate(value, this.itemXMLType, this.itemClassType, null);
            return new Entry<Object, Object>(key, data);
        }
        return null;
    }

    private Writer getWriter(HttpServletResponse response) throws UnsupportedEncodingException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
        return writer;
    }

    private String processAuthorizationHeader(HttpServletRequest request) throws ServletException {
        try {
            String password;
            String user;
            String credentials;
            String userAndPassword;
            int colon;
            String basic;
            StringTokenizer tokens;
            String authorization = request.getHeader("Authorization");
            if (authorization != null && (tokens = new StringTokenizer(authorization)).hasMoreTokens() && (basic = tokens.nextToken()).equalsIgnoreCase("Basic") && (colon = (userAndPassword = new String(Base64.decodeBase64((byte[])(credentials = tokens.nextToken()).getBytes()))).indexOf(":")) != -1 && this.authenticate(user = userAndPassword.substring(0, colon), password = userAndPassword.substring(colon + 1))) {
                return user;
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        return null;
    }

    private boolean authenticate(String user, String password) {
        return "admin".endsWith(user) && "admin".equals(password);
    }

    private void unauthorized(HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", "BASIC realm=\"Tuscany\"");
        response.sendError(401);
    }
}

