/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rss.provider;

import org.apache.tuscany.sca.binding.rss.RSSBinding;
import org.apache.tuscany.sca.binding.rss.provider.RSSReferenceBindingProvider;
import org.apache.tuscany.sca.binding.rss.provider.RSSServiceBindingProvider;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSBindingProviderFactory
implements BindingProviderFactory<RSSBinding> {
    private MessageFactory messageFactory;
    private Mediator mediator;
    private ServletHost servletHost;

    public RSSBindingProviderFactory(ExtensionPointRegistry extensionPoints) {
        ServletHostExtensionPoint servletHosts = extensionPoints.getExtensionPoint(ServletHostExtensionPoint.class);
        this.servletHost = servletHosts.getServletHosts().get(0);
        ModelFactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.messageFactory = modelFactories.getFactory(MessageFactory.class);
        this.mediator = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class).getUtility(Mediator.class);
    }

    @Override
    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, RSSBinding binding) {
        return new RSSReferenceBindingProvider(component, reference, binding);
    }

    @Override
    public ServiceBindingProvider createServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, RSSBinding binding) {
        return new RSSServiceBindingProvider(component, service, binding, this.servletHost, this.messageFactory, this.mediator);
    }

    @Override
    public Class<RSSBinding> getModelType() {
        return RSSBinding.class;
    }
}

