/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.impl;

import java.net.URI;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.OptimizableBinding;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.binding.sca.DistributedSCABinding;
import org.apache.tuscany.sca.binding.sca.impl.DistributedSCABindingImpl;
import org.apache.tuscany.sca.binding.sca.impl.RemoteBindingHelper;
import org.apache.tuscany.sca.binding.sca.impl.SCABindingInvoker;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.ServiceUnavailableException;

public class RuntimeSCAReferenceBindingProvider
implements ReferenceBindingProvider {
    private static final Logger logger = Logger.getLogger(RuntimeSCAReferenceBindingProvider.class.getName());
    private RuntimeComponent component;
    private RuntimeComponentReference reference;
    private SCABinding binding;
    private boolean started = false;
    private BindingProviderFactory<DistributedSCABinding> distributedProviderFactory = null;
    private ReferenceBindingProvider distributedProvider = null;

    public RuntimeSCAReferenceBindingProvider(ExtensionPointRegistry extensionPoints, RuntimeComponent component, RuntimeComponentReference reference, SCABinding binding) {
        this.component = component;
        this.reference = reference;
        this.binding = binding;
        ProviderFactoryExtensionPoint factoryExtensionPoint = extensionPoints.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        this.distributedProviderFactory = (BindingProviderFactory)factoryExtensionPoint.getProviderFactory(DistributedSCABinding.class);
    }

    public boolean isTargetRemote() {
        boolean targetIsRemote = false;
        OptimizableBinding optimizableBinding = (OptimizableBinding)((Object)this.binding);
        if (RemoteBindingHelper.isTargetRemote()) {
            targetIsRemote = this.reference.getInterfaceContract() != null ? this.reference.getInterfaceContract().getInterface().isRemotable() : true;
        } else if (optimizableBinding.getTargetComponentService() != null) {
            targetIsRemote = optimizableBinding.getTargetComponentService().isUnresolved();
        } else {
            try {
                URI uri = new URI(this.binding.getURI());
                targetIsRemote = uri.isAbsolute();
            }
            catch (Exception ex) {
                targetIsRemote = false;
            }
        }
        return targetIsRemote;
    }

    private ReferenceBindingProvider getDistributedProvider() {
        if ((this.isTargetRemote() || this.isRemotableCallback()) && this.distributedProvider == null) {
            if (this.reference.getInterfaceContract() != null && !this.reference.getInterfaceContract().getInterface().isRemotable()) {
                throw new IllegalStateException("Reference interface not remotable for component: " + this.component.getName() + " and reference: " + this.reference.getName());
            }
            if (this.distributedProviderFactory == null) {
                throw new IllegalStateException("No distributed SCA binding available for component: " + this.component.getName() + " and reference: " + this.reference.getName());
            }
            DistributedSCABindingImpl distributedBinding = new DistributedSCABindingImpl();
            distributedBinding.setSCABinding(this.binding);
            this.distributedProvider = this.distributedProviderFactory.createReferenceBindingProvider(this.component, this.reference, distributedBinding);
        }
        return this.distributedProvider;
    }

    private boolean isRemotableCallback() {
        return this.reference.isCallback() && this.reference.getInterfaceContract() != null && this.reference.getInterfaceContract().getInterface().isRemotable() && this.distributedProviderFactory != null;
    }

    public InterfaceContract getBindingInterfaceContract() {
        if (this.isTargetRemote()) {
            return this.getDistributedProvider().getBindingInterfaceContract();
        }
        if (this.reference.getReference() != null) {
            return this.reference.getReference().getInterfaceContract();
        }
        return this.reference.getInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        if (this.isTargetRemote()) {
            return this.getDistributedProvider().supportsOneWayInvocation();
        }
        return false;
    }

    private Invoker getInvoker(RuntimeWire wire, Operation operation) {
        RuntimeComponentService service;
        EndpointReference target = wire.getTarget();
        if (target != null && (service = (RuntimeComponentService)target.getContract()) != null) {
            SCABinding scaBinding = service.getBinding(SCABinding.class);
            InvocationChain chain = service.getInvocationChain(scaBinding, wire.getSource().getInterfaceContract(), operation);
            return chain == null ? null : new SCABindingInvoker(chain);
        }
        return null;
    }

    public Invoker createInvoker(Operation operation) {
        if (this.isTargetRemote()) {
            return this.getDistributedProvider().createInvoker(operation);
        }
        RuntimeWire wire = this.reference.getRuntimeWire(this.binding);
        Invoker invoker = this.getInvoker(wire, operation);
        if (invoker == null) {
            throw new ServiceUnavailableException("Unable to create SCA binding invoker for local target " + this.component.getName() + " reference " + this.reference.getName() + " (bindingURI=" + this.binding.getURI() + " operation=" + operation.getName() + ")");
        }
        return invoker;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.getDistributedProvider() != null) {
            this.distributedProvider.start();
        }
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.getDistributedProvider() != null) {
            this.distributedProvider.stop();
        }
    }
}

