/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ServiceClient;
import org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.token.Axis2TokenAuthenticationPolicy;
import org.apache.tuscany.sca.binding.ws.axis2.policy.configurator.Axis2BindingBasicAuthenticationConfigurator;
import org.apache.tuscany.sca.binding.ws.axis2.policy.configurator.Axis2BindingHeaderConfigurator;
import org.apache.tuscany.sca.binding.ws.axis2.policy.header.Axis2HeaderPolicy;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;
import org.apache.tuscany.sca.policy.util.PolicyHandler;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.ReferenceParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2BindingInvoker
implements Invoker,
DataExchangeSemantics {
    public static final QName QNAME_WSA_FROM = new QName("http://www.w3.org/2005/08/addressing", "From", "wsa");
    public static final String TUSCANY_PREFIX = "tuscany";
    public static final QName CALLBACK_ID_REFPARM_QN = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "CallbackID", "tuscany");
    public static final QName CONVERSATION_ID_REFPARM_QN = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "ConversationID", "tuscany");
    public static long GLOBAL_AXIS_TIMEOUT = 240000L;
    private Axis2ServiceClient serviceClient;
    private QName wsdlOperationName;
    private Options options;
    private SOAPFactory soapFactory;
    private List<PolicyHandler> policyHandlerList = null;
    private WebServiceBinding wsBinding;
    private BasicAuthenticationPolicy basicAuthenticationPolicy = null;
    private Axis2TokenAuthenticationPolicy axis2TokenAuthenticationPolicy = null;
    private List<Axis2HeaderPolicy> axis2HeaderPolicies = new ArrayList<Axis2HeaderPolicy>();
    private static final QName EXCEPTION = new QName("", "Exception");

    public Axis2BindingInvoker(Axis2ServiceClient serviceClient, QName wsdlOperationName, Options options, SOAPFactory soapFactory, List<PolicyHandler> policyHandlerList, WebServiceBinding wsBinding) {
        this.serviceClient = serviceClient;
        this.wsdlOperationName = wsdlOperationName;
        this.options = options;
        this.soapFactory = soapFactory;
        this.policyHandlerList = policyHandlerList;
        this.wsBinding = wsBinding;
        if (wsBinding instanceof PolicySetAttachPoint) {
            List<PolicySet> policySets = ((PolicySetAttachPoint)((Object)wsBinding)).getPolicySets();
            for (PolicySet ps : policySets) {
                for (Object p : ps.getPolicies()) {
                    if (BasicAuthenticationPolicy.class.isInstance(p)) {
                        this.basicAuthenticationPolicy = (BasicAuthenticationPolicy)p;
                        continue;
                    }
                    if (Axis2TokenAuthenticationPolicy.class.isInstance(p)) {
                        this.axis2TokenAuthenticationPolicy = (Axis2TokenAuthenticationPolicy)p;
                        continue;
                    }
                    if (!Axis2HeaderPolicy.class.isInstance(p)) continue;
                    this.axis2HeaderPolicies.add((Axis2HeaderPolicy)p);
                }
            }
        }
    }

    @Override
    public Message invoke(Message msg) {
        try {
            Object resp = this.invokeTarget(msg);
            msg.setBody(resp);
        }
        catch (AxisFault e) {
            if (e.getDetail() != null) {
                FaultException f = new FaultException(e.getMessage(), e.getDetail(), e);
                f.setFaultName(e.getDetail().getQName());
                msg.setFaultBody(f);
            } else {
                msg.setFaultBody(e);
            }
        }
        catch (Throwable e) {
            msg.setFaultBody(e);
        }
        return msg;
    }

    protected Object invokeTarget(Message msg) throws AxisFault {
        final OperationClient operationClient = this.createOperationClient(msg);
        MessageContext requestMC = operationClient.getMessageContext("Out");
        requestMC.getOptions().setProperty("REUSE_HTTP_CLIENT", (Object)Boolean.TRUE);
        requestMC.getOptions().setTimeOutInMilliSeconds(GLOBAL_AXIS_TIMEOUT);
        for (PolicyHandler policyHandler : this.policyHandlerList) {
            policyHandler.beforeInvoke(msg, requestMC, operationClient);
        }
        for (Axis2HeaderPolicy policy : this.axis2HeaderPolicies) {
            Axis2BindingHeaderConfigurator.setHeader(requestMC, msg, policy.getHeaderName());
        }
        if (this.basicAuthenticationPolicy != null) {
            Axis2BindingBasicAuthenticationConfigurator.setOperationOptions(operationClient, msg, this.basicAuthenticationPolicy);
        }
        if (this.axis2TokenAuthenticationPolicy != null) {
            Axis2BindingHeaderConfigurator.setHeader(requestMC, msg, this.axis2TokenAuthenticationPolicy.getTokenName());
        }
        MessageContext responseMC = null;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AxisFault {
                    operationClient.execute(true);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            try {
                operationClient.complete(requestMC);
                throw (AxisFault)((Object)e.getException());
            }
            catch (Throwable throwable) {
                responseMC = operationClient.getMessageContext("In");
                for (PolicyHandler policyHandler : this.policyHandlerList) {
                    policyHandler.afterInvoke(msg, responseMC, operationClient);
                }
                throw throwable;
            }
        }
        responseMC = operationClient.getMessageContext("In");
        for (PolicyHandler policyHandler : this.policyHandlerList) {
            policyHandler.afterInvoke(msg, responseMC, operationClient);
        }
        OMElement response = responseMC.getEnvelope().getBody().getFirstElement();
        if (response != null) {
            response.build();
        }
        operationClient.complete(requestMC);
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected OperationClient createOperationClient(Message msg) throws AxisFault {
        Object conversationId;
        Object callbackID;
        SOAPEnvelope env = this.soapFactory.getDefaultEnvelope();
        Object[] args = (Object[])msg.getBody();
        if (args != null && args.length > 0) {
            SOAPBody body = env.getBody();
            for (Object bc : args) {
                if (!(bc instanceof OMElement)) {
                    throw new IllegalArgumentException("Can't handle mixed payloads between OMElements and other types.");
                }
                body.addChild((OMNode)((OMElement)bc));
            }
        }
        final MessageContext requestMC = new MessageContext();
        requestMC.setEnvelope(env);
        final OperationClient operationClient = this.serviceClient.getServiceClient().createClient(this.wsdlOperationName);
        operationClient.setOptions(this.options);
        ReferenceParameters parameters = msg.getFrom().getReferenceParameters();
        org.apache.axis2.addressing.EndpointReference fromEPR = null;
        EndpointReference callbackEPR = parameters.getCallbackReference();
        if (callbackEPR != null) {
            fromEPR = new org.apache.axis2.addressing.EndpointReference(callbackEPR.getBinding().getURI());
        }
        if ((callbackID = parameters.getCallbackID()) != null) {
            if (fromEPR == null) {
                fromEPR = new org.apache.axis2.addressing.EndpointReference("http://www.w3.org/2005/08/addressing/anonymous");
            }
            fromEPR.addReferenceParameter(CALLBACK_ID_REFPARM_QN, callbackID.toString());
        }
        if ((conversationId = parameters.getConversationID()) != null) {
            if (fromEPR == null) {
                fromEPR = new org.apache.axis2.addressing.EndpointReference("http://www.w3.org/2005/08/addressing/anonymous");
            }
            fromEPR.addReferenceParameter(CONVERSATION_ID_REFPARM_QN, conversationId.toString());
        }
        if (fromEPR != null) {
            SOAPEnvelope sev = requestMC.getEnvelope();
            SOAPHeader sh = sev.getHeader();
            OMElement epr = EndpointReferenceHelper.toOM((OMFactory)sev.getOMFactory(), (org.apache.axis2.addressing.EndpointReference)fromEPR, (QName)QNAME_WSA_FROM, (String)"http://www.w3.org/2005/08/addressing");
            sh.addChild((OMNode)epr);
            requestMC.setFrom(fromEPR);
        }
        if (this.options.getTo() == null) {
            EndpointReference ep = msg.getTo();
            if (ep == null) throw new RuntimeException("Unable to determine destination endpoint");
            requestMC.setTo(new org.apache.axis2.addressing.EndpointReference(ep.getURI()));
        } else {
            requestMC.setTo(new org.apache.axis2.addressing.EndpointReference(this.options.getTo().getAddress()));
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AxisFault {
                    operationClient.addMessageContext(requestMC);
                    return null;
                }
            });
            return operationClient;
        }
        catch (PrivilegedActionException e) {
            throw (AxisFault)((Object)e.getException());
        }
    }

    @Override
    public boolean allowsPassByReference() {
        return true;
    }
}

