/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.util.List;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ReferenceBindingProvider;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ServiceBindingProvider;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.policy.util.PolicyHandlerDefinitionsLoader;
import org.apache.tuscany.sca.policy.util.PolicyHandlerTuple;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.work.WorkScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2BindingProviderFactory
implements BindingProviderFactory<WebServiceBinding> {
    private ModelFactoryExtensionPoint modelFactories;
    private List<ServletHost> hosts;
    private List<PolicyHandlerTuple> policyHandlerClassnames = null;
    private DataBindingExtensionPoint dataBindings;
    private WorkScheduler workScheduler;

    public Axis2BindingProviderFactory(ExtensionPointRegistry extensionPoints) {
        ServletHostExtensionPoint servletHosts = extensionPoints.getExtensionPoint(ServletHostExtensionPoint.class);
        this.hosts = servletHosts.getServletHosts();
        this.modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.policyHandlerClassnames = PolicyHandlerDefinitionsLoader.loadPolicyHandlerClassnames();
        this.dataBindings = extensionPoints.getExtensionPoint(DataBindingExtensionPoint.class);
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.workScheduler = utilities.getUtility(WorkScheduler.class);
    }

    @Override
    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, WebServiceBinding binding) {
        return new Axis2ReferenceBindingProvider(component, reference, binding, this.modelFactories, this.policyHandlerClassnames, this.dataBindings);
    }

    @Override
    public ServiceBindingProvider createServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, WebServiceBinding binding) {
        ServletHost servletHost = null;
        if (!this.hosts.isEmpty()) {
            servletHost = this.hosts.get(0);
        }
        return new Axis2ServiceBindingProvider(component, service, binding, servletHost, this.modelFactories, this.policyHandlerClassnames, this.dataBindings, this.workScheduler);
    }

    @Override
    public Class<WebServiceBinding> getModelType() {
        return WebServiceBinding.class;
    }
}

