/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.axis2.util.threadpool.ThreadPool;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2BindingInvoker;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2OneWayBindingInvoker;
import org.apache.tuscany.sca.binding.ws.axis2.AxisPolicyHelper;
import org.apache.tuscany.sca.binding.ws.axis2.TuscanyAxisConfigurator;
import org.apache.tuscany.sca.binding.ws.axis2.policy.configuration.Axis2ConfigParamPolicy;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.util.PolicyHandler;
import org.apache.tuscany.sca.policy.util.PolicyHandlerTuple;
import org.apache.tuscany.sca.policy.util.PolicyHandlerUtils;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.xsd.xml.XMLDocumentHelper;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.osoa.sca.ServiceRuntimeException;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2ServiceClient {
    private RuntimeComponent component;
    private AbstractContract contract;
    private WebServiceBinding wsBinding;
    private ServiceClient serviceClient;
    List<PolicyHandlerTuple> policyHandlerClassnames = null;
    private List<PolicyHandler> policyHandlerList = new ArrayList<PolicyHandler>();

    public Axis2ServiceClient(RuntimeComponent component, AbstractContract contract, WebServiceBinding wsBinding, MessageFactory messageFactory, List<PolicyHandlerTuple> policyHandlerClassnames) {
        this.component = component;
        this.contract = contract;
        this.wsBinding = wsBinding;
        this.policyHandlerClassnames = policyHandlerClassnames;
    }

    protected void start() {
        if (this.serviceClient == null) {
            this.serviceClient = this.createServiceClient();
        }
    }

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    protected void configurePolicy(ConfigurationContext context, PolicySet ps) throws AxisFault {
        if (ps == null) {
            return;
        }
        for (Object policy : ps.getPolicies()) {
            if (!(policy instanceof Axis2ConfigParamPolicy)) continue;
            Axis2ConfigParamPolicy axis2ConfigParamPolicy = (Axis2ConfigParamPolicy)policy;
            for (Map.Entry<String, OMElement> param : axis2ConfigParamPolicy.getParamElements().entrySet()) {
                Parameter configParam = new Parameter(param.getKey(), (Object)param.getValue().getFirstElement());
                configParam.setParameterElement(param.getValue());
                context.getAxisConfiguration().addParameter(configParam);
            }
        }
    }

    protected ServiceClient createServiceClient() {
        try {
            ConfigurationContext configContext;
            final boolean isRampartRequired = AxisPolicyHelper.isRampartRequired(this.wsBinding);
            try {
                TuscanyAxisConfigurator tuscanyAxisConfigurator = AccessController.doPrivileged(new PrivilegedExceptionAction<TuscanyAxisConfigurator>(){

                    @Override
                    public TuscanyAxisConfigurator run() throws AxisFault {
                        return new TuscanyAxisConfigurator(isRampartRequired);
                    }
                });
                configContext = tuscanyAxisConfigurator.getConfigurationContext();
            }
            catch (PrivilegedActionException e) {
                throw new ServiceRuntimeException(e.getException());
            }
            this.createPolicyHandlers();
            this.setupPolicyHandlers(this.policyHandlerList, configContext);
            Definition definition = this.wsBinding.getWSDLDocument();
            QName serviceQName = this.wsBinding.getService().getQName();
            Port port = this.wsBinding.getPort();
            if (port == null) {
                Collection ports = this.wsBinding.getService().getPorts().values();
                for (Port p : ports) {
                    if (!(p.getExtensibilityElements().get(0) instanceof SOAPAddress)) continue;
                    port = p;
                    break;
                }
                if (port == null) {
                    for (Port p : ports) {
                        if (!(p.getExtensibilityElements().get(0) instanceof SOAP12Address)) continue;
                        port = p;
                        break;
                    }
                }
            }
            AxisService axisService = Axis2ServiceClient.createClientSideAxisService(definition, serviceQName, port.getName(), new Options());
            HttpClient httpClient = (HttpClient)configContext.getProperty("CACHED_HTTP_CLIENT");
            if (httpClient == null) {
                MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
                HttpConnectionManagerParams connectionManagerParams = new HttpConnectionManagerParams();
                connectionManagerParams.setDefaultMaxConnectionsPerHost(2);
                connectionManagerParams.setTcpNoDelay(true);
                connectionManagerParams.setStaleCheckingEnabled(true);
                connectionManagerParams.setLinger(0);
                connectionManager.setParams(connectionManagerParams);
                httpClient = new HttpClient((HttpConnectionManager)connectionManager);
                configContext.setThreadPool((ThreadFactory)new ThreadPool(1, 5));
                configContext.setProperty("REUSE_HTTP_CLIENT", (Object)Boolean.TRUE);
                configContext.setProperty("CACHED_HTTP_CLIENT", (Object)httpClient);
            }
            return new ServiceClient(configContext, axisService);
        }
        catch (AxisFault e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Definition getDefinition(Definition definition, QName serviceName) {
        if (serviceName == null) {
            return definition;
        }
        if (definition == null) {
            return null;
        }
        Object service = definition.getServices().get(serviceName);
        if (service != null) {
            return definition;
        }
        for (Object i : definition.getImports().values()) {
            List imports = (List)i;
            for (Import imp : imports) {
                Definition d = Axis2ServiceClient.getDefinition(imp.getDefinition(), serviceName);
                if (d == null) continue;
                return d;
            }
        }
        return null;
    }

    @Deprecated
    public static AxisService createClientSideAxisService(Definition definition, QName serviceName, String portName, Options options) throws AxisFault {
        AxisService axisService;
        Definition def = Axis2ServiceClient.getDefinition(definition, serviceName);
        final WSDL11ToAxisServiceBuilder serviceBuilder = new WSDL11ToAxisServiceBuilder(def, serviceName, portName);
        serviceBuilder.setServerSide(false);
        serviceBuilder.setCustomResolver((URIResolver)new URIResolverImpl(def));
        serviceBuilder.setBaseUri(def.getDocumentBaseURI());
        try {
            axisService = AccessController.doPrivileged(new PrivilegedExceptionAction<AxisService>(){

                @Override
                public AxisService run() throws AxisFault {
                    return serviceBuilder.populateService();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (AxisFault)((Object)e.getException());
        }
        AxisEndpoint axisEndpoint = (AxisEndpoint)axisService.getEndpoints().get(axisService.getEndpointName());
        options.setTo(new EndpointReference(axisEndpoint.getEndpointURL()));
        if (axisEndpoint != null) {
            options.setSoapVersionURI((String)axisEndpoint.getBinding().getProperty("wsoap:version"));
        }
        return axisService;
    }

    protected void stop() {
        if (this.serviceClient != null) {
            HttpClient httpClient = (HttpClient)this.serviceClient.getServiceContext().getConfigurationContext().getProperty("CACHED_HTTP_CLIENT");
            if (httpClient != null) {
                ((MultiThreadedHttpConnectionManager)httpClient.getHttpConnectionManager()).shutdown();
            }
            this.serviceClient = null;
        }
    }

    protected Invoker createInvoker(Operation operation) {
        Options options = new Options();
        EndpointReference epTo = this.getWSATOEPR(this.wsBinding);
        if (epTo != null) {
            options.setTo(epTo);
        }
        options.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        String operationName = operation.getName();
        String soapAction = this.getSOAPAction(operationName);
        if (soapAction != null && soapAction.length() > 1) {
            options.setAction(soapAction);
        }
        options.setTimeOutInMilliSeconds(30000L);
        SOAPFactory soapFactory = AccessController.doPrivileged(new PrivilegedAction<SOAPFactory>(){

            @Override
            public SOAPFactory run() {
                if (Axis2ServiceClient.this.requiresSOAP12()) {
                    return OMAbstractFactory.getSOAP12Factory();
                }
                return OMAbstractFactory.getSOAP11Factory();
            }
        });
        QName wsdlOperationQName = new QName(operationName);
        if (this.requiresMTOM()) {
            options.setProperty("enableMTOM", (Object)"true");
        }
        Axis2BindingInvoker invoker = operation.isNonBlocking() ? new Axis2OneWayBindingInvoker(this, wsdlOperationQName, options, soapFactory, this.policyHandlerList, this.wsBinding) : new Axis2BindingInvoker(this, wsdlOperationQName, options, soapFactory, this.policyHandlerList, this.wsBinding);
        return invoker;
    }

    private boolean requiresSOAP12() {
        return AxisPolicyHelper.isIntentRequired(this.wsBinding, AxisPolicyHelper.SOAP12_INTENT);
    }

    private boolean requiresMTOM() {
        return AxisPolicyHelper.isIntentRequired(this.wsBinding, AxisPolicyHelper.MTOM_INTENT);
    }

    protected EndpointReference getWSATOEPR(WebServiceBinding binding) {
        EndpointReference bindingEPR;
        EndpointReference epr = this.getEPR(binding);
        if (epr == null) {
            epr = this.getPortLocationEPR(binding);
        } else if ((epr.getAddress() == null || epr.getAddress().length() < 1) && (bindingEPR = this.getPortLocationEPR(binding)) != null) {
            epr.setAddress(bindingEPR.getAddress());
        }
        return epr;
    }

    protected EndpointReference getPortLocationEPR(WebServiceBinding binding) {
        String ep = null;
        if (binding.getPort() != null) {
            List wsdlPortExtensions = binding.getPort().getExtensibilityElements();
            for (Object extension : wsdlPortExtensions) {
                if (extension instanceof SOAPAddress) {
                    ep = ((SOAPAddress)extension).getLocationURI();
                    break;
                }
                if (!(extension instanceof SOAP12Address)) continue;
                SOAP12Address address = (SOAP12Address)extension;
                ep = address.getLocationURI();
                break;
            }
        }
        if (ep == null || ep.equals("")) {
            ep = binding.getURI();
        }
        return ep == null || "".equals(ep) ? null : new EndpointReference(ep);
    }

    protected EndpointReference getEPR(WebServiceBinding wsBinding) {
        if (wsBinding.getEndPointReference() == null) {
            return null;
        }
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new DOMSource(wsBinding.getEndPointReference()));
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement omElement = builder.getDocumentElement();
            EndpointReference epr = EndpointReferenceHelper.fromOM((OMElement)omElement);
            return epr;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    protected String getSOAPAction(String operationName) {
        Binding binding = this.wsBinding.getBinding();
        if (binding != null) {
            for (Object o : binding.getBindingOperations()) {
                BindingOperation bop = (BindingOperation)o;
                if (!bop.getName().equalsIgnoreCase(operationName)) continue;
                for (Object o2 : bop.getExtensibilityElements()) {
                    if (!(o2 instanceof SOAPOperation)) continue;
                    return ((SOAPOperation)o2).getSoapActionURI();
                }
            }
        }
        return null;
    }

    private void createPolicyHandlers() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.wsBinding instanceof PolicySetAttachPoint) {
            PolicySetAttachPoint policiedBinding = (PolicySetAttachPoint)((Object)this.wsBinding);
            PolicyHandler policyHandler = null;
            for (PolicySet policySet : policiedBinding.getPolicySets()) {
                policyHandler = PolicyHandlerUtils.findPolicyHandler(policySet, this.policyHandlerClassnames);
                if (policyHandler == null) continue;
                policyHandler.setApplicablePolicySet(policySet);
                this.policyHandlerList.add(policyHandler);
            }
        }
    }

    private void setupPolicyHandlers(List<PolicyHandler> policyHandlers, ConfigurationContext configContext) {
        for (PolicyHandler aHandler : policyHandlers) {
            aHandler.setUp(configContext);
        }
    }

    public static class URIResolverImpl
    implements URIResolver {
        private Definition definition;

        public URIResolverImpl(Definition definition) {
            this.definition = definition;
        }

        public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
            try {
                if (baseUri == null) {
                    baseUri = this.definition.getDocumentBaseURI();
                }
                URL url = new URL(new URL(baseUri), schemaLocation);
                return XMLDocumentHelper.getInputSource(url);
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

