/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.WSDLToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2BindingInvoker;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ServiceClient;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ServiceInMessageReceiver;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ServiceInOutSyncMessageReceiver;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ServiceServlet;
import org.apache.tuscany.sca.binding.ws.axis2.AxisPolicyHelper;
import org.apache.tuscany.sca.binding.ws.axis2.TuscanyAxisConfigurator;
import org.apache.tuscany.sca.binding.ws.axis2.jms.JMSListener;
import org.apache.tuscany.sca.binding.ws.axis2.jms.JMSSender;
import org.apache.tuscany.sca.binding.ws.axis2.policy.authentication.token.Axis2TokenAuthenticationPolicy;
import org.apache.tuscany.sca.binding.ws.axis2.policy.configuration.Axis2ConfigParamPolicy;
import org.apache.tuscany.sca.binding.ws.axis2.policy.configurator.Axis2BindingBasicAuthenticationConfigurator;
import org.apache.tuscany.sca.binding.ws.axis2.policy.configurator.Axis2BindingHeaderConfigurator;
import org.apache.tuscany.sca.binding.ws.axis2.policy.header.Axis2HeaderPolicy;
import org.apache.tuscany.sca.binding.ws.axis2.policy.header.Axis2SOAPHeaderString;
import org.apache.tuscany.sca.core.assembly.EndpointReferenceImpl;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;
import org.apache.tuscany.sca.policy.util.PolicyHandler;
import org.apache.tuscany.sca.policy.util.PolicyHandlerTuple;
import org.apache.tuscany.sca.policy.util.PolicyHandlerUtils;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.handler.WSHandlerResult;
import org.osoa.sca.ServiceRuntimeException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2ServiceProvider {
    public static final String IMPORT_TAG = "import";
    public static final String INCLUDE_TAG = "include";
    private static final Logger logger = Logger.getLogger(Axis2ServiceProvider.class.getName());
    private RuntimeComponent component;
    private AbstractContract contract;
    private WebServiceBinding wsBinding;
    private ServletHost servletHost;
    private MessageFactory messageFactory;
    private ConfigurationContext configContext;
    private JMSSender jmsSender;
    private JMSListener jmsListener;
    private List<PolicyHandlerTuple> policyHandlerClassnames = null;
    private List<PolicyHandler> policyHandlerList = new ArrayList<PolicyHandler>();
    private Map<String, Port> urlMap = new HashMap<String, Port>();
    private BasicAuthenticationPolicy basicAuthenticationPolicy = null;
    private Axis2TokenAuthenticationPolicy axis2TokenAuthenticationPolicy = null;
    private List<Axis2HeaderPolicy> axis2HeaderPolicies = new ArrayList<Axis2HeaderPolicy>();
    private WorkScheduler workScheduler;
    public static final QName QNAME_WSA_ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "Address");
    public static final QName QNAME_WSA_FROM = new QName("http://www.w3.org/2005/08/addressing", "From");
    public static final QName QNAME_WSA_REFERENCE_PARAMETERS = new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters");
    private static final QName TRANSPORT_JMS_QUALIFIED_INTENT = new QName("http://www.osoa.org/xmlns/sca/1.0", "transport.jms");
    private static final String DEFAULT_QUEUE_CONNECTION_FACTORY = "TuscanyQueueConnectionFactory";
    public static final String ELEM_SCHEMA = "schema";
    public static final String NS_URI_XSD_1999 = "http://www.w3.org/1999/XMLSchema";
    public static final String NS_URI_XSD_2000 = "http://www.w3.org/2000/10/XMLSchema";
    public static final String NS_URI_XSD_2001 = "http://www.w3.org/2001/XMLSchema";
    public static final QName Q_ELEM_XSD_1999 = new QName("http://www.w3.org/1999/XMLSchema", "schema");
    public static final QName Q_ELEM_XSD_2000 = new QName("http://www.w3.org/2000/10/XMLSchema", "schema");
    public static final QName Q_ELEM_XSD_2001 = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    public static final List<QName> XSD_QNAME_LIST = Arrays.asList(Q_ELEM_XSD_1999, Q_ELEM_XSD_2000, Q_ELEM_XSD_2001);

    public Axis2ServiceProvider(RuntimeComponent component, AbstractContract contract, WebServiceBinding wsBinding, ServletHost servletHost, MessageFactory messageFactory, List<PolicyHandlerTuple> policyHandlerClassnames, WorkScheduler workScheduler) {
        this.component = component;
        this.contract = contract;
        this.wsBinding = wsBinding;
        this.servletHost = servletHost;
        this.messageFactory = messageFactory;
        this.policyHandlerClassnames = policyHandlerClassnames;
        this.workScheduler = workScheduler;
        final boolean isRampartRequired = AxisPolicyHelper.isRampartRequired(wsBinding);
        try {
            TuscanyAxisConfigurator tuscanyAxisConfigurator = AccessController.doPrivileged(new PrivilegedExceptionAction<TuscanyAxisConfigurator>(){

                @Override
                public TuscanyAxisConfigurator run() throws AxisFault {
                    return new TuscanyAxisConfigurator(isRampartRequired);
                }
            });
            this.configContext = tuscanyAxisConfigurator.getConfigurationContext();
        }
        catch (PrivilegedActionException e) {
            throw new ServiceRuntimeException(e.getException());
        }
        catch (AxisFault e) {
            throw new ServiceRuntimeException(e);
        }
        this.configContext.setContextRoot(servletHost.getContextPath());
        if (AxisPolicyHelper.isIntentRequired(wsBinding, AxisPolicyHelper.MTOM_INTENT)) {
            this.configContext.getAxisConfiguration().getParameter("enableMTOM").setLocked(false);
            this.configContext.getAxisConfiguration().getParameter("enableMTOM").setValue((Object)"true");
        }
        for (Object port : wsBinding.getService().getPorts().values()) {
            String portAddress = Axis2ServiceProvider.getPortAddress((Port)port);
            String endpointURI = this.computeEndpointURI(portAddress, servletHost);
            Axis2ServiceProvider.setPortAddress((Port)port, endpointURI);
            this.urlMap.put(endpointURI, (Port)port);
        }
        if (wsBinding instanceof PolicySetAttachPoint) {
            List<PolicySet> policySets = ((PolicySetAttachPoint)((Object)wsBinding)).getPolicySets();
            for (PolicySet ps : policySets) {
                for (Object p : ps.getPolicies()) {
                    if (BasicAuthenticationPolicy.class.isInstance(p)) {
                        this.basicAuthenticationPolicy = (BasicAuthenticationPolicy)p;
                        continue;
                    }
                    if (Axis2TokenAuthenticationPolicy.class.isInstance(p)) {
                        this.axis2TokenAuthenticationPolicy = (Axis2TokenAuthenticationPolicy)p;
                        continue;
                    }
                    if (!Axis2HeaderPolicy.class.isInstance(p)) continue;
                    this.axis2HeaderPolicies.add((Axis2HeaderPolicy)p);
                }
            }
        }
    }

    static String getPortAddress(Port port) {
        Object ext = port.getExtensibilityElements().get(0);
        if (ext instanceof SOAPAddress) {
            return ((SOAPAddress)ext).getLocationURI();
        }
        if (ext instanceof SOAP12Address) {
            return ((SOAP12Address)ext).getLocationURI();
        }
        return null;
    }

    static void setPortAddress(Port port, String locationURI) {
        Object ext = port.getExtensibilityElements().get(0);
        if (ext instanceof SOAPAddress) {
            ((SOAPAddress)ext).setLocationURI(locationURI);
        }
        if (ext instanceof SOAP12Address) {
            ((SOAP12Address)ext).setLocationURI(locationURI);
        }
    }

    private String computeEndpointURI(String uri, ServletHost servletHost) {
        if (uri == null) {
            return null;
        }
        PolicySet transportJmsPolicySet = AxisPolicyHelper.getPolicySet(this.wsBinding, TRANSPORT_JMS_QUALIFIED_INTENT);
        if (transportJmsPolicySet != null) {
            if (!uri.startsWith("jms:/")) {
                uri = "jms:" + uri;
            }
            Axis2ConfigParamPolicy axis2ConfigParamPolicy = null;
            for (Object policy : transportJmsPolicySet.getPolicies()) {
                Iterator paramIterator;
                if (!(policy instanceof Axis2ConfigParamPolicy) || !(paramIterator = (axis2ConfigParamPolicy = (Axis2ConfigParamPolicy)policy).getParamElements().get(DEFAULT_QUEUE_CONNECTION_FACTORY).getChildElements()).hasNext()) continue;
                StringBuffer uriParams = new StringBuffer("?");
                while (paramIterator.hasNext()) {
                    OMElement parameter = (OMElement)paramIterator.next();
                    uriParams.append(parameter.getAttributeValue(new QName("", "name")));
                    uriParams.append("=");
                    uriParams.append(parameter.getText());
                    if (!paramIterator.hasNext()) continue;
                    uriParams.append("&");
                }
                uri = uri + uriParams;
            }
        } else if (!uri.startsWith("jms:")) {
            uri = servletHost.getURLMapping(uri).toString();
        }
        return uri;
    }

    public void start() {
        try {
            this.createPolicyHandlers();
            for (Map.Entry<String, Port> entry : this.urlMap.entrySet()) {
                AxisService axisService = this.createAxisService(entry.getKey(), entry.getValue());
                this.configContext.getAxisConfiguration().addService(axisService);
            }
            this.setupPolicyHandlers(this.policyHandlerList, this.configContext);
            Axis2ServiceServlet servlet = null;
            for (String endpointURL : this.urlMap.keySet()) {
                if (endpointURL.startsWith("http://") || endpointURL.startsWith("https://") || endpointURL.startsWith("/")) {
                    if (servlet == null) {
                        servlet = new Axis2ServiceServlet();
                        servlet.init(this.configContext);
                    }
                    this.servletHost.addServletMapping(endpointURL, (Servlet)servlet);
                    continue;
                }
                if (!endpointURL.startsWith("jms")) continue;
                logger.log(Level.INFO, "Axis2 JMS URL=" + endpointURL);
                this.jmsListener = new JMSListener(this.workScheduler);
                this.jmsSender = new JMSSender();
                ListenerManager listenerManager = this.configContext.getListenerManager();
                TransportInDescription trsIn = this.configContext.getAxisConfiguration().getTransportIn("jms");
                if (trsIn == null) {
                    trsIn = new TransportInDescription("jms");
                }
                Hashtable jmsProps = JMSUtils.getProperties((String)endpointURL);
                OMFactory fac = OMAbstractFactory.getOMFactory();
                OMElement parms = fac.createOMElement(DEFAULT_QUEUE_CONNECTION_FACTORY, null);
                for (String key : jmsProps.keySet()) {
                    OMElement param = fac.createOMElement("parameter", null);
                    param.addAttribute("name", key, null);
                    param.addChild((OMNode)fac.createOMText((OMContainer)param, (String)jmsProps.get(key)));
                    parms.addChild((OMNode)param);
                }
                Parameter queueConnectionFactory = new Parameter(DEFAULT_QUEUE_CONNECTION_FACTORY, (Object)parms);
                trsIn.addParameter(queueConnectionFactory);
                trsIn.setReceiver((TransportListener)this.jmsListener);
                this.configContext.getAxisConfiguration().addTransportIn(trsIn);
                TransportOutDescription trsOut = this.configContext.getAxisConfiguration().getTransportOut("jms");
                trsOut.setSender((TransportSender)this.jmsSender);
                if (listenerManager == null) {
                    listenerManager = new ListenerManager();
                    listenerManager.init(this.configContext);
                }
                listenerManager.addListener(trsIn, true);
                this.jmsSender.init(this.configContext, trsOut);
                this.jmsListener.init(this.configContext, trsIn);
                this.jmsListener.start();
            }
        }
        catch (AxisFault e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.jmsListener != null) {
            this.jmsListener.stop();
            this.jmsListener.destroy();
        } else {
            for (String endpointURL : this.urlMap.keySet()) {
                this.servletHost.removeServletMapping(endpointURL);
            }
        }
        this.servletHost = null;
        if (this.jmsSender != null) {
            this.jmsSender.stop();
        }
        try {
            for (String endpointURL : this.urlMap.keySet()) {
                URI uriPath = new URI(endpointURL);
                String stringURIPath = uriPath.getPath();
                this.configContext.getAxisConfiguration().removeService(stringURIPath);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (AxisFault e) {
            throw new RuntimeException(e);
        }
    }

    private AxisService createAxisService(String endpointURL, Port port) throws AxisFault {
        AxisService axisService = this.wsBinding.getWSDLDocument() != null ? this.createWSDLAxisService(endpointURL, port) : this.createJavaAxisService(endpointURL);
        this.initAxisOperations(axisService);
        return axisService;
    }

    protected AxisService createJavaAxisService(String endpointURL) throws AxisFault {
        AxisService axisService = new AxisService();
        String path = URI.create(endpointURL).getPath();
        axisService.setName(path);
        axisService.setServiceDescription("Tuscany configured AxisService for service: " + endpointURL);
        axisService.setClientSide(false);
        Parameter classParam = new Parameter("ServiceClass", (Object)((JavaInterface)this.contract.getInterfaceContract().getInterface()).getJavaClass().getName());
        axisService.addParameter(classParam);
        try {
            Utils.fillAxisService((AxisService)axisService, (AxisConfiguration)this.configContext.getAxisConfiguration(), null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return axisService;
    }

    private static Definition getDefinition(Definition definition, QName serviceName) {
        if (serviceName == null) {
            return definition;
        }
        if (definition == null) {
            return null;
        }
        Object service = definition.getServices().get(serviceName);
        if (service != null) {
            return definition;
        }
        for (Object i : definition.getImports().values()) {
            List imports = (List)i;
            for (Import imp : imports) {
                Definition d = Axis2ServiceProvider.getDefinition(imp.getDefinition(), serviceName);
                if (d == null) continue;
                return d;
            }
        }
        return null;
    }

    protected AxisService createWSDLAxisService(String endpointURL, Port port) throws AxisFault {
        AxisService axisService;
        Definition definition = this.wsBinding.getWSDLDocument();
        QName serviceQName = this.wsBinding.getService().getQName();
        Definition def = Axis2ServiceProvider.getDefinition(definition, serviceQName);
        WSDL11ToAxisServiceBuilder builder = new WSDL11ToAxisServiceBuilder(def, serviceQName, port.getName());
        builder.setServerSide(true);
        builder.setCustomResolver((URIResolver)new Axis2ServiceClient.URIResolverImpl(def));
        builder.setBaseUri(def.getDocumentBaseURI());
        try {
            axisService = AccessController.doPrivileged(new PrivilegedExceptionAction<AxisService>((WSDLToAxisServiceBuilder)builder){
                final /* synthetic */ WSDLToAxisServiceBuilder val$builder;
                {
                    this.val$builder = wSDLToAxisServiceBuilder;
                }

                @Override
                public AxisService run() throws AxisFault {
                    return this.val$builder.populateService();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (AxisFault)((Object)e.getException());
        }
        String name = URI.create(endpointURL).getPath();
        if (endpointURL.startsWith("jms")) {
            name = name.startsWith("/") ? name.substring(1) : name;
        }
        axisService.setName(name);
        axisService.setEndpointURL(endpointURL);
        axisService.setDocumentation("Tuscany configured AxisService for service: " + endpointURL);
        for (AxisEndpoint ae : axisService.getEndpoints().values()) {
            if (!endpointURL.startsWith("jms")) continue;
            Parameter qcf = new Parameter("transport.jms.ConnectionFactory", null);
            qcf.setValue((Object)DEFAULT_QUEUE_CONNECTION_FACTORY);
            axisService.addParameter(qcf);
            break;
        }
        this.addSchemas(this.wsBinding.getWSDLDefinition(), axisService);
        Parameter wsdlParam = new Parameter("wsdl4jDefinition", null);
        wsdlParam.setValue((Object)definition);
        axisService.addParameter(wsdlParam);
        Parameter userWSDL = new Parameter("useOriginalwsdl", (Object)"true");
        axisService.addParameter(userWSDL);
        this.modifySchemaImportsAndIncludes(definition, name);
        Parameter modifyAddr = new Parameter("modifyUserWSDLPortAddress", (Object)"false");
        axisService.addParameter(modifyAddr);
        return axisService;
    }

    private void addSchemas(WSDLDefinition wsdlDef, AxisService axisService) {
        for (XSDefinition xsDef : wsdlDef.getXmlSchemas()) {
            if (xsDef.getSchema() == null) continue;
            axisService.addSchema(xsDef.getSchema());
            this.updateSchemaRefs(xsDef.getSchema(), axisService.getName());
        }
        for (WSDLDefinition impDef : wsdlDef.getImportedDefinitions()) {
            this.addSchemas(impDef, axisService);
        }
    }

    private void updateSchemaRefs(XmlSchema parentSchema, String name) {
        Iterator iter = parentSchema.getIncludes().getIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof XmlSchemaExternal)) continue;
            XmlSchemaExternal extSchema = (XmlSchemaExternal)obj;
            String location = extSchema.getSchemaLocation();
            if (location.length() > 0 && location.indexOf(":/") < 0 && location.indexOf("?xsd=") < 0) {
                extSchema.setSchemaLocation(name + "?xsd=" + location);
            }
            if (extSchema.getSchema() == null) continue;
            this.updateSchemaRefs(extSchema.getSchema(), name);
        }
    }

    private void modifySchemaImportsAndIncludes(Definition definition, String name) {
        Types types = definition.getTypes();
        if (types != null) {
            for (Object ext : types.getExtensibilityElements()) {
                if (!(ext instanceof UnknownExtensibilityElement) || !XSD_QNAME_LIST.contains(((UnknownExtensibilityElement)ext).getElementType())) continue;
                this.changeLocations(((UnknownExtensibilityElement)ext).getElement(), name);
            }
        }
        for (Vector values : definition.getImports().values()) {
            for (Import wsdlImport : values) {
                this.modifySchemaImportsAndIncludes(wsdlImport.getDefinition(), name);
            }
        }
    }

    private void changeLocations(Element element, String name) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String tagName = nodeList.item(i).getLocalName();
            if (!IMPORT_TAG.equals(tagName) && !INCLUDE_TAG.equals(tagName)) continue;
            this.processImport(nodeList.item(i), name);
        }
    }

    private void processImport(Node importNode, String name) {
        NamedNodeMap nodeMap = importNode.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            String location;
            Node attribute = nodeMap.item(i);
            if (!attribute.getNodeName().equals("schemaLocation") || !((location = attribute.getNodeValue()).indexOf(":/") < 0 & location.indexOf("?xsd=") < 0)) continue;
            attribute.setNodeValue(name + "?xsd=" + location);
        }
    }

    protected void initAxisOperations(AxisService axisService) {
        Iterator i = axisService.getOperations();
        while (i.hasNext()) {
            AxisOperation axisOp = (AxisOperation)i.next();
            Operation op = this.getOperation(axisOp);
            if (op == null) continue;
            if (op.isNonBlocking()) {
                axisOp.setMessageExchangePattern("http://www.w3.org/ns/wsdl/in-only");
            } else {
                axisOp.setMessageExchangePattern("http://www.w3.org/ns/wsdl/in-out");
            }
            Object msgrec = null;
            msgrec = op.isNonBlocking() ? new Axis2ServiceInMessageReceiver(this, op, this.policyHandlerList) : new Axis2ServiceInOutSyncMessageReceiver(this, op, this.policyHandlerList);
            axisOp.setMessageReceiver((MessageReceiver)msgrec);
        }
    }

    protected Operation getOperation(AxisOperation axisOp) {
        String operationName = axisOp.getName().getLocalPart();
        Interface iface = this.wsBinding.getBindingInterfaceContract().getInterface();
        for (Operation op : iface.getOperations()) {
            if (!op.getName().equalsIgnoreCase(operationName)) continue;
            return op;
        }
        return null;
    }

    public Object invokeTarget(Operation op, Object[] args, MessageContext inMC) throws InvocationTargetException {
        String callbackAddress = null;
        String callbackID = null;
        String conversationID = null;
        Message msg = this.messageFactory.createMessage();
        msg.setBody(args);
        msg.setOperation(op);
        SOAPHeader header = inMC.getEnvelope().getHeader();
        if (header != null) {
            List<Object> hdrList = msg.getHeaders();
            Iterator it = header.getChildElements();
            while (it.hasNext()) {
                hdrList.add(it.next());
            }
            OMElement from = header.getFirstChildWithName(QNAME_WSA_FROM);
            if (from != null) {
                OMElement params;
                OMElement callbackAddrElement = from.getFirstChildWithName(QNAME_WSA_ADDRESS);
                if (callbackAddrElement != null && this.contract.getInterfaceContract().getCallbackInterface() != null) {
                    callbackAddress = callbackAddrElement.getText();
                }
                if ((params = from.getFirstChildWithName(QNAME_WSA_REFERENCE_PARAMETERS)) != null) {
                    OMElement callbackIDElement;
                    OMElement convIDElement = params.getFirstChildWithName(Axis2BindingInvoker.CONVERSATION_ID_REFPARM_QN);
                    if (convIDElement != null && this.isConversational()) {
                        conversationID = convIDElement.getText();
                    }
                    if ((callbackIDElement = params.getFirstChildWithName(Axis2BindingInvoker.CALLBACK_ID_REFPARM_QN)) != null) {
                        callbackID = callbackIDElement.getText();
                    }
                }
            }
            for (Axis2HeaderPolicy policy : this.axis2HeaderPolicies) {
            }
            if (this.axis2TokenAuthenticationPolicy != null) {
                Axis2SOAPHeaderString tokenHeader = new Axis2SOAPHeaderString();
                Axis2BindingHeaderConfigurator.getHeader(inMC, msg, this.axis2TokenAuthenticationPolicy.getTokenName(), tokenHeader);
            }
        }
        this.fillQoSContext(msg, inMC);
        EndpointReferenceImpl from = null;
        ReferenceParameters parameters = null;
        if (callbackAddress != null || callbackID != null || conversationID != null) {
            from = new EndpointReferenceImpl(null);
            parameters = from.getReferenceParameters();
            msg.setFrom(from);
        }
        if (callbackAddress != null) {
            parameters.setCallbackReference(new EndpointReferenceImpl(callbackAddress));
        }
        if (callbackID != null) {
            parameters.setCallbackID(callbackID);
        }
        if (conversationID != null) {
            parameters.setConversationID(conversationID);
        }
        for (PolicyHandler policyHandler : this.policyHandlerList) {
            policyHandler.beforeInvoke(msg, inMC);
        }
        if (this.basicAuthenticationPolicy != null) {
            Axis2BindingBasicAuthenticationConfigurator.parseHTTPHeader(inMC, msg, this.basicAuthenticationPolicy);
        }
        RuntimeWire wire = ((RuntimeComponentService)this.contract).getRuntimeWire(this.getBinding());
        Object response = wire.invoke(op, msg);
        return response;
    }

    public boolean isConversational() {
        return this.wsBinding.getBindingInterfaceContract().getInterface().isConversational();
    }

    protected Binding getBinding() {
        return this.wsBinding;
    }

    private void setupPolicyHandlers(List<PolicyHandler> policyHandlers, ConfigurationContext configContext) {
        for (PolicyHandler aHandler : policyHandlers) {
            aHandler.setUp(configContext);
        }
    }

    private void createPolicyHandlers() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.wsBinding instanceof PolicySetAttachPoint) {
            PolicySetAttachPoint policiedBinding = (PolicySetAttachPoint)((Object)this.wsBinding);
            PolicyHandler policyHandler = null;
            for (PolicySet policySet : policiedBinding.getPolicySets()) {
                policyHandler = PolicyHandlerUtils.findPolicyHandler(policySet, this.policyHandlerClassnames);
                if (policyHandler == null) continue;
                policyHandler.setApplicablePolicySet(policySet);
                this.policyHandlerList.add(policyHandler);
            }
        }
    }

    private void fillQoSContext(Message message, MessageContext axis2MsgCtx) {
        if (axis2MsgCtx.getProperty("RECV_RESULTS") != null && axis2MsgCtx.getProperty("RECV_RESULTS") instanceof Vector) {
            Vector recvResults = (Vector)axis2MsgCtx.getProperty("RECV_RESULTS");
            for (int count1 = 0; count1 < recvResults.size(); ++count1) {
                if (!(recvResults.elementAt(count1) instanceof WSHandlerResult)) continue;
                WSHandlerResult wshr = (WSHandlerResult)recvResults.elementAt(count1);
                Vector results = wshr.getResults();
                for (int count2 = 0; count2 < results.size(); ++count2) {
                    WSSecurityEngineResult securityResult;
                    if (!(results.elementAt(count2) instanceof WSSecurityEngineResult) || (securityResult = (WSSecurityEngineResult)wshr.getResults().elementAt(count2)).get((Object)"principal") == null) continue;
                    message.getHeaders().add(securityResult.get((Object)"principal"));
                }
            }
        }
    }
}

