/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.AxisServlet;
import org.apache.axis2.transport.http.ListingAgent;
import org.apache.axis2.transport.http.server.HttpUtils;
import org.apache.tuscany.sca.binding.ws.axis2.TuscanyListenerManager;
import org.apache.tuscany.sca.binding.ws.axis2.TuscanyListingAgent;

public class Axis2ServiceServlet
extends AxisServlet {
    protected TuscanyListingAgent agent;
    private static final long serialVersionUID = 1L;
    private static final ServletConfig DUMMY_CONFIG = Axis2ServiceServlet.createDummyServletConfig();
    private boolean initCalled = false;
    private ConfigurationContext tmpconfigContext;

    public void init(ConfigurationContext configContext) {
        this.tmpconfigContext = configContext;
        try {
            this.init(DUMMY_CONFIG);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.agent = new TuscanyListingAgent(configContext);
    }

    public void init() throws ServletException {
    }

    public void init(ServletConfig config) throws ServletException {
        ServletContext servletContext = config.getServletContext();
        servletContext.setAttribute("CONFIGURATION_CONTEXT", (Object)this.tmpconfigContext);
        if (!this.initCalled) {
            this.initCalled = true;
            try {
                Field field = GenericServlet.class.getDeclaredField("config");
                field.setAccessible(true);
                field.set((Object)this, config);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                this.servletConfig = config;
                this.configContext = (ConfigurationContext)servletContext.getAttribute("CONFIGURATION_CONTEXT");
                if (this.configContext == null) {
                    this.configContext = this.initConfigContext(config);
                    config.getServletContext().setAttribute("CONFIGURATION_CONTEXT", (Object)this.configContext);
                }
                this.axisConfiguration = this.configContext.getAxisConfiguration();
                TuscanyListenerManager listenerManager = new TuscanyListenerManager();
                listenerManager.init(this.configContext);
                TransportInDescription transportInDescription = new TransportInDescription("http");
                transportInDescription.setReceiver((TransportListener)this);
                listenerManager.addListener(transportInDescription, true);
                listenerManager.start();
                ListenerManager.defaultConfigurationContext = this.configContext;
                ((AxisServlet)this).agent = new ListingAgent(this.configContext);
                this.initParams();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected ConfigurationContext initConfigContext(ServletConfig config) throws ServletException {
        return this.tmpconfigContext;
    }

    public ServletConfig getServletConfig() {
        return DUMMY_CONFIG;
    }

    public String getServletName() {
        return "TuscanyAxis2Servlet";
    }

    private static ServletConfig createDummyServletConfig() {
        ServletConfig sc = new ServletConfig(){

            public String getServletName() {
                return "TuscanyAxis2DummyServlet";
            }

            public ServletContext getServletContext() {
                return new ServletContext(){

                    public ServletContext getContext(String uripath) {
                        return null;
                    }

                    public String getContextPath() {
                        return null;
                    }

                    public int getMajorVersion() {
                        return 0;
                    }

                    public int getMinorVersion() {
                        return 0;
                    }

                    public String getMimeType(String file) {
                        return null;
                    }

                    public Set<?> getResourcePaths(String path) {
                        return Collections.emptySet();
                    }

                    public URL getResource(String path) throws MalformedURLException {
                        if ("/".equals(path)) {
                            return new URL("/axis2");
                        }
                        return null;
                    }

                    public InputStream getResourceAsStream(String path) {
                        return null;
                    }

                    public RequestDispatcher getRequestDispatcher(String path) {
                        return null;
                    }

                    public RequestDispatcher getNamedDispatcher(String arg0) {
                        return null;
                    }

                    public Servlet getServlet(String arg0) throws ServletException {
                        return null;
                    }

                    public Enumeration getServlets() {
                        return null;
                    }

                    public Enumeration getServletNames() {
                        return null;
                    }

                    public void log(String arg0) {
                    }

                    public void log(Exception arg0, String arg1) {
                    }

                    public void log(String arg0, Throwable arg1) {
                    }

                    public String getRealPath(String arg0) {
                        return null;
                    }

                    public String getServerInfo() {
                        return null;
                    }

                    public String getInitParameter(String arg0) {
                        return null;
                    }

                    public Enumeration getInitParameterNames() {
                        return null;
                    }

                    public Object getAttribute(String arg0) {
                        return null;
                    }

                    public Enumeration getAttributeNames() {
                        return null;
                    }

                    public void setAttribute(String arg0, Object arg1) {
                    }

                    public void removeAttribute(String arg0) {
                    }

                    public String getServletContextName() {
                        return null;
                    }
                };
            }

            public String getInitParameter(String arg0) {
                return null;
            }

            public Enumeration getInitParameterNames() {
                return new Vector().elements();
            }
        };
        return sc;
    }

    public void destroy() {
        try {
            super.destroy();
            this.servletConfig = null;
            if (this.tmpconfigContext.getListenerManager() != null) {
                this.tmpconfigContext.getListenerManager().destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initContextRoot(request);
        String query = request.getQueryString();
        if (query != null && (query.indexOf("wsdl2") >= 0 || query.indexOf("wsdl") >= 0 || query.indexOf("xsd") >= 0 || query.indexOf("policy") >= 0)) {
            this.agent.processListService(request, response);
        } else {
            super.doGet(request, response);
        }
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String port = (String)this.configContext.getProperty("RUNNING_PORT");
        if (port == null) {
            port = "8080";
        }
        if (ip == null) {
            try {
                ip = HttpUtils.getIpAddress();
                if (ip == null) {
                    ip = "localhost";
                }
            }
            catch (SocketException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        URI epURI = URI.create("http://" + ip + ":" + port + "/" + serviceName).normalize();
        return new EndpointReference[]{new EndpointReference(epURI.toString())};
    }
}

