/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPoint;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;

public class AxisPolicyHelper {
    public static final String XMLNS_SCA_1_0 = "http://www.osoa.org/xmlns/sca/1.0";
    public static final QName AUTHENTICATION_INTENT = new QName("http://www.osoa.org/xmlns/sca/1.0", "authentication");
    public static final QName CONFIDENTIALITY_INTENT = new QName("http://www.osoa.org/xmlns/sca/1.0", "confidentiality");
    public static final QName INTEGRITY_INTENT = new QName("http://www.osoa.org/xmlns/sca/1.0", "integrity");
    public static final QName MTOM_INTENT = new QName("http://www.osoa.org/xmlns/sca/1.0", "MTOM");
    public static final QName SOAP12_INTENT = new QName("http://www.osoa.org/xmlns/sca/1.0", "SOAP12");

    public static PolicySet getPolicySet(Binding wsBinding, QName intentName) {
        PolicySet returnPolicySet = null;
        if (wsBinding instanceof PolicySetAttachPoint) {
            PolicySetAttachPoint policiedBinding = (PolicySetAttachPoint)((Object)wsBinding);
            block0: for (PolicySet policySet : policiedBinding.getPolicySets()) {
                for (Intent intent : policySet.getProvidedIntents()) {
                    if (!intent.getName().equals(intentName)) continue;
                    returnPolicySet = policySet;
                    continue block0;
                }
            }
        }
        return returnPolicySet;
    }

    public static boolean isIntentRequired(Binding wsBinding, QName intent) {
        if (wsBinding instanceof IntentAttachPoint) {
            List<Intent> intents = ((IntentAttachPoint)((Object)wsBinding)).getRequiredIntents();
            for (Intent i : intents) {
                if (!intent.equals(i.getName())) continue;
                return true;
            }
        }
        return AxisPolicyHelper.getPolicySet(wsBinding, intent) != null;
    }

    public static boolean isRampartRequired(Binding wsBinding) {
        return AxisPolicyHelper.isIntentRequired(wsBinding, AUTHENTICATION_INTENT) || AxisPolicyHelper.isIntentRequired(wsBinding, INTEGRITY_INTENT) || AxisPolicyHelper.isIntentRequired(wsBinding, CONFIDENTIALITY_INTENT);
    }
}

