/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.URLBasedAxisConfigurator;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.Utils;

public class TuscanyAxisConfigurator
extends URLBasedAxisConfigurator
implements AxisConfigurator {
    private URL axis2_xml = TuscanyAxisConfigurator.getResource("/org/apache/tuscany/sca/binding/ws/axis2/engine/config/axis2.xml");
    private URL axis2_repository = null;
    private URL rampart_mar_url = TuscanyAxisConfigurator.getResource("/org/apache/tuscany/sca/binding/ws/axis2/engine/config/modules/rampart-1.4.mar");
    private boolean isRampartRequired;

    public TuscanyAxisConfigurator(boolean isRampartRequired) throws AxisFault {
        super(TuscanyAxisConfigurator.getResource("/org/apache/tuscany/sca/binding/ws/axis2/engine/config/axis2.xml"), null);
        this.isRampartRequired = isRampartRequired;
    }

    private static URL getResource(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return TuscanyAxisConfigurator.class.getResource(name);
            }
        });
    }

    public ConfigurationContext getConfigurationContext() throws AxisFault {
        if (this.configContext == null) {
            this.configContext = ConfigurationContextFactory.createConfigurationContext((AxisConfigurator)this);
        }
        return this.configContext;
    }

    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        block11: {
            try {
                InputStream axis2xmlStream = this.axis2_xml == null ? Loader.getResourceAsStream((String)"org/apache/axis2/deployment/axis2_default.xml") : this.axis2_xml.openStream();
                this.axisConfig = this.populateAxisConfiguration(axis2xmlStream);
                if (this.isRampartRequired) {
                    this.axisConfig.addGlobalModuleRef("rampart");
                }
                if (this.axis2_repository == null) {
                    Parameter axis2repoPara = this.axisConfig.getParameter("repository");
                    if (axis2repoPara != null) {
                        String repoValue = (String)axis2repoPara.getValue();
                        if (repoValue != null && !"".equals(repoValue.trim())) {
                            if (repoValue.startsWith("file:/")) {
                                this.loadRepository(repoValue);
                            } else {
                                this.loadRepositoryFromURL(new URL(repoValue));
                            }
                        }
                        break block11;
                    }
                    try {
                        this.loadFromClassPath();
                    }
                    catch (Exception e) {
                        if (this.isRampartRequired) {
                            this.loadRampartModule();
                        }
                        break block11;
                    }
                }
                this.loadRepositoryFromURL(this.axis2_repository);
            }
            catch (IOException e) {
                throw new AxisFault(e.getMessage());
            }
        }
        this.axisConfig.setConfigurator((AxisConfigurator)this);
        return this.axisConfig;
    }

    public void loadRampartModule() throws DeploymentException {
        try {
            ClassLoader deploymentClassLoader = org.apache.axis2.deployment.util.Utils.createClassLoader((URL[])new URL[]{this.rampart_mar_url}, (ClassLoader)this.axisConfig.getModuleClassLoader(), (boolean)true, (File)((File)this.axisConfig.getParameterValue("artifactsDIR")));
            final AxisModule module = new AxisModule();
            module.setModuleClassLoader(deploymentClassLoader);
            module.setParent(this.axisConfig);
            if (module.getName() == null) {
                module.setName(Utils.getModuleName((String)"rampart-1.4"));
                module.setVersion(Utils.getModuleVersion((String)"rampart-1.4"));
            }
            this.populateModule(module, this.rampart_mar_url);
            module.setFileName(this.rampart_mar_url);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        DeploymentEngine.addNewModule((AxisModule)module, (AxisConfiguration)TuscanyAxisConfigurator.this.axisConfig);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (AxisFault)((Object)e.getException());
            }
            Utils.calculateDefaultModuleVersion((HashMap)this.axisConfig.getModules(), (AxisConfiguration)this.axisConfig);
            this.axisConfig.validateSystemPredefinedPhases();
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private void populateModule(AxisModule module, URL moduleUrl) throws DeploymentException {
        try {
            ClassLoader classLoader = module.getModuleClassLoader();
            InputStream moduleStream = classLoader.getResourceAsStream("META-INF/module.xml");
            if (moduleStream == null) {
                moduleStream = classLoader.getResourceAsStream("meta-inf/module.xml");
            }
            if (moduleStream == null) {
                throw new DeploymentException(Messages.getMessage((String)"modulexmlnotfound", (String)moduleUrl.toString()));
            }
            ModuleBuilder moduleBuilder = new ModuleBuilder(moduleStream, module, this.axisConfig);
            moduleBuilder.populateModule();
        }
        catch (IOException e) {
            throw new DeploymentException((Throwable)e);
        }
    }
}

