/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.net.URI;
import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.RequestURIBasedDispatcher;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuscanyDispatcher
extends RequestURIBasedDispatcher {
    public static final String NAME = "TuscanyDispatcher";
    private static final Log log = LogFactory.getLog(RequestURIBasedDispatcher.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR != null) {
            if (isDebugEnabled) {
                log.debug((Object)("Checking for Service using target endpoint address : " + toEPR.getAddress()));
            }
            String path = URI.create(toEPR.getAddress()).getPath();
            ConfigurationContext configurationContext = messageContext.getConfigurationContext();
            AxisConfiguration registry = configurationContext.getAxisConfiguration();
            String serviceName = this.findAxisServiceName(registry, path);
            return registry.getService(serviceName);
        }
        if (isDebugEnabled) {
            log.debug((Object)"Attempted to check for Service using null target endpoint URI");
        }
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    protected String findAxisServiceName(AxisConfiguration registry, String path) {
        HashMap services = registry.getServices();
        if (services == null) {
            return null;
        }
        String[] parts = JavaUtils.split((String)path, (char)'/');
        String serviceName = "";
        for (int i = parts.length - 1; i >= 0; --i) {
            serviceName = parts[i] + serviceName;
            if (services.containsKey(serviceName)) {
                return serviceName;
            }
            serviceName = "/" + serviceName;
            if (!services.containsKey(serviceName)) continue;
            return serviceName;
        }
        return null;
    }
}

