/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.policy.configurator;

import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.policy.SecurityUtil;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPolicy;
import org.apache.tuscany.sca.policy.authentication.basic.BasicAuthenticationPrincipal;
import org.osoa.sca.ServiceRuntimeException;

public class Axis2BindingBasicAuthenticationConfigurator {
    public static void setOperationOptions(OperationClient operationClient, Message msg, BasicAuthenticationPolicy policy) {
        String username = null;
        String password = null;
        Subject subject = SecurityUtil.getSubject(msg);
        BasicAuthenticationPrincipal principal = SecurityUtil.getPrincipal(subject, BasicAuthenticationPrincipal.class);
        if (principal != null) {
            username = principal.getName();
            password = principal.getPassword();
        }
        if (username == null || password == null) {
            throw new ServiceRuntimeException("Basic authentication username or password is null");
        }
        HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
        ArrayList<String> auth = new ArrayList<String>();
        auth.add("Basic");
        authenticator.setAuthSchemes(auth);
        authenticator.setPreemptiveAuthentication(true);
        authenticator.setUsername(username);
        authenticator.setPassword(password);
        operationClient.getOptions().setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
    }

    public static void parseHTTPHeader(MessageContext messageContext, Message msg, BasicAuthenticationPolicy policy) {
        Map httpHeaderProperties = (Map)messageContext.getProperty("TRANSPORT_HEADERS");
        String basicAuthString = (String)httpHeaderProperties.get("Authorization");
        String decodedBasicAuthString = null;
        String username = null;
        String password = null;
        if (basicAuthString != null) {
            int collonIndex;
            if ((basicAuthString = basicAuthString.trim()).startsWith("Basic ")) {
                decodedBasicAuthString = new String(Base64.decode((String)basicAuthString.substring(6)));
            }
            if ((collonIndex = decodedBasicAuthString.indexOf(58)) == -1) {
                username = decodedBasicAuthString;
            } else {
                username = decodedBasicAuthString.substring(0, collonIndex);
                password = decodedBasicAuthString.substring(collonIndex + 1);
            }
        }
        Subject subject = SecurityUtil.getSubject(msg);
        BasicAuthenticationPrincipal principal = null;
        try {
            principal = new BasicAuthenticationPrincipal(username, password);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (principal == null) {
            throw new ServiceRuntimeException("User credentials for authentication expected");
        }
        subject.getPrincipals().add(principal);
    }
}

