/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.policy.header;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.ws.axis2.policy.header.Axis2HeaderPolicy;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2HeaderPolicyProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<Axis2HeaderPolicy> {
    @Override
    public QName getArtifactType() {
        return Axis2HeaderPolicy.AXIS2_HEADER_POLICY_QNAME;
    }

    public Axis2HeaderPolicyProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
    }

    @Override
    public Axis2HeaderPolicy read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        Axis2HeaderPolicy policy = new Axis2HeaderPolicy();
        int event = reader.getEventType();
        QName name = null;
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (!name.equals(this.getArtifactType())) break;
                    policy.setHeaderName(this.getQName(reader, "headerName"));
                }
            }
            if (event == 2 && this.getArtifactType().equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policy;
    }

    @Override
    public void write(Axis2HeaderPolicy policy, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, this.getArtifactType().getLocalPart(), this.getArtifactType().getNamespaceURI());
        writer.writeNamespace("tuscany", "http://tuscany.apache.org/xmlns/sca/1.0");
        if (policy.getHeaderName() != null) {
            writer.writeStartElement(prefix, "headerName", this.getArtifactType().getNamespaceURI());
            writer.writeCharacters(policy.getHeaderName().toString());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    public Class<Axis2HeaderPolicy> getModelType() {
        return Axis2HeaderPolicy.class;
    }

    @Override
    public void resolve(Axis2HeaderPolicy arg0, ModelResolver arg1) throws ContributionResolveException {
    }
}

