/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.xml;

import com.ibm.wsdl.OperationImpl;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.assembly.xml.ConfiguredOperationProcessor;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.binding.ws.DefaultWebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.xml.BindingBuilderImpl;
import org.apache.tuscany.sca.binding.ws.xml.EndPointReferenceHelper;
import org.apache.tuscany.sca.binding.ws.xml.WebServiceConstants;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionRuntimeException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLObject;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.IntentAttachPointTypeFactory;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceBindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<WebServiceBinding>,
WebServiceConstants {
    private ExtensionPointRegistry extensionPoints;
    private WSDLFactory wsdlFactory;
    private WebServiceBindingFactory wsFactory;
    private PolicyFactory policyFactory;
    private ExtensionFactory extensionFactory;
    private PolicyAttachPointProcessor policyProcessor;
    private IntentAttachPointTypeFactory intentAttachPointTypeFactory;
    private ConfiguredOperationProcessor configuredOperationProcessor;
    private StAXAttributeProcessor<Object> extensionAttributeProcessor;
    private Monitor monitor;

    public WebServiceBindingProcessor(ExtensionPointRegistry extensionPoints, Monitor monitor) {
        this.extensionPoints = extensionPoints;
        ModelFactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.wsFactory = new DefaultWebServiceBindingFactory();
        this.wsdlFactory = modelFactories.getFactory(WSDLFactory.class);
        this.extensionFactory = modelFactories.getFactory(ExtensionFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
        this.intentAttachPointTypeFactory = modelFactories.getFactory(IntentAttachPointTypeFactory.class);
        this.monitor = monitor;
        this.configuredOperationProcessor = new ConfiguredOperationProcessor(modelFactories, this.monitor);
        XMLInputFactory inputFactory = modelFactories.getFactory(XMLInputFactory.class);
        XMLOutputFactory outputFactory = modelFactories.getFactory(XMLOutputFactory.class);
        StAXAttributeProcessorExtensionPoint attributeExtensionPoint = extensionPoints.getExtensionPoint(StAXAttributeProcessorExtensionPoint.class);
        this.extensionAttributeProcessor = new ExtensibleStAXAttributeProcessor(attributeExtensionPoint, inputFactory, outputFactory, this.monitor);
    }

    private void warning(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "binding-wsxml-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "binding-wsxml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "binding-wsxml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    @Override
    public WebServiceBinding read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String uri;
        WebServiceBinding wsBinding = this.wsFactory.createWebServiceBinding();
        wsBinding.setUnresolved(true);
        wsBinding.setBuilder(new BindingBuilderImpl(this.extensionPoints));
        this.policyProcessor.readPolicies(wsBinding, reader);
        String name = reader.getAttributeValue(null, "name");
        if (name != null) {
            wsBinding.setName(name);
        }
        if ((uri = WebServiceBindingProcessor.getURIString(reader, "uri")) != null) {
            wsBinding.setURI(uri);
        }
        Boolean wsdlElementIsBinding = null;
        String wsdlElement = WebServiceBindingProcessor.getURIString(reader, "wsdlElement");
        if (wsdlElement != null) {
            int s;
            int index = wsdlElement.indexOf(35);
            if (index == -1) {
                this.error("InvalidWsdlElementAttr", (Object)reader, wsdlElement);
                return wsBinding;
            }
            String namespace = wsdlElement.substring(0, index);
            wsBinding.setNamespace(namespace);
            String localName = wsdlElement.substring(index + 1);
            if (localName.startsWith("wsdl.service")) {
                localName = localName.substring("wsdl.service(".length(), localName.length() - 1);
                wsBinding.setServiceName(new QName(namespace, localName));
            } else if (localName.startsWith("wsdl.port")) {
                s = (localName = localName.substring("wsdl.port(".length(), localName.length() - 1)).indexOf(47);
                if (s == -1) {
                    this.error("InvalidWsdlElementAttr", (Object)reader, wsdlElement);
                } else {
                    wsBinding.setServiceName(new QName(namespace, localName.substring(0, s)));
                    wsBinding.setPortName(localName.substring(s + 1));
                }
            } else if (localName.startsWith("wsdl.endpoint")) {
                s = (localName = localName.substring("wsdl.endpoint(".length(), localName.length() - 1)).indexOf(47);
                if (s == -1) {
                    this.error("InvalidWsdlElementAttr", (Object)reader, wsdlElement);
                } else {
                    wsBinding.setServiceName(new QName(namespace, localName.substring(0, s)));
                    wsBinding.setEndpointName(localName.substring(s + 1));
                }
            } else if (localName.startsWith("wsdl.binding")) {
                localName = localName.substring("wsdl.binding(".length(), localName.length() - 1);
                wsBinding.setBindingName(new QName(namespace, localName));
                wsdlElementIsBinding = true;
            } else {
                this.error("InvalidWsdlElementAttr", (Object)reader, wsdlElement);
            }
        }
        wsBinding.setLocation(reader.getAttributeValue("http://www.w3.org/2004/08/wsdl-instance", "wsdlLocation"));
        for (int a = 0; a < reader.getAttributeCount(); ++a) {
            QName attributeName = reader.getAttributeName(a);
            if (attributeName.getNamespaceURI() == null || attributeName.getNamespaceURI() == "http://www.w3.org/2004/08/wsdl-instance" || attributeName.getNamespaceURI().length() <= 0 || "http://www.osoa.org/xmlns/sca/1.0".equals(attributeName.getNamespaceURI()) || "http://tuscany.apache.org/xmlns/sca/1.0".equals(attributeName.getNamespaceURI())) continue;
            Object attributeValue = this.extensionAttributeProcessor.read(attributeName, reader);
            Extension attributeExtension = attributeValue instanceof Extension ? (Extension)attributeValue : this.extensionFactory.createExtension(attributeName, attributeValue, true);
            wsBinding.getAttributeExtensions().add(attributeExtension);
        }
        ConfiguredOperation confOp = null;
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if ("EndpointReference".equals(reader.getName().getLocalPart())) {
                        if (!(wsdlElement == null || wsdlElementIsBinding != null && wsdlElementIsBinding.booleanValue())) {
                            this.error("MustUseWsdlBinding", (Object)reader, wsdlElement);
                            throw new ContributionReadException(wsdlElement + " must use wsdl.binding when using wsa:EndpointReference");
                        }
                        wsBinding.setEndPointReference(EndPointReferenceHelper.readEndPointReference(reader));
                        break;
                    }
                    if (!Constants.OPERATION_QNAME.equals(reader.getName()) || (confOp = this.configuredOperationProcessor.read(reader)) == null) break;
                    ((OperationsConfigurator)((Object)wsBinding)).getConfiguredOperations().add(confOp);
                }
            }
            if (event != 2 || !BINDING_WS_QNAME.equals(reader.getName())) continue;
            break;
        }
        return wsBinding;
    }

    protected void processEndPointReference(XMLStreamReader reader, WebServiceBinding wsBinding) {
    }

    @Override
    public void write(WebServiceBinding wsBinding, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        String wsdlElement;
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "binding.ws");
        this.policyProcessor.writePolicyAttributes(wsBinding, writer);
        if (wsBinding.getName() != null) {
            writer.writeAttribute("name", wsBinding.getName());
        }
        if (wsBinding.getURI() != null) {
            writer.writeAttribute("uri", wsBinding.getURI());
        }
        if (wsBinding.getPortName() != null) {
            wsdlElement = wsBinding.getServiceName().getNamespaceURI() + "#wsdl.port(" + wsBinding.getServiceName().getLocalPart() + "/" + wsBinding.getPortName() + ")";
            writer.writeAttribute("wsdlElement", wsdlElement);
        } else if (wsBinding.getEndpointName() != null) {
            wsdlElement = wsBinding.getServiceName().getNamespaceURI() + "#wsdl.endpoint(" + wsBinding.getServiceName().getLocalPart() + "/" + wsBinding.getEndpointName() + ")";
            writer.writeAttribute("wsdlElement", wsdlElement);
        } else if (wsBinding.getBindingName() != null) {
            wsdlElement = wsBinding.getBindingName().getNamespaceURI() + "#wsdl.binding(" + wsBinding.getBindingName().getLocalPart() + ")";
            writer.writeAttribute("wsdlElement", wsdlElement);
        } else if (wsBinding.getServiceName() != null) {
            wsdlElement = wsBinding.getServiceName().getNamespaceURI() + "#wsdl.service(" + wsBinding.getServiceName().getLocalPart() + ")";
            writer.writeAttribute("wsdlElement", wsdlElement);
        }
        if (wsBinding.getLocation() != null) {
            writer.writeAttribute("http://www.w3.org/2004/08/wsdl-instance", "wsdlLocation", wsBinding.getLocation());
        }
        for (Extension extension : wsBinding.getAttributeExtensions()) {
            if (!extension.isAttribute()) continue;
            this.extensionAttributeProcessor.write(extension, writer);
        }
        if (wsBinding.getEndPointReference() != null) {
            EndPointReferenceHelper.writeEndPointReference(wsBinding.getEndPointReference(), writer);
        }
        writer.writeEndElement();
    }

    @Override
    public void resolve(WebServiceBinding model, ModelResolver resolver) throws ContributionResolveException {
        if (model == null || !model.isUnresolved()) {
            return;
        }
        WSDLDefinition wsdlDefinition = this.wsdlFactory.createWSDLDefinition();
        wsdlDefinition.setUnresolved(true);
        wsdlDefinition.setNamespace(model.getNamespace());
        WSDLDefinition resolved = null;
        try {
            resolved = resolver.resolveModel(WSDLDefinition.class, wsdlDefinition);
        }
        catch (ContributionRuntimeException e) {
            ContributionResolveException ce = new ContributionResolveException(e.getCause());
            this.error("ContributionResolveException", (Object)wsdlDefinition, ce);
        }
        if (resolved != null && !resolved.isUnresolved()) {
            PortType portType;
            wsdlDefinition.setDefinition(resolved.getDefinition());
            wsdlDefinition.setLocation(resolved.getLocation());
            wsdlDefinition.setURI(resolved.getURI());
            wsdlDefinition.getImportedDefinitions().addAll(resolved.getImportedDefinitions());
            wsdlDefinition.getXmlSchemas().addAll(resolved.getXmlSchemas());
            wsdlDefinition.setUnresolved(false);
            model.setDefinition(wsdlDefinition);
            if (model.getBindingName() != null) {
                WSDLObject<Binding> binding = wsdlDefinition.getWSDLObject(Binding.class, model.getBindingName());
                if (binding != null) {
                    wsdlDefinition.setDefinition(binding.getDefinition());
                    model.setBinding(binding.getElement());
                } else {
                    this.warning("WsdlBindingDoesNotMatch", wsdlDefinition, model.getBindingName());
                }
            }
            if (model.getServiceName() != null) {
                WSDLObject<Service> service = wsdlDefinition.getWSDLObject(Service.class, model.getServiceName());
                if (service != null) {
                    wsdlDefinition.setDefinition(service.getDefinition());
                    model.setService(service.getElement());
                    if (model.getPortName() != null) {
                        Port port = service.getElement().getPort(model.getPortName());
                        if (port != null) {
                            model.setPort(port);
                            model.setBinding(port.getBinding());
                        } else {
                            this.warning("WsdlPortTypeDoesNotMatch", wsdlDefinition, model.getPortName());
                        }
                    }
                } else {
                    this.warning("WsdlServiceDoesNotMatch", wsdlDefinition, model.getServiceName());
                }
            }
            if ((portType = this.getPortType(model)) != null) {
                List operations = portType.getOperations();
                for (OperationImpl operation : operations) {
                    ContributionResolveException ce;
                    if (operation.getInput() != null && operation.getInput().getMessage() == null) {
                        ce = new ContributionResolveException("WSDL binding operation input name " + operation.getInput().getName() + " does not match with PortType Definition");
                        this.error("ContributionResolveException", (Object)wsdlDefinition, ce);
                    }
                    if (operation.getOutput() == null || operation.getOutput().getMessage() != null) continue;
                    ce = new ContributionResolveException("WSDL binding operation output name " + operation.getOutput().getName() + " does not match with PortType Definition");
                    this.error("ContributionResolveException", (Object)wsdlDefinition, ce);
                }
                WSDLInterfaceContract interfaceContract = this.wsdlFactory.createWSDLInterfaceContract();
                WSDLInterface wsdlInterface = null;
                try {
                    wsdlInterface = this.wsdlFactory.createWSDLInterface(portType, wsdlDefinition, resolver);
                    interfaceContract.setInterface(wsdlInterface);
                    model.setBindingInterfaceContract(interfaceContract);
                }
                catch (InvalidInterfaceException e) {
                    this.warning("InvalidInterfaceException", this.wsdlFactory, model.getName());
                }
            }
        }
        this.policyProcessor.resolvePolicies(model, resolver);
        OperationsConfigurator opCongigurator = (OperationsConfigurator)((Object)model);
        for (ConfiguredOperation confOp : opCongigurator.getConfiguredOperations()) {
            this.policyProcessor.resolvePolicies(confOp, resolver);
        }
    }

    private PortType getPortType(WebServiceBinding model) {
        Map ports;
        PortType portType = null;
        if (model.getPort() != null) {
            portType = model.getPort().getBinding().getPortType();
        } else if (model.getEndpoint() != null) {
            portType = model.getPort().getBinding().getPortType();
        } else if (model.getBinding() != null) {
            portType = model.getBinding().getPortType();
        } else if (model.getService() != null && !(ports = model.getService().getPorts()).isEmpty()) {
            Port port = (Port)ports.values().iterator().next();
            portType = port.getBinding().getPortType();
        }
        return portType;
    }

    @Override
    public QName getArtifactType() {
        return WebServiceConstants.BINDING_WS_QNAME;
    }

    @Override
    public Class<WebServiceBinding> getModelType() {
        return WebServiceBinding.class;
    }
}

