/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.java.impl.ContributionHelper;
import org.apache.tuscany.sca.contribution.java.impl.JavaImportModelResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionClassLoader
extends URLClassLoader {
    private Contribution contribution;

    public ContributionClassLoader(Contribution contribution, ClassLoader parent) {
        super(new URL[0], parent);
        this.contribution = contribution;
        if (contribution.getLocation() != null) {
            try {
                this.addURL(new URL(contribution.getLocation()));
                for (URL url : ContributionHelper.getNestedJarUrls(contribution)) {
                    this.addURL(url);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private ClassLoader getExportClassLoader(Contribution exportingContribution) {
        ClassLoader cl = exportingContribution.getClassLoader();
        if (!(cl instanceof ContributionClassLoader)) {
            if (cl == null) {
                cl = this.getParent();
            }
            cl = new ContributionClassLoader(exportingContribution, cl);
            exportingContribution.setClassLoader(cl);
        }
        return cl;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> clazz;
        block7: {
            clazz = null;
            try {
                clazz = this.findClassFromContribution(className);
            }
            catch (ClassNotFoundException e) {
                for (Import import_ : this.contribution.getImports()) {
                    if (!this.classNameMatchesImport(className, import_)) continue;
                    for (Contribution exportingContribution : ((JavaImportModelResolver)import_.getModelResolver()).getExportContributions()) {
                        ClassLoader exportClassLoader = this.getExportClassLoader(exportingContribution);
                        if (!(exportClassLoader instanceof ContributionClassLoader)) continue;
                        for (Export export : exportingContribution.getExports()) {
                            try {
                                if (!import_.match(export)) continue;
                                clazz = ((ContributionClassLoader)exportClassLoader).findClassFromContribution(className);
                                break;
                            }
                            catch (ClassNotFoundException e1) {
                            }
                        }
                        if (clazz == null) continue;
                        break;
                    }
                    if (clazz == null) continue;
                    break;
                }
                if (clazz != null) break block7;
                throw e;
            }
        }
        return clazz;
    }

    @Override
    protected synchronized Class<?> loadClass(String className, boolean resolveClass) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            if (this.getParent() != null) {
                clazz = this.getParent().loadClass(className);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = this.findClass(className);
        }
        if (resolveClass) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL findResource(String name) {
        URL url = this.findResourceFromContribution(name);
        if (url == null) {
            for (Import import_ : this.contribution.getImports()) {
                if (!this.resourceNameMatchesImport(name, import_)) continue;
                for (Contribution exportingContribution : ((JavaImportModelResolver)import_.getModelResolver()).getExportContributions()) {
                    ClassLoader exportClassLoader = this.getExportClassLoader(exportingContribution);
                    if (!(exportClassLoader instanceof ContributionClassLoader)) continue;
                    for (Export export : exportingContribution.getExports()) {
                        if (import_.match(export) && (url = ((ContributionClassLoader)exportClassLoader).findResourceFromContribution(name)) != null) break;
                    }
                    if (url == null) continue;
                    break;
                }
                if (url == null) continue;
                break;
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return Collections.enumeration(this.findResourceSet(name));
    }

    @Override
    public URL getResource(String resName) {
        URL resource = null;
        if (this.getParent() != null) {
            resource = this.getParent().getResource(resName);
        }
        if (resource == null) {
            resource = this.findResource(resName);
        }
        return resource;
    }

    @Override
    public Enumeration<URL> getResources(String resName) throws IOException {
        HashSet<URL> resourceSet = this.findResourceSet(resName);
        this.addEnumerationToCollection(resourceSet, super.getResources(resName));
        return Collections.enumeration(resourceSet);
    }

    private HashSet<URL> findResourceSet(String name) throws IOException {
        HashSet<URL> resources = new HashSet<URL>();
        this.addEnumerationToCollection(resources, super.findResources(name));
        for (Import import_ : this.contribution.getImports()) {
            if (!(import_ instanceof JavaImport) || !this.resourceNameMatchesImport(name, import_)) continue;
            for (Contribution exportingContribution : ((JavaImportModelResolver)import_.getModelResolver()).getExportContributions()) {
                ClassLoader exportClassLoader = this.getExportClassLoader(exportingContribution);
                if (!(exportClassLoader instanceof ContributionClassLoader)) continue;
                for (Export export : exportingContribution.getExports()) {
                    if (!import_.match(export)) continue;
                    this.addEnumerationToCollection(resources, ((ContributionClassLoader)exportClassLoader).findResources(name));
                }
            }
        }
        return resources;
    }

    private Class<?> findClassFromContribution(String className) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(className);
        if (clazz == null) {
            clazz = super.findClass(className);
        }
        return clazz;
    }

    private URL findResourceFromContribution(String name) {
        return super.findResource(name);
    }

    private boolean classNameMatchesImport(String name, Import import_) {
        if (import_ instanceof JavaImport && name != null && name.lastIndexOf(46) > 0) {
            JavaImport javaImport = (JavaImport)import_;
            String packageName = name.substring(0, name.lastIndexOf(46));
            if (javaImport.getPackage().endsWith(".*")) {
                String prefix = javaImport.getPackage().substring(0, javaImport.getPackage().length() - 1);
                if (packageName.startsWith(prefix)) {
                    return true;
                }
            } else {
                return packageName.equals(javaImport.getPackage());
            }
        }
        return false;
    }

    private boolean resourceNameMatchesImport(String name, Import import_) {
        if (name == null || name.lastIndexOf(47) <= 0) {
            return false;
        }
        if (import_ instanceof JavaImport) {
            JavaImport javaImport = (JavaImport)import_;
            if (javaImport.getPackage().endsWith(".*")) {
                String prefix;
                String packageName = name.substring(0, name.lastIndexOf(47)).replace('/', '.');
                if (packageName.startsWith(prefix = javaImport.getPackage().substring(0, javaImport.getPackage().length() - 1))) {
                    return true;
                }
            } else {
                String packageName = name.substring(0, name.lastIndexOf(47));
                return packageName.equals(javaImport.getPackage().replaceAll("\\.", "/"));
            }
        }
        return false;
    }

    private <T> void addEnumerationToCollection(Collection<T> collection, Enumeration<T> enumeration) {
        while (enumeration.hasMoreElements()) {
            collection.add(enumeration.nextElement());
        }
    }

    public String toString() {
        return "SCA Contribution ClassLoader location: " + this.contribution.getLocation() + " parent ClassLoader: " + this.getParent();
    }
}

