/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.jee;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.jee.EjbModuleInfo;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbModuleModelResolver
implements ModelResolver {
    private Map<URI, EjbModuleInfo> map = new HashMap<URI, EjbModuleInfo>();
    private Contribution contribution;

    public EjbModuleModelResolver(Contribution contribution, ModelFactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
    }

    @Override
    public void addModel(Object resolved) {
        EjbModuleInfo ejbModule = (EjbModuleInfo)resolved;
        this.map.put(ejbModule.getUri(), ejbModule);
    }

    @Override
    public Object removeModel(Object resolved) {
        return this.map.remove(((EjbModuleInfo)resolved).getUri());
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        URI uri = ((EjbModuleInfo)unresolved).getUri();
        if (uri != null) {
            EjbModuleInfo resolved = this.map.get(uri);
            if (resolved != null) {
                return modelClass.cast(resolved);
            }
            uri = URI.create("");
            resolved = this.map.get(uri);
            if (resolved != null) {
                return modelClass.cast(resolved);
            }
        }
        return unresolved;
    }
}

