/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.jee;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.jee.JavaEEApplicationInfo;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEEApplicationModelResolver
implements ModelResolver {
    private Map<URI, JavaEEApplicationInfo> map = new HashMap<URI, JavaEEApplicationInfo>();
    private Contribution contribution;

    public JavaEEApplicationModelResolver(Contribution contribution, ModelFactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
    }

    @Override
    public void addModel(Object resolved) {
        JavaEEApplicationInfo jeeApp = (JavaEEApplicationInfo)resolved;
        this.map.put(jeeApp.getUri(), jeeApp);
    }

    @Override
    public Object removeModel(Object resolved) {
        return this.map.remove(((JavaEEApplicationInfo)resolved).getUri());
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        URI uri = ((JavaEEApplicationInfo)unresolved).getUri();
        if (uri != null) {
            JavaEEApplicationInfo resolved = this.map.get(uri);
            if (resolved != null) {
                return modelClass.cast(resolved);
            }
            uri = URI.create("");
            resolved = this.map.get(uri);
            if (resolved != null) {
                return modelClass.cast(resolved);
            }
        }
        return unresolved;
    }
}

