/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.jee;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.jee.ModelObject;
import org.apache.tuscany.sca.contribution.jee.impl.ModelObjectImpl;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelObjectModelResolver
implements ModelResolver {
    private Map<URI, ModelObject> map = new HashMap<URI, ModelObject>();
    private Contribution contribution;

    public ModelObjectModelResolver(Contribution contribution, ModelFactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
    }

    @Override
    public void addModel(Object resolved) {
        this.map.put(((ModelObject)resolved).getUri(), (ModelObject)resolved);
    }

    @Override
    public Object removeModel(Object resolved) {
        return this.map.remove(((ModelObject)resolved).getUri());
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        URI uri = ((ModelObject)unresolved).getUri();
        if (uri != null) {
            ModelObject resolved = this.map.get(uri);
            if (resolved != null) {
                return modelClass.cast(resolved);
            }
            for (Artifact artifact : this.contribution.getArtifacts()) {
                if (!artifact.getURI().equals(uri.toString())) continue;
                resolved = new ModelObjectImpl();
                resolved.setUri(uri);
                resolved.setObject(artifact.getModel());
                return modelClass.cast(resolved);
            }
        }
        return unresolved;
    }
}

