/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.jee;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.jee.WebModuleInfo;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebModuleModelResolver
implements ModelResolver {
    private Map<URI, WebModuleInfo> map = new HashMap<URI, WebModuleInfo>();
    private Contribution contribution;

    public WebModuleModelResolver(Contribution contribution, ModelFactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
    }

    @Override
    public void addModel(Object resolved) {
        WebModuleInfo webModule = (WebModuleInfo)resolved;
        this.map.put(webModule.getUri(), webModule);
    }

    @Override
    public Object removeModel(Object resolved) {
        return this.map.remove(((WebModuleInfo)resolved).getUri());
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        URI uri = ((WebModuleInfo)unresolved).getUri();
        if (uri != null) {
            WebModuleInfo resolved = this.map.get(uri);
            if (resolved != null) {
                return modelClass.cast(resolved);
            }
            uri = URI.create("");
            resolved = this.map.get(uri);
            if (resolved != null) {
                return modelClass.cast(resolved);
            }
        }
        return unresolved;
    }
}

