/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.jee.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.tuscany.sca.contribution.jee.impl.WarContributionProcessor;
import org.apache.tuscany.sca.contribution.processor.PackageProcessor;
import org.apache.tuscany.sca.contribution.processor.impl.JarContributionProcessor;
import org.apache.tuscany.sca.contribution.service.ContributionException;
import org.eclipse.emf.common.archive.ArchiveURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarContributionProcessor
implements PackageProcessor {
    private static URLStreamHandler archiveUrlStreamHandler = new URLStreamHandler(){

        protected URLConnection openConnection(URL u) throws IOException {
            return new ArchiveURLConnection(u);
        }
    };

    @Override
    public URL getArtifactURL(URL packageSourceURL, URI artifact) throws MalformedURLException {
        if (artifact.toString().equals("")) {
            return packageSourceURL;
        }
        if (packageSourceURL.toString().startsWith("archive:")) {
            return new URL(packageSourceURL, artifact.toString(), archiveUrlStreamHandler);
        }
        return new URL("archive", "", -1, packageSourceURL.toExternalForm() + "!/" + artifact, archiveUrlStreamHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<URI> getArtifacts(URL packageSourceURL, InputStream inputStream) throws ContributionException, IOException {
        if (packageSourceURL == null) {
            throw new IllegalArgumentException("Invalid null package source URL.");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Invalid null source inputstream.");
        }
        JarInputStream jar = new JarInputStream(inputStream);
        try {
            JarEntry entry;
            HashSet<String> names = new HashSet<String>();
            while ((entry = jar.getNextJarEntry()) != null) {
                int b;
                String name = entry.getName();
                if (!name.startsWith(".")) {
                    if (name.endsWith("/")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    if (!names.contains(name)) {
                        int s;
                        names.add(name);
                        while (!names.contains(name = (s = name.lastIndexOf(47)) == -1 ? "" : name.substring(0, s))) {
                            names.add(name);
                        }
                    }
                }
                if (entry.getName().indexOf("/") != -1 || !entry.getName().toLowerCase().endsWith(".war") && !entry.getName().toLowerCase().endsWith(".jar")) continue;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((b = jar.read()) != -1) {
                    bout.write(b);
                }
                bout.close();
                ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
                JarContributionProcessor archiveProcessor = entry.getName().toLowerCase().endsWith(".war") ? new WarContributionProcessor() : new JarContributionProcessor();
                List<URI> artifacts = archiveProcessor.getArtifacts(packageSourceURL, bin);
                bin.close();
                for (URI artifact : artifacts) {
                    if (artifact.toString().endsWith("ejb-jar.composite") || artifact.toString().endsWith("web.composite")) continue;
                    names.add(entry.getName() + "!/" + artifact);
                }
            }
            ArrayList<URI> artifacts = new ArrayList<URI>();
            for (String name : names) {
                artifacts.add(URI.create(name));
            }
            ArrayList<URI> arrayList = artifacts;
            return arrayList;
        }
        finally {
            jar.close();
        }
    }

    @Override
    public String getPackageType() {
        return "application/ear";
    }
}

