/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.jee.impl;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.apache.tuscany.sca.contribution.jee.EjbModuleInfo;
import org.apache.tuscany.sca.contribution.jee.JavaEEIntrospector;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbArchiveProcessor
implements URLArtifactProcessor<EjbModuleInfo> {
    private JavaEEIntrospector jeeIntrospector;

    public EjbArchiveProcessor(ExtensionPointRegistry registry, Monitor monitor) {
        this.jeeIntrospector = registry.getExtensionPoint(JavaEEIntrospector.class);
    }

    @Override
    public String getArtifactType() {
        return ".jar";
    }

    @Override
    public EjbModuleInfo read(URL contributionURL, URI artifactURI, URL artifactURL) throws ContributionReadException {
        if (this.jeeIntrospector != null) {
            EjbModuleInfo ejbModuleInfo = this.jeeIntrospector.introspectEjbArchive(artifactURL);
            if (ejbModuleInfo != null) {
                ejbModuleInfo.setUri(artifactURI);
                ejbModuleInfo.setModuleName(new File(artifactURL.getFile()).getName());
            }
            return ejbModuleInfo;
        }
        return null;
    }

    @Override
    public Class<EjbModuleInfo> getModelType() {
        return EjbModuleInfo.class;
    }

    @Override
    public void resolve(EjbModuleInfo arg0, ModelResolver arg1) throws ContributionResolveException {
    }
}

