/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.jee.impl;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.jee.EjbInfo;
import org.apache.tuscany.sca.contribution.jee.EjbModuleInfo;
import org.apache.tuscany.sca.contribution.jee.JavaEEApplicationInfo;
import org.apache.tuscany.sca.contribution.jee.JavaEEExtension;
import org.apache.tuscany.sca.contribution.jee.impl.EJBImplementationGeneratedImpl;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;

public class JavaEEExtensionImpl
implements JavaEEExtension {
    private AssemblyFactory assemblyFactory;
    private JavaInterfaceFactory javaInterfaceFactory;
    private PolicyFactory policyFactory;
    private Intent EJB_INTENT;

    public JavaEEExtensionImpl(ModelFactoryExtensionPoint modelFactories) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.javaInterfaceFactory = modelFactories.getFactory(JavaInterfaceFactory.class);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.EJB_INTENT = this.policyFactory.createIntent();
        this.EJB_INTENT.setName(new QName("http://www.osoa.org/xmlns/sca/1.0", "ejb"));
    }

    public ComponentType createImplementationEjbComponentType(EjbModuleInfo ejbModule, String ejbName) {
        ComponentType componentType = this.assemblyFactory.createComponentType();
        EjbInfo ejbInfo = ejbModule.getEjbInfo(ejbName);
        if (ejbInfo == null) {
            return null;
        }
        if (ejbInfo.ejbType.compareTo(EjbInfo.EjbType.MESSAGE_DRIVEN) != 0) {
            JavaInterfaceContract ic;
            String serviceName;
            String intfName;
            ComponentService service;
            for (Class<?> intf : ejbInfo.businessRemote) {
                service = this.assemblyFactory.createComponentService();
                intfName = intf.getName();
                serviceName = intfName.lastIndexOf(".") != -1 ? intfName.substring(intfName.lastIndexOf(".") + 1) : intfName;
                service.setName(serviceName);
                ic = this.javaInterfaceFactory.createJavaInterfaceContract();
                try {
                    ic.setInterface(this.javaInterfaceFactory.createJavaInterface(intf));
                }
                catch (InvalidInterfaceException e) {
                    e.printStackTrace();
                }
                service.setInterfaceContract(ic);
                service.getRequiredIntents().add(this.EJB_INTENT);
                componentType.getServices().add(service);
            }
            for (Class<?> intf : ejbInfo.businessLocal) {
                service = this.assemblyFactory.createComponentService();
                intfName = intf.getName();
                serviceName = intfName.lastIndexOf(".") != -1 ? intfName.substring(intfName.lastIndexOf(".") + 1) : intfName;
                service.setName(serviceName);
                ic = this.javaInterfaceFactory.createJavaInterfaceContract();
                try {
                    ic.setInterface(this.javaInterfaceFactory.createJavaInterface(intf));
                }
                catch (InvalidInterfaceException e) {
                    e.printStackTrace();
                }
                service.setInterfaceContract(ic);
                service.getRequiredIntents().add(this.EJB_INTENT);
                componentType.getServices().add(service);
            }
        }
        return componentType;
    }

    public void createImplementationJeeComposite(EjbModuleInfo ejbModule, Composite composite) {
        for (Map.Entry<String, EjbInfo> entry : ejbModule.getEjbInfos().entrySet()) {
            JavaInterfaceContract ic;
            String serviceName;
            String intfName;
            ComponentService service;
            EjbInfo ejbInfo = entry.getValue();
            Component component = this.findComponent(composite, ejbInfo, ejbModule);
            if (ejbInfo.ejbType.compareTo(EjbInfo.EjbType.MESSAGE_DRIVEN) == 0) continue;
            for (Class<?> intf : ejbInfo.businessRemote) {
                service = this.assemblyFactory.createComponentService();
                intfName = intf.getName();
                serviceName = intfName.lastIndexOf(".") != -1 ? intfName.substring(intfName.lastIndexOf(".") + 1) : intfName;
                serviceName = ejbInfo.beanName + "_" + serviceName;
                service.setName(serviceName);
                ic = this.javaInterfaceFactory.createJavaInterfaceContract();
                try {
                    ic.setInterface(this.javaInterfaceFactory.createJavaInterface(intf));
                }
                catch (InvalidInterfaceException e) {
                    e.printStackTrace();
                }
                service.setInterfaceContract(ic);
                service.getRequiredIntents().add(this.EJB_INTENT);
                this.addComponentService(composite, component, service);
            }
            for (Class<?> intf : ejbInfo.businessLocal) {
                service = this.assemblyFactory.createComponentService();
                intfName = intf.getName();
                serviceName = intfName.lastIndexOf(".") != -1 ? intfName.substring(intfName.lastIndexOf(".") + 1) : intfName;
                serviceName = ejbInfo.beanName + "_" + serviceName;
                service.setName(serviceName);
                ic = this.javaInterfaceFactory.createJavaInterfaceContract();
                try {
                    ic.setInterface(this.javaInterfaceFactory.createJavaInterface(intf));
                }
                catch (InvalidInterfaceException e) {
                    e.printStackTrace();
                }
                service.setInterfaceContract(ic);
                service.getRequiredIntents().add(this.EJB_INTENT);
                this.addComponentService(composite, component, service);
            }
        }
    }

    public void createImplementationJeeComposite(JavaEEApplicationInfo appInfo, Composite composite) {
        for (Map.Entry<String, EjbModuleInfo> entry0 : appInfo.getEjbModuleInfos().entrySet()) {
            EjbModuleInfo ejbModule = entry0.getValue();
            for (Map.Entry<String, EjbInfo> entry : ejbModule.getEjbInfos().entrySet()) {
                JavaInterfaceContract ic;
                String serviceName;
                String intfName;
                ComponentService service;
                EjbInfo ejbInfo = entry.getValue();
                Component component = this.findComponent(composite, ejbInfo, ejbModule);
                if (ejbInfo.ejbType.compareTo(EjbInfo.EjbType.MESSAGE_DRIVEN) == 0) continue;
                for (Class<?> intf : ejbInfo.businessRemote) {
                    service = this.assemblyFactory.createComponentService();
                    intfName = intf.getName();
                    serviceName = intfName.lastIndexOf(".") != -1 ? intfName.substring(intfName.lastIndexOf(".") + 1) : intfName;
                    serviceName = ejbInfo.mappedName + "_" + serviceName;
                    service.setName(serviceName);
                    ic = this.javaInterfaceFactory.createJavaInterfaceContract();
                    try {
                        ic.setInterface(this.javaInterfaceFactory.createJavaInterface(intf));
                    }
                    catch (InvalidInterfaceException e) {
                        e.printStackTrace();
                    }
                    service.setInterfaceContract(ic);
                    service.getRequiredIntents().add(this.EJB_INTENT);
                    this.addComponentService(composite, component, service);
                }
                for (Class<?> intf : ejbInfo.businessLocal) {
                    service = this.assemblyFactory.createComponentService();
                    intfName = intf.getName();
                    serviceName = intfName.lastIndexOf(".") != -1 ? intfName.substring(intfName.lastIndexOf(".") + 1) : intfName;
                    serviceName = ejbInfo.mappedName + "_" + serviceName;
                    service.setName(serviceName);
                    ic = this.javaInterfaceFactory.createJavaInterfaceContract();
                    try {
                        ic.setInterface(this.javaInterfaceFactory.createJavaInterface(intf));
                    }
                    catch (InvalidInterfaceException e) {
                        e.printStackTrace();
                    }
                    service.setInterfaceContract(ic);
                    service.getRequiredIntents().add(this.EJB_INTENT);
                    this.addComponentService(composite, component, service);
                }
            }
        }
    }

    private Component findComponent(Composite composite, EjbInfo ejbInfo, EjbModuleInfo ejbmoduleInfo) {
        String componentName = ejbInfo.beanName;
        Component component = null;
        for (Component tmpComponent : composite.getComponents()) {
            if (!tmpComponent.getName().equals(componentName)) continue;
            component = tmpComponent;
            break;
        }
        if (component == null) {
            component = this.assemblyFactory.createComponent();
            component.setName(componentName);
            component.setUnresolved(true);
            composite.getComponents().add(component);
            EJBImplementationGeneratedImpl implementation = new EJBImplementationGeneratedImpl();
            implementation.setUnresolved(true);
            implementation.setEJBInfo(ejbInfo);
            implementation.setEjbModuleInfo(ejbmoduleInfo);
            component.setImplementation(implementation);
        }
        return component;
    }

    private void addComponentService(Composite composite, Component component, ComponentService service) {
        component.getImplementation().getServices().add(service);
        CompositeService compositeService = this.assemblyFactory.createCompositeService();
        composite.getServices().add(compositeService);
        compositeService.setName(service.getName());
        compositeService.setPromotedComponent(component);
        compositeService.setPromotedService(service);
    }
}

