/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.jee.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJB;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.jee.EjbInfo;
import org.apache.tuscany.sca.contribution.jee.EjbModuleInfo;
import org.apache.tuscany.sca.contribution.jee.EjbReferenceInfo;
import org.apache.tuscany.sca.contribution.jee.EnvEntryInfo;
import org.apache.tuscany.sca.contribution.jee.InjectionTarget;
import org.apache.tuscany.sca.contribution.jee.JavaEEApplicationInfo;
import org.apache.tuscany.sca.contribution.jee.JavaEEOptionalExtension;
import org.apache.tuscany.sca.contribution.jee.WebModuleInfo;
import org.apache.tuscany.sca.contribution.jee.impl.EJBImplementationGeneratedImpl;
import org.apache.tuscany.sca.contribution.jee.impl.WebImplementationGeneratedImpl;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.osoa.sca.annotations.Reference;

public class JavaEEOptionalExtensionImpl
implements JavaEEOptionalExtension {
    private AssemblyFactory assemblyFactory;
    private JavaInterfaceFactory javaInterfaceFactory;
    private PolicyFactory policyFactory;
    private Intent EJB_INTENT;
    public static final Map<String, QName> ALLOWED_ENV_ENTRY_TYPES = new HashMap<String, QName>();

    public JavaEEOptionalExtensionImpl(ModelFactoryExtensionPoint modelFactories) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.javaInterfaceFactory = modelFactories.getFactory(JavaInterfaceFactory.class);
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.EJB_INTENT = this.policyFactory.createIntent();
        this.EJB_INTENT.setName(new QName("http://www.osoa.org/xmlns/sca/1.0", "ejb"));
    }

    public ComponentType createImplementationWebComponentType(WebModuleInfo webModule) {
        ComponentType componentType = this.assemblyFactory.createComponentType();
        for (Map.Entry<String, EjbReferenceInfo> entry : webModule.getEjbReferences().entrySet()) {
            EjbReferenceInfo ejbRef = entry.getValue();
            if (!this.hasReferenceAnnotation(ejbRef.injectionTarget)) continue;
            String referenceName = entry.getKey();
            referenceName = referenceName.replace("/", "_");
            ComponentReference reference = this.assemblyFactory.createComponentReference();
            reference.setName(referenceName);
            JavaInterfaceContract ic = this.javaInterfaceFactory.createJavaInterfaceContract();
            try {
                ic.setInterface(this.javaInterfaceFactory.createJavaInterface(ejbRef.businessInterface));
            }
            catch (InvalidInterfaceException e) {
                e.printStackTrace();
            }
            reference.setInterfaceContract(ic);
            reference.getRequiredIntents().add(this.EJB_INTENT);
            reference.setMultiplicity(Multiplicity.ZERO_ONE);
            componentType.getReferences().add(reference);
        }
        for (Map.Entry<String, Object> entry : webModule.getEnvEntries().entrySet()) {
            EnvEntryInfo envEntry = (EnvEntryInfo)entry.getValue();
            String type = envEntry.type;
            if (!ALLOWED_ENV_ENTRY_TYPES.containsKey(type)) continue;
            String propertyName = envEntry.name;
            propertyName = propertyName.replace("/", "_");
            String value = envEntry.value;
            ComponentProperty property = this.assemblyFactory.createComponentProperty();
            property.setName(propertyName);
            property.setXSDType(ALLOWED_ENV_ENTRY_TYPES.get(type));
            property.setValue(value);
            componentType.getProperties().add(property);
        }
        return componentType;
    }

    public ComponentType createImplementationEjbComponentType(EjbModuleInfo ejbModule, String ejbName) {
        ComponentType componentType = this.assemblyFactory.createComponentType();
        EjbInfo ejbInfo = ejbModule.getEjbInfo(ejbName);
        if (ejbInfo == null) {
            return null;
        }
        for (Map.Entry<String, EjbReferenceInfo> entry : ejbInfo.ejbReferences.entrySet()) {
            EjbReferenceInfo ejbRef = entry.getValue();
            if (!this.hasReferenceAnnotation(ejbRef.injectionTarget)) continue;
            String referenceName = entry.getKey();
            referenceName = referenceName.replace("/", "_");
            ComponentReference reference = this.assemblyFactory.createComponentReference();
            reference.setName(referenceName);
            JavaInterfaceContract ic = this.javaInterfaceFactory.createJavaInterfaceContract();
            try {
                ic.setInterface(this.javaInterfaceFactory.createJavaInterface(ejbRef.businessInterface));
            }
            catch (InvalidInterfaceException e) {
                e.printStackTrace();
            }
            reference.setInterfaceContract(ic);
            reference.getRequiredIntents().add(this.EJB_INTENT);
            reference.setMultiplicity(Multiplicity.ZERO_ONE);
            componentType.getReferences().add(reference);
        }
        for (Map.Entry<String, Object> entry : ejbInfo.envEntries.entrySet()) {
            EnvEntryInfo envEntry = (EnvEntryInfo)entry.getValue();
            String type = envEntry.type;
            if (!ALLOWED_ENV_ENTRY_TYPES.containsKey(type)) continue;
            String propertyName = envEntry.name;
            propertyName = propertyName.replace("/", "_");
            String value = envEntry.value;
            ComponentProperty property = this.assemblyFactory.createComponentProperty();
            property.setName(propertyName);
            property.setXSDType(ALLOWED_ENV_ENTRY_TYPES.get(type));
            property.setValue(value);
            componentType.getProperties().add(property);
        }
        return componentType;
    }

    public void createImplementationJeeComposite(WebModuleInfo webModule, Composite composite) {
        Component component = this.findComponent(composite, webModule);
        for (Map.Entry<String, EjbReferenceInfo> entry : webModule.getEjbReferences().entrySet()) {
            EjbReferenceInfo ejbRef = entry.getValue();
            String referenceName = entry.getKey();
            referenceName = referenceName.replace("/", "_");
            ComponentReference reference = this.assemblyFactory.createComponentReference();
            reference.setName(referenceName);
            JavaInterfaceContract ic = this.javaInterfaceFactory.createJavaInterfaceContract();
            try {
                ic.setInterface(this.javaInterfaceFactory.createJavaInterface(ejbRef.businessInterface));
            }
            catch (InvalidInterfaceException e) {
                e.printStackTrace();
            }
            reference.setInterfaceContract(ic);
            reference.getRequiredIntents().add(this.EJB_INTENT);
            reference.setMultiplicity(Multiplicity.ZERO_ONE);
            this.addComponentReference(composite, component, reference);
        }
    }

    public void createImplementationJeeComposite(EjbModuleInfo ejbModule, Composite composite) {
        for (Map.Entry<String, EjbInfo> entry : ejbModule.getEjbInfos().entrySet()) {
            EjbInfo ejbInfo = entry.getValue();
            Component component = this.findComponent(composite, ejbInfo, ejbModule);
            for (Map.Entry<String, EjbReferenceInfo> entry1 : ejbInfo.ejbReferences.entrySet()) {
                EjbReferenceInfo ejbRef = entry1.getValue();
                String referenceName = ejbRef.referenceName;
                referenceName = referenceName.replace("/", "_");
                referenceName = ejbInfo.beanName + "_" + referenceName;
                ComponentReference reference = this.assemblyFactory.createComponentReference();
                reference.setName(referenceName);
                JavaInterfaceContract ic = this.javaInterfaceFactory.createJavaInterfaceContract();
                try {
                    ic.setInterface(this.javaInterfaceFactory.createJavaInterface(ejbRef.businessInterface));
                }
                catch (InvalidInterfaceException e) {
                    e.printStackTrace();
                }
                reference.setInterfaceContract(ic);
                reference.getRequiredIntents().add(this.EJB_INTENT);
                reference.setMultiplicity(Multiplicity.ZERO_ONE);
                this.addComponentReference(composite, component, reference);
            }
        }
    }

    public void createImplementationJeeComposite(JavaEEApplicationInfo appInfo, Composite composite) {
        for (Map.Entry<String, EjbModuleInfo> entry0 : appInfo.getEjbModuleInfos().entrySet()) {
            EjbModuleInfo ejbModule = entry0.getValue();
            for (Map.Entry<String, EjbInfo> entry : ejbModule.getEjbInfos().entrySet()) {
                EjbInfo ejbInfo = entry.getValue();
                Component component = this.findComponent(composite, ejbInfo, ejbModule);
                for (Map.Entry<String, EjbReferenceInfo> entry1 : ejbInfo.ejbReferences.entrySet()) {
                    EjbReferenceInfo ejbRef = entry1.getValue();
                    String referenceName = ejbRef.referenceName;
                    referenceName = referenceName.replace("/", "_");
                    referenceName = ejbInfo.beanName + "_" + referenceName;
                    ComponentReference reference = this.assemblyFactory.createComponentReference();
                    reference.setName(referenceName);
                    JavaInterfaceContract ic = this.javaInterfaceFactory.createJavaInterfaceContract();
                    try {
                        ic.setInterface(this.javaInterfaceFactory.createJavaInterface(ejbRef.businessInterface));
                    }
                    catch (InvalidInterfaceException e) {
                        e.printStackTrace();
                    }
                    reference.setInterfaceContract(ic);
                    reference.getRequiredIntents().add(this.EJB_INTENT);
                    reference.setMultiplicity(Multiplicity.ZERO_ONE);
                    this.addComponentReference(composite, component, reference);
                }
            }
        }
    }

    private Component findComponent(Composite composite, EjbInfo ejbInfo, EjbModuleInfo ejbmoduleInfo) {
        String componentName = ejbInfo.beanName;
        Component component = null;
        for (Component tmpComponent : composite.getComponents()) {
            if (!tmpComponent.getName().equals(componentName)) continue;
            component = tmpComponent;
            break;
        }
        if (component == null) {
            component = this.assemblyFactory.createComponent();
            component.setName(componentName);
            component.setUnresolved(true);
            composite.getComponents().add(component);
            EJBImplementationGeneratedImpl implementation = new EJBImplementationGeneratedImpl();
            implementation.setUnresolved(true);
            implementation.setEJBInfo(ejbInfo);
            implementation.setEjbModuleInfo(ejbmoduleInfo);
            component.setImplementation(implementation);
        }
        return component;
    }

    private Component findComponent(Composite composite, WebModuleInfo webInfo) {
        String componentName = webInfo.getModuleName();
        Component component = null;
        for (Component tmpComponent : composite.getComponents()) {
            if (!tmpComponent.getName().equals(componentName)) continue;
            component = tmpComponent;
            break;
        }
        if (component == null) {
            component = this.assemblyFactory.createComponent();
            component.setName(componentName);
            component.setUnresolved(true);
            composite.getComponents().add(component);
            WebImplementationGeneratedImpl implementation = new WebImplementationGeneratedImpl();
            implementation.setUnresolved(true);
            implementation.setWebInfo(webInfo);
            component.setImplementation(implementation);
        }
        return component;
    }

    private void addComponentReference(Composite composite, Component component, ComponentReference reference) {
        component.getImplementation().getReferences().add(reference);
        CompositeReference compositeReference = this.assemblyFactory.createCompositeReference();
        composite.getReferences().add(compositeReference);
        compositeReference.setName(reference.getName());
        compositeReference.getPromotedReferences().add(reference);
    }

    private boolean hasReferenceAnnotation(InjectionTarget injectionTarget) {
        if (injectionTarget.targetClass == null || injectionTarget.targetClass.equals("")) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(injectionTarget.targetClass);
            try {
                Method method = clazz.getDeclaredMethod("set" + injectionTarget.targetName, new Class[0]);
                if (method.isAnnotationPresent(EJB.class)) {
                    return method.isAnnotationPresent(Reference.class);
                }
                throw new NoSuchMethodException("set" + injectionTarget.targetName);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    Field field = clazz.getDeclaredField(injectionTarget.targetName);
                    return field.isAnnotationPresent(Reference.class);
                }
                catch (NoSuchFieldException nsfe) {
                    return false;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    static {
        ALLOWED_ENV_ENTRY_TYPES.put(String.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"));
        ALLOWED_ENV_ENTRY_TYPES.put(Character.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"));
        ALLOWED_ENV_ENTRY_TYPES.put(Byte.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "byte", "xsd"));
        ALLOWED_ENV_ENTRY_TYPES.put(Short.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "short", "xsd"));
        ALLOWED_ENV_ENTRY_TYPES.put(Integer.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd"));
        ALLOWED_ENV_ENTRY_TYPES.put(Long.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "long", "xsd"));
        ALLOWED_ENV_ENTRY_TYPES.put(Boolean.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xsd"));
        ALLOWED_ENV_ENTRY_TYPES.put(Double.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "double", "xsd"));
        ALLOWED_ENV_ENTRY_TYPES.put(Float.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "float", "xsd"));
    }
}

