/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.jee.impl;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.apache.tuscany.sca.contribution.jee.JavaEEIntrospector;
import org.apache.tuscany.sca.contribution.jee.WebModuleInfo;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebArchiveProcessor
implements URLArtifactProcessor<WebModuleInfo> {
    private JavaEEIntrospector jeeIntrospector;

    public WebArchiveProcessor(ExtensionPointRegistry registry, Monitor monitor) {
        this.jeeIntrospector = registry.getExtensionPoint(JavaEEIntrospector.class);
    }

    @Override
    public String getArtifactType() {
        return ".war";
    }

    @Override
    public WebModuleInfo read(URL contributionURL, URI artifactURI, URL artifactURL) throws ContributionReadException {
        WebModuleInfo webModuleInfo = this.jeeIntrospector.introspectWebArchive(artifactURL);
        webModuleInfo.setUri(artifactURI);
        webModuleInfo.setModuleName(new File(artifactURL.getFile()).getName());
        return webModuleInfo;
    }

    @Override
    public Class<WebModuleInfo> getModelType() {
        return WebModuleInfo.class;
    }

    @Override
    public void resolve(WebModuleInfo arg0, ModelResolver arg1) throws ContributionResolveException {
    }
}

