/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.namespace.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImportExportFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceImportProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<NamespaceImport> {
    private static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";
    private static final QName IMPORT = new QName("http://www.osoa.org/xmlns/sca/1.0", "import");
    private static final String NAMESPACE = "namespace";
    private static final String LOCATION = "location";
    private final NamespaceImportExportFactory factory;
    private final ExtensionFactory extensionFactory;
    private final StAXArtifactProcessor<Object> extensionProcessor;
    private final StAXAttributeProcessor<Object> attributeProcessor;
    private final Monitor monitor;

    public NamespaceImportProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, StAXAttributeProcessor<Object> attributeProcessor, Monitor monitor) {
        this.factory = modelFactories.getFactory(NamespaceImportExportFactory.class);
        this.monitor = monitor;
        this.extensionFactory = modelFactories.getFactory(ExtensionFactory.class);
        this.extensionProcessor = extensionProcessor;
        this.attributeProcessor = attributeProcessor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-namespace-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-namespace-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return IMPORT;
    }

    @Override
    public Class<NamespaceImport> getModelType() {
        return NamespaceImport.class;
    }

    @Override
    public NamespaceImport read(XMLStreamReader reader) throws ContributionReadException {
        NamespaceImport namespaceImport = this.factory.createNamespaceImport();
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        QName element = reader.getName();
                        if (IMPORT.equals(element)) {
                            String ns = reader.getAttributeValue(null, NAMESPACE);
                            if (ns == null) {
                                this.error("AttributeNameSpaceMissing", (Object)reader, new Object[0]);
                            } else {
                                namespaceImport.setNamespace(ns);
                            }
                            String location = NamespaceImportProcessor.getURIString(reader, LOCATION);
                            if (location != null) {
                                namespaceImport.setLocation(location);
                            }
                            this.readExtendedAttributes(reader, namespaceImport, this.attributeProcessor, this.extensionFactory);
                            break;
                        }
                        this.readExtendedElement(reader, namespaceImport, this.extensionProcessor);
                        break;
                    }
                    case 2: {
                        if (!IMPORT.equals(reader.getName())) break;
                        return namespaceImport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException(e);
            this.error("XMLStreamException", (Object)reader, ex);
        }
        return namespaceImport;
    }

    @Override
    public void write(NamespaceImport namespaceImport, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(IMPORT.getNamespaceURI(), IMPORT.getLocalPart());
        if (namespaceImport.getNamespace() != null) {
            writer.writeAttribute(NAMESPACE, namespaceImport.getNamespace());
        }
        if (namespaceImport.getLocation() != null) {
            writer.writeAttribute(LOCATION, namespaceImport.getLocation());
        }
        this.writeExtendedAttributes(writer, namespaceImport, this.attributeProcessor);
        this.writeExtendedElements(writer, namespaceImport, this.extensionProcessor);
        writer.writeEndElement();
    }

    @Override
    public void resolve(NamespaceImport model, ModelResolver resolver) throws ContributionResolveException {
    }
}

