/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.osgi;

public class BundleReference {
    private Object bundle;
    private String bundleName;
    private String bundleVersion;
    private String bundleUniqueName;
    private String bundleRelativePath;

    public BundleReference(Object bundle, String bundleName, String bundleVersion, String bundleRelativePath) {
        this.bundle = bundle;
        this.bundleName = bundleName;
        this.bundleVersion = bundleVersion;
        this.bundleRelativePath = bundleRelativePath;
        this.bundleUniqueName = bundleName + "(" + (bundleVersion == null ? "0.0.0" : bundleVersion) + ")";
    }

    public BundleReference(String bundleName, String bundleVersion) {
        this.bundleName = bundleName;
        this.bundleVersion = bundleVersion;
        this.bundleUniqueName = bundleName + "(" + (bundleVersion == null ? "0.0.0" : bundleVersion) + ")";
    }

    public Object getBundle() {
        return this.bundle;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public String getBundleUniqueName() {
        return this.bundleUniqueName;
    }

    public String getBundleRelativePath() {
        return this.bundleRelativePath;
    }

    public boolean isUnresolved() {
        return this.bundle == null;
    }

    public int hashCode() {
        return this.bundleUniqueName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BundleReference) {
            BundleReference ref = (BundleReference)obj;
            return this.bundleName.equals(ref.bundleName) && (this.bundleVersion == null || ref.bundleVersion == null || this.bundleVersion.equals(ref.bundleVersion));
        }
        return false;
    }
}

