/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.osgi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.osgi.BundleReference;
import org.apache.tuscany.sca.osgi.runtime.OSGiRuntime;
import org.osgi.framework.Bundle;

public class OSGiBundleProcessor {
    private boolean initializedOSGi;
    private OSGiRuntime osgiRuntime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object installContributionBundle(Contribution contribution) {
        ZipInputStream jar = null;
        Bundle bundle = null;
        try {
            URL contribURL = new URL(contribution.getLocation());
            jar = new JarInputStream(contribURL.openStream());
            Manifest manifest = ((JarInputStream)jar).getManifest();
            if (manifest != null && manifest.getMainAttributes().containsKey(new Attributes.Name("Bundle-SymbolicName"))) {
                this.initialize();
                if (this.osgiRuntime != null) {
                    bundle = this.osgiRuntime.installBundle(contribURL.toString(), null);
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException e) {}
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleReference installNestedBundle(Contribution contribution, String bundleSymbolicName, String bundleVersion) {
        BundleReference bundleReference = null;
        this.initialize();
        if (this.osgiRuntime == null) {
            return null;
        }
        List<Artifact> artifacts = contribution.getArtifacts();
        for (Artifact a : artifacts) {
            if (!a.getURI().endsWith(".jar")) continue;
            ZipInputStream jar = null;
            try {
                URL artifactURL = new URL(a.getLocation());
                InputStream stream = artifactURL.openStream();
                jar = new JarInputStream(artifactURL.openStream());
                Manifest manifest = ((JarInputStream)jar).getManifest();
                Object name = manifest.getMainAttributes().get(new Attributes.Name("Bundle-SymbolicName"));
                Object version = manifest.getMainAttributes().get(new Attributes.Name("Bundle-Version"));
                if (!bundleSymbolicName.equals(name) || bundleVersion != null && version != null && !bundleVersion.equals(version)) continue;
                Bundle bundle = this.osgiRuntime.installBundle(a.getLocation(), stream);
                bundleReference = new BundleReference(bundle, bundleSymbolicName, bundleVersion, a.getURI());
                break;
            }
            catch (Exception e) {}
            continue;
            finally {
                try {
                    if (jar == null) continue;
                    jar.close();
                }
                catch (IOException e) {}
            }
        }
        return bundleReference;
    }

    private void initialize() {
        try {
            if (!this.initializedOSGi) {
                this.initializedOSGi = true;
                this.osgiRuntime = OSGiRuntime.getRuntime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

