/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.osgi.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.tuscany.sca.contribution.osgi.BundleReference;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiModelResolverImpl
implements ModelResolver {
    private static final long serialVersionUID = -7826976465762296634L;
    private Map<Object, Object> map = new HashMap<Object, Object>();
    private Hashtable<String, Bundle> bundles;

    public OSGiModelResolverImpl(Hashtable<String, Bundle> bundles) {
        this.bundles = bundles;
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        Object resolved = this.map.get(unresolved);
        if (resolved != null) {
            return modelClass.cast(resolved);
        }
        if (unresolved instanceof ClassReference) {
            ClassReference classReference = (ClassReference)unresolved;
            Class clazz = null;
            for (Bundle bundle : this.bundles.values()) {
                try {
                    clazz = bundle.loadClass(classReference.getClassName());
                    break;
                }
                catch (ClassNotFoundException e) {
                }
            }
            if (clazz == null) {
                return unresolved;
            }
            resolved = new ClassReference(clazz);
            this.map.put(resolved, resolved);
            return modelClass.cast(resolved);
        }
        if (unresolved instanceof BundleReference) {
            for (String bundlePath : this.bundles.keySet()) {
                Bundle bundle = this.bundles.get(bundlePath);
                BundleReference bundleRef = (BundleReference)unresolved;
                String bundleVersion = (String)bundle.getHeaders().get("Bundle-Version");
                if (!bundle.getSymbolicName().equals(bundleRef.getBundleName()) || bundleVersion != null && bundleRef.getBundleVersion() != null && !bundleVersion.equals(bundleRef.getBundleVersion())) continue;
                resolved = new BundleReference(bundle, bundle.getSymbolicName(), bundleVersion, bundlePath);
                this.map.put(resolved, resolved);
                return modelClass.cast(resolved);
            }
        }
        return unresolved;
    }

    @Override
    public void addModel(Object resolved) {
        this.map.put(resolved, resolved);
    }

    @Override
    public Object removeModel(Object resolved) {
        return this.map.remove(resolved);
    }

    public Collection<Object> getModels() {
        return this.map.values();
    }
}

