/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseStAXArtifactProcessor {
    protected QName getQNameValue(XMLStreamReader reader, String value) {
        if (value != null) {
            int index = value.indexOf(58);
            String prefix = index == -1 ? "" : value.substring(0, index);
            String localName = index == -1 ? value : value.substring(index + 1);
            String ns = reader.getNamespaceContext().getNamespaceURI(prefix);
            if (ns == null) {
                ns = "";
            }
            return new QName(ns, localName, prefix);
        }
        return null;
    }

    protected boolean getBoolean(XMLStreamReader reader, String name) {
        String value = reader.getAttributeValue(null, name);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    protected QName getQName(XMLStreamReader reader, String name) {
        String qname = reader.getAttributeValue(null, name);
        return this.getQNameValue(reader, qname);
    }

    protected List<QName> getQNames(XMLStreamReader reader, String name) {
        String value = reader.getAttributeValue(null, name);
        if (value != null) {
            ArrayList<QName> qnames = new ArrayList<QName>();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                qnames.add(this.getQName(reader, tokens.nextToken()));
            }
            return qnames;
        }
        return Collections.emptyList();
    }

    protected String getString(XMLStreamReader reader, String name) {
        return reader.getAttributeValue(null, name);
    }

    public static String getURIString(XMLStreamReader reader, String name) {
        String uri = reader.getAttributeValue(null, name);
        if (uri != null) {
            uri = uri.replace('\t', ' ');
            uri = uri.replace('\n', ' ');
            uri = uri.replace('\r', ' ');
            uri = uri.trim();
            StringBuilder sb = new StringBuilder(uri.length());
            boolean spaceFound = false;
            for (int i = 0; i < uri.length(); ++i) {
                char c = uri.charAt(i);
                if (c == ' ') {
                    if (spaceFound) continue;
                    sb.append(c);
                    spaceFound = true;
                    continue;
                }
                sb.append(c);
                spaceFound = false;
            }
            uri = sb.toString();
        }
        return uri;
    }

    protected boolean isSet(XMLStreamReader reader, String name) {
        return reader.getAttributeValue(null, name) != null;
    }

    protected QName getXSIType(XMLStreamReader reader) {
        String qname = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        return this.getQNameValue(reader, qname);
    }

    protected boolean nextChildElement(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 2) {
                return false;
            }
            if (event != 1) continue;
            return true;
        }
        return false;
    }

    protected void skipToEndElement(XMLStreamReader reader) throws XMLStreamException {
        int depth = 0;
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                ++depth;
                continue;
            }
            if (event != 2) continue;
            if (depth == 0) {
                return;
            }
            --depth;
        }
    }

    private String writeElementPrefix(XMLStreamWriter writer, String uri) throws XMLStreamException {
        if (uri == null) {
            return null;
        }
        String prefix = writer.getPrefix(uri);
        if (prefix != null) {
            return null;
        }
        NamespaceContext nsc = writer.getNamespaceContext();
        int i = 1;
        while (nsc.getNamespaceURI(prefix = "ns" + i) != null) {
            ++i;
        }
        return prefix;
    }

    protected void writeStart(XMLStreamWriter writer, String uri, String name, XAttr ... attrs) throws XMLStreamException {
        String prefix = this.writeElementPrefix(writer, uri);
        writer.writeStartElement(uri, name);
        if (prefix != null) {
            writer.writeNamespace(prefix, uri);
        }
        this.writeAttributePrefixes(writer, attrs);
        this.writeAttributes(writer, attrs);
    }

    protected void writeStart(XMLStreamWriter writer, QName qname, XAttr ... attrs) throws XMLStreamException {
        this.writeStart(writer, qname.getNamespaceURI(), qname.getLocalPart(), attrs);
    }

    protected void writeEnd(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
    }

    protected void writeStartDocument(XMLStreamWriter writer, String uri, String name, XAttr ... attrs) throws XMLStreamException {
        writer.writeStartDocument();
        writer.setDefaultNamespace(uri);
        this.writeStart(writer, uri, name, attrs);
        writer.writeDefaultNamespace(uri);
    }

    protected void writeStartDocument(XMLStreamWriter writer, QName qname, XAttr ... attrs) throws XMLStreamException {
        this.writeStartDocument(writer, qname.getNamespaceURI(), qname.getLocalPart(), attrs);
    }

    protected void writeEndDocument(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndDocument();
    }

    protected void writeAttributes(XMLStreamWriter writer, XAttr ... attrs) throws XMLStreamException {
        for (XAttr attr : attrs) {
            if (attr == null) continue;
            attr.write(writer);
        }
    }

    protected void writeAttributePrefixes(XMLStreamWriter writer, XAttr ... attrs) throws XMLStreamException {
        for (XAttr attr : attrs) {
            if (attr == null) continue;
            attr.writePrefix(writer);
        }
    }

    protected void readExtendedAttributes(XMLStreamReader reader, Extensible extensible, StAXAttributeProcessor extensionAttributeProcessor, ExtensionFactory extensionFactory) throws ContributionReadException, XMLStreamException {
        QName elementName = reader.getName();
        for (int a = 0; a < reader.getAttributeCount(); ++a) {
            QName attributeName = reader.getAttributeName(a);
            if (attributeName.getNamespaceURI() == null || attributeName.getNamespaceURI().length() <= 0 || elementName.getNamespaceURI().equals(attributeName.getNamespaceURI())) continue;
            Object attributeValue = extensionAttributeProcessor.read(attributeName, reader);
            Extension attributeExtension = attributeValue instanceof Extension ? (Extension)attributeValue : extensionFactory.createExtension(attributeName, attributeValue, true);
            extensible.getAttributeExtensions().add(attributeExtension);
        }
    }

    protected void writeExtendedAttributes(XMLStreamWriter writer, Extensible extensibleElement, StAXAttributeProcessor extensionAttributeProcessor) throws ContributionWriteException, XMLStreamException {
        for (Extension extension : extensibleElement.getAttributeExtensions()) {
            if (!extension.isAttribute()) continue;
            extensionAttributeProcessor.write(extension, writer);
        }
    }

    protected void readExtendedElement(XMLStreamReader reader, Extensible extensible, StAXArtifactProcessor extensionProcessor) throws ContributionReadException, XMLStreamException {
        Object ext = extensionProcessor.read(reader);
        if (extensible != null) {
            extensible.getExtensions().add(ext);
        }
    }

    protected void writeExtendedElements(XMLStreamWriter writer, Extensible extensible, StAXArtifactProcessor extensionProcessor) throws ContributionWriteException, XMLStreamException {
        for (Object ext : extensible.getExtensions()) {
            extensionProcessor.write(ext, writer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XAttr {
        private static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";
        private String uri = "http://www.osoa.org/xmlns/sca/1.0";
        private String name;
        private Object value;

        public XAttr(String uri, String name, String value) {
            this.uri = uri;
            this.name = name;
            this.value = value;
        }

        public XAttr(String name, String value) {
            this(null, name, value);
        }

        public XAttr(String uri, String name, List<?> values) {
            this.uri = uri;
            this.name = name;
            this.value = values;
        }

        public XAttr(String name, List<?> values) {
            this(null, name, values);
        }

        public XAttr(String uri, String name, Boolean value) {
            this.uri = uri;
            this.name = name;
            this.value = value;
        }

        public XAttr(String name, Boolean value) {
            this(null, name, value);
        }

        public XAttr(String uri, String name, Integer value) {
            this.uri = uri;
            this.name = name;
            this.value = value;
        }

        public XAttr(String name, Integer value) {
            this(null, name, value);
        }

        public XAttr(String uri, String name, Double value) {
            this.uri = uri;
            this.name = name;
            this.value = value;
        }

        public XAttr(String name, Double value) {
            this(null, name, value);
        }

        public XAttr(String uri, String name, QName value) {
            this.uri = uri;
            this.name = name;
            this.value = value;
        }

        public XAttr(String name, QName value) {
            this(null, name, value);
        }

        private String writeQNameValue(XMLStreamWriter writer, QName qname) throws XMLStreamException {
            if (qname != null) {
                String prefix = qname.getPrefix();
                String uri = qname.getNamespaceURI();
                prefix = writer.getPrefix(uri);
                if (prefix != null) {
                    if (prefix.length() > 0) {
                        return prefix + ":" + qname.getLocalPart();
                    }
                    return qname.getLocalPart();
                }
                NamespaceContext nsc = writer.getNamespaceContext();
                int i = 1;
                while (nsc.getNamespaceURI(prefix = "ns" + i) != null) {
                    ++i;
                }
                writer.writeNamespace(prefix, uri);
                return prefix + ":" + qname.getLocalPart();
            }
            return null;
        }

        private void writeQNamePrefix(XMLStreamWriter writer, QName qname) throws XMLStreamException {
            if (qname != null) {
                String prefix = qname.getPrefix();
                String uri = qname.getNamespaceURI();
                prefix = writer.getPrefix(uri);
                if (prefix != null) {
                    return;
                }
                NamespaceContext nsc = writer.getNamespaceContext();
                int i = 1;
                while (nsc.getNamespaceURI(prefix = "ns" + i) != null) {
                    ++i;
                }
                writer.writeNamespace(prefix, uri);
            }
        }

        public void write(XMLStreamWriter writer) throws XMLStreamException {
            String str;
            if (this.value instanceof QName) {
                str = this.writeQNameValue(writer, (QName)this.value);
            } else if (this.value instanceof List) {
                List values = (List)this.value;
                if (values.isEmpty()) {
                    return;
                }
                StringBuffer buffer = new StringBuffer();
                for (Object v : values) {
                    if (v == null) continue;
                    if (v instanceof XAttr) {
                        ((XAttr)v).write(writer);
                        continue;
                    }
                    if (buffer.length() != 0) {
                        buffer.append(' ');
                    }
                    if (v instanceof QName) {
                        buffer.append(this.writeQNameValue(writer, (QName)v));
                        continue;
                    }
                    buffer.append(String.valueOf(v));
                }
                str = buffer.toString();
            } else {
                if (this.value == null) {
                    return;
                }
                str = String.valueOf(this.value);
            }
            if (str.length() == 0) {
                return;
            }
            if (this.uri != null && !this.uri.equals(SCA10_NS)) {
                writer.writeAttribute(this.uri, this.name, str);
            } else {
                writer.writeAttribute(this.name, str);
            }
        }

        public void writePrefix(XMLStreamWriter writer) throws XMLStreamException {
            if (this.value instanceof QName) {
                this.writeQNamePrefix(writer, (QName)this.value);
            } else if (this.value instanceof List) {
                for (Object v : (List)this.value) {
                    if (v instanceof QName) {
                        this.writeQNamePrefix(writer, (QName)v);
                        continue;
                    }
                    if (!(v instanceof XAttr)) continue;
                    ((XAttr)v).writePrefix(writer);
                }
            }
        }
    }
}

