/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tuscany.sca.contribution.processor.PackageProcessor;
import org.apache.tuscany.sca.contribution.processor.PackageProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionException;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

public class DefaultPackageProcessorExtensionPoint
implements PackageProcessorExtensionPoint {
    private Map<String, PackageProcessor> processors = new HashMap<String, PackageProcessor>();
    private boolean loaded;

    public void addPackageProcessor(PackageProcessor processor) {
        this.processors.put(processor.getPackageType(), processor);
    }

    public void removePackageProcessor(PackageProcessor processor) {
        this.processors.remove(processor.getPackageType());
    }

    public PackageProcessor getPackageProcessor(String contentType) {
        this.loadProcessors();
        return this.processors.get(contentType);
    }

    private synchronized void loadProcessors() {
        Set<ServiceDeclaration> processorDeclarations;
        if (this.loaded) {
            return;
        }
        try {
            processorDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(PackageProcessor.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration processorDeclaration : processorDeclarations) {
            Map<String, String> attributes = processorDeclaration.getAttributes();
            String packageType = attributes.get("type");
            LazyPackageProcessor processor = new LazyPackageProcessor(packageType, processorDeclaration);
            this.addPackageProcessor(processor);
        }
        this.loaded = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyPackageProcessor
    implements PackageProcessor {
        private ServiceDeclaration processorDeclaration;
        private String packageType;
        private PackageProcessor processor;

        private LazyPackageProcessor(String packageType, ServiceDeclaration processorDeclaration) {
            this.processorDeclaration = processorDeclaration;
            this.packageType = packageType;
        }

        @Override
        public URL getArtifactURL(URL packageSourceURL, URI artifact) throws MalformedURLException {
            return this.getProcessor().getArtifactURL(packageSourceURL, artifact);
        }

        @Override
        public List<URI> getArtifacts(URL packageSourceURL, InputStream inputStream) throws ContributionException, IOException {
            return this.getProcessor().getArtifacts(packageSourceURL, inputStream);
        }

        @Override
        public String getPackageType() {
            return this.packageType;
        }

        private PackageProcessor getProcessor() {
            if (this.processor == null) {
                try {
                    Class<?> processorClass = this.processorDeclaration.loadClass();
                    Constructor<?> constructor = processorClass.getConstructor(new Class[0]);
                    this.processor = (PackageProcessor)constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.processor;
        }
    }
}

