/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.contribution.service.UnrecognizedElementException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleStAXArtifactProcessor
implements StAXArtifactProcessor<Object> {
    private static final QName ANY_ELEMENT = new QName("http://www.w3.org/2001/XMLSchema", "anyElement");
    private static final Logger logger = Logger.getLogger(ExtensibleStAXArtifactProcessor.class.getName());
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private StAXArtifactProcessorExtensionPoint processors;
    private Monitor monitor;

    public ExtensibleStAXArtifactProcessor(StAXArtifactProcessorExtensionPoint processors, XMLInputFactory inputFactory, XMLOutputFactory outputFactory, Monitor monitor) {
        this.processors = processors;
        this.inputFactory = inputFactory;
        this.outputFactory = outputFactory;
        if (this.outputFactory != null) {
            this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        }
        this.monitor = monitor;
    }

    private void warning(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    @Override
    public Object read(XMLStreamReader source) throws ContributionReadException, XMLStreamException {
        QName name;
        StAXArtifactProcessor processor;
        int event = source.getEventType();
        if (event == 7) {
            source.nextTag();
        }
        if ((processor = (StAXArtifactProcessor)this.processors.getProcessor(name = source.getName())) == null) {
            Location location = source.getLocation();
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Element " + name + " cannot be processed. (" + location + ")");
            }
            this.warning("ElementCannotBeProcessed", this.processors, name, location);
            StAXArtifactProcessor anyElementProcessor = (StAXArtifactProcessor)this.processors.getProcessor(ANY_ELEMENT);
            if (anyElementProcessor != null) {
                return anyElementProcessor.read(source);
            }
            return null;
        }
        return processor.read(source);
    }

    @Override
    public void write(Object model, XMLStreamWriter outputSource) throws ContributionWriteException, XMLStreamException {
        if (model != null) {
            StAXArtifactProcessor processor = (StAXArtifactProcessor)this.processors.getProcessor(model.getClass());
            if (processor != null) {
                processor.write(model, outputSource);
            } else {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("No StAX processor is configured to handle " + model.getClass());
                }
                this.warning("NoStaxProcessor", this.processors, model.getClass());
                StAXArtifactProcessor anyElementProcessor = (StAXArtifactProcessor)this.processors.getProcessor(ANY_ELEMENT);
                if (anyElementProcessor != null) {
                    anyElementProcessor.write(model, outputSource);
                }
            }
        }
    }

    @Override
    public void resolve(Object model, ModelResolver resolver) throws ContributionResolveException {
        StAXArtifactProcessor processor;
        if (model != null && (processor = (StAXArtifactProcessor)this.processors.getProcessor(model.getClass())) != null) {
            processor.resolve(model, resolver);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <M> M read(InputStream is, Class<M> type) throws ContributionReadException {
        try {
            try {
                XMLStreamReader reader = this.inputFactory.createXMLStreamReader(is);
                try {
                    reader.nextTag();
                    QName name = reader.getName();
                    Object mo = this.read(reader);
                    if (type.isInstance(mo)) {
                        M m = type.cast(mo);
                        return m;
                    }
                    this.error("UnrecognizedElementException", (Object)reader, name);
                    UnrecognizedElementException e = new UnrecognizedElementException(name);
                    throw e;
                }
                catch (ContributionReadException e) {
                    Location location = reader.getLocation();
                    e.setLine(location.getLineNumber());
                    e.setColumn(location.getColumnNumber());
                    this.error("ContributionReadException", (Object)reader, e);
                    throw e;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException e) {}
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error("ContributionReadException", (Object)this.inputFactory, ce);
            throw ce;
        }
    }

    public void write(Object model, OutputStream os) throws ContributionWriteException {
        try {
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(os);
            this.write(model, writer);
            writer.flush();
            writer.close();
        }
        catch (XMLStreamException e) {
            ContributionWriteException cw = new ContributionWriteException(e);
            this.error("ContributionWriteException", (Object)this.outputFactory, cw);
            throw cw;
        }
    }

    @Override
    public QName getArtifactType() {
        return null;
    }

    @Override
    public Class<Object> getModelType() {
        return null;
    }
}

