/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.tuscany.sca.contribution.processor.TuscanyNamespaceContext;

public class TuscanyXMLStreamReader
extends StreamReaderDelegate
implements XMLStreamReader {
    Stack<List<String>[]> context = new Stack();
    String characterEncodingScheme;
    List<String>[] contextList;
    List<String> prefixList;
    List<String> uriList;
    private boolean withinNextTagMethod = false;

    public TuscanyXMLStreamReader(XMLStreamReader reader) {
        super(reader);
        this.saveCharacterEncodingScheme();
    }

    public void pushContext() throws XMLStreamException {
        this.contextList = new List[2];
        this.prefixList = new ArrayList<String>();
        this.uriList = new ArrayList<String>();
        int namespaceCount = this.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            this.prefixList.add(this.checkString(this.getNamespacePrefix(i)));
            this.uriList.add(this.getNamespaceURI(i));
        }
        this.contextList[0] = this.prefixList;
        this.contextList[1] = this.uriList;
        this.context.push(this.contextList);
    }

    private String checkString(String namespacePrefix) {
        if (namespacePrefix == null) {
            return "";
        }
        return namespacePrefix;
    }

    public void popContext() throws XMLStreamException {
        this.context.pop();
    }

    public void saveCharacterEncodingScheme() {
        this.characterEncodingScheme = super.getCharacterEncodingScheme();
    }

    public int next() throws XMLStreamException {
        if (!this.withinNextTagMethod && this.getEventType() == 2) {
            this.popContext();
        }
        int nextEvent = super.next();
        if (!this.withinNextTagMethod && nextEvent == 1) {
            this.pushContext();
        }
        return nextEvent;
    }

    public int nextTag() throws XMLStreamException {
        int event;
        this.withinNextTagMethod = true;
        if (this.getEventType() == 2) {
            this.popContext();
        }
        if ((event = super.nextTag()) == 1) {
            this.pushContext();
        }
        this.withinNextTagMethod = false;
        return event;
    }

    public NamespaceContext getNamespaceContext() {
        return new TuscanyNamespaceContext((Stack)this.context.clone());
    }

    public String getCharacterEncodingScheme() {
        return this.characterEncodingScheme;
    }
}

