/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.tuscany.sca.contribution.processor.PackageProcessor;
import org.apache.tuscany.sca.contribution.service.ContributionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarContributionProcessor
implements PackageProcessor {
    @Override
    public String getPackageType() {
        return "application/x-compressed";
    }

    @Override
    public URL getArtifactURL(URL sourceURL, URI artifact) throws MalformedURLException {
        if (sourceURL.toString().startsWith("jar:")) {
            return new URL(sourceURL, artifact.toString());
        }
        if (!artifact.toString().equals("")) {
            return new URL("jar:" + sourceURL.toExternalForm() + "!/" + artifact);
        }
        return sourceURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<URI> getArtifacts(URL packageSourceURL, InputStream inputStream) throws ContributionException, IOException {
        if (packageSourceURL == null) {
            throw new IllegalArgumentException("Invalid null package source URL.");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Invalid null source inputstream.");
        }
        JarInputStream jar = new JarInputStream(inputStream);
        try {
            JarEntry entry;
            HashSet<String> names = new HashSet<String>();
            while ((entry = jar.getNextJarEntry()) != null) {
                int s;
                String name = entry.getName();
                if (name.startsWith(".")) continue;
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                if (names.contains(name)) continue;
                names.add(name);
                while (!names.contains(name = (s = name.lastIndexOf(47)) == -1 ? "" : name.substring(0, s))) {
                    names.add(name);
                }
            }
            ArrayList<URI> artifacts = new ArrayList<URI>();
            for (String name : names) {
                try {
                    artifacts.add(new URI(null, name, null));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid artifact uri:" + name);
                }
            }
            ArrayList<URI> arrayList = artifacts;
            return arrayList;
        }
        finally {
            jar.close();
        }
    }
}

