/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor.xml;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.xml.XMLDocumentStreamReader;
import org.apache.tuscany.sca.contribution.processor.xml.XMLEventsStreamReader;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyElementProcessor
implements StAXArtifactProcessor<Object> {
    private static final QName ANY_ELEMENT = new QName("http://www.w3.org/2001/XMLSchema", "anyElement");
    private XMLInputFactory xmlInputFactory;
    private Monitor monitor;

    public AnyElementProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.xmlInputFactory = modelFactories.getFactory(XMLInputFactory.class);
        this.monitor = monitor;
    }

    @Override
    public QName getArtifactType() {
        return ANY_ELEMENT;
    }

    @Override
    public Class<Object> getModelType() {
        return Object.class;
    }

    @Override
    public Object read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String currentElement = null;
        ArrayList<XMLEvent> eventsList = new ArrayList<XMLEvent>();
        HashMap<String, NamespaceContext> eventContext = new HashMap<String, NamespaceContext>();
        try {
            XMLDocumentStreamReader docReader = new XMLDocumentStreamReader(reader);
            XMLEventReader xmlEventReader = this.xmlInputFactory.createXMLEventReader(docReader);
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (currentElement != null && !eventContext.containsKey(currentElement)) {
                    eventContext.put(currentElement, reader.getNamespaceContext());
                }
                eventsList.add(event);
                if (event.isStartElement()) {
                    currentElement = reader.getName().getLocalPart();
                }
                if (!event.isEndDocument()) continue;
                return new XMLEventsStreamReader(eventsList, eventContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void write(Object model, XMLStreamWriter writer) throws XMLStreamException {
        if (!(model instanceof XMLStreamReader)) {
            return;
        }
        XMLStreamReader reader = (XMLStreamReader)model;
        int event = reader.getEventType();
        while (reader.hasNext()) {
            switch (event) {
                case 1: {
                    writer.writeStartElement(reader.getPrefix(), reader.getLocalName(), reader.getNamespaceURI());
                    for (int i = 1; i <= reader.getAttributeCount(); ++i) {
                        writer.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    }
                    break;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 12: {
                    writer.writeCData(reader.getText());
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                }
            }
            if (!reader.hasNext()) continue;
            event = reader.next();
        }
    }

    @Override
    public void resolve(Object model, ModelResolver resolver) throws ContributionResolveException {
    }
}

