/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEventsStreamReader
implements XMLStreamReader {
    private ArrayList<XMLEvent> events = null;
    private HashMap<String, NamespaceContext> eventContext = null;
    private int state;
    private Iterator<XMLEvent> iterator;
    private XMLEvent current;

    public XMLEventsStreamReader(List<XMLEvent> events, Map<String, NamespaceContext> map) {
        this.events = (ArrayList)events;
        this.eventContext = (HashMap)map;
        this.iterator = events.iterator();
        this.current = this.iterator.next();
        this.state = this.current.getEventType();
    }

    @Override
    public void close() throws XMLStreamException {
        this.events = null;
        this.eventContext = null;
        this.iterator = null;
        this.current = null;
    }

    private void checkElementState() {
        if (this.getEventType() != 1 && this.getEventType() != 2) {
            throw new IllegalStateException();
        }
    }

    @Override
    public int getAttributeCount() {
        this.checkElementState();
        int count = 0;
        Iterator<Attribute> iterator = this.current.asStartElement().getAttributes();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    private Attribute getAttribute(int index) {
        this.checkElementState();
        int count = 0;
        Attribute attribute = null;
        Iterator<Attribute> iterator = this.current.asStartElement().getAttributes();
        while (iterator.hasNext()) {
            if (++count == index) {
                attribute = iterator.next();
                continue;
            }
            iterator.next();
        }
        return attribute;
    }

    @Override
    public String getAttributeLocalName(int index) {
        this.checkElementState();
        return this.getAttribute(index).getName().getLocalPart();
    }

    @Override
    public QName getAttributeName(int index) {
        this.checkElementState();
        return this.getAttribute(index).getName();
    }

    @Override
    public String getAttributeNamespace(int index) {
        this.checkElementState();
        return this.getAttributeName(index).getNamespaceURI();
    }

    @Override
    public String getAttributePrefix(int index) {
        this.checkElementState();
        return this.getAttributeName(index).getPrefix();
    }

    @Override
    public String getAttributeType(int index) {
        this.checkElementState();
        return this.getAttribute(index).getDTDType();
    }

    @Override
    public String getAttributeValue(int index) {
        this.checkElementState();
        return this.getAttribute(index).getValue();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        this.checkElementState();
        Iterator<Attribute> iterator = this.current.asStartElement().getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (!attribute.getName().getNamespaceURI().equalsIgnoreCase(namespaceURI) || !attribute.getName().getLocalPart().equalsIgnoreCase(localName)) continue;
            return attribute.getValue();
        }
        return null;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return "UTF-8";
    }

    @Override
    public String getElementText() throws XMLStreamException {
        this.checkElementState();
        int eventType = this.getEventType();
        String elementText = null;
        if (eventType == 1) {
            elementText = this.current.asStartElement().getName().getLocalPart();
        } else if (eventType == 2) {
            elementText = this.current.asEndElement().getName().getLocalPart();
        }
        return elementText;
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public int getEventType() {
        return this.state;
    }

    @Override
    public String getLocalName() {
        this.checkElementState();
        switch (this.current.getEventType()) {
            case 1: {
                return this.current.asStartElement().getName().getLocalPart();
            }
            case 2: {
                return this.current.asEndElement().getName().getLocalPart();
            }
        }
        return null;
    }

    @Override
    public Location getLocation() {
        return this.current.getLocation();
    }

    @Override
    public QName getName() {
        this.checkElementState();
        switch (this.current.getEventType()) {
            case 1: {
                return this.current.asStartElement().getName();
            }
            case 2: {
                return this.current.asEndElement().getName();
            }
        }
        return null;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        this.checkElementState();
        return this.eventContext.get(this.getLocalName());
    }

    @Override
    public int getNamespaceCount() {
        int count = 0;
        Iterator<Namespace> itr = this.current.asStartElement().getNamespaces();
        while (itr.hasNext()) {
            ++count;
            itr.next();
        }
        return count;
    }

    @Override
    public String getNamespacePrefix(int index) {
        Iterator<Namespace> itr = this.current.asStartElement().getNamespaces();
        int level = 0;
        Namespace ns = null;
        while (itr.hasNext()) {
            ns = itr.next();
            if (level == index) {
                return ns.getPrefix();
            }
            ++level;
        }
        return null;
    }

    @Override
    public String getNamespaceURI() {
        this.checkElementState();
        switch (this.current.getEventType()) {
            case 1: {
                return this.current.asStartElement().getName().getNamespaceURI();
            }
            case 2: {
                return this.current.asEndElement().getName().getNamespaceURI();
            }
        }
        return null;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.getNamespaceContext().getNamespaceURI(prefix);
    }

    @Override
    public String getNamespaceURI(int index) {
        Iterator<Namespace> itr = this.current.asStartElement().getNamespaces();
        int level = 0;
        Namespace ns = null;
        while (itr.hasNext()) {
            ns = itr.next();
            if (level == index) {
                return ns.getNamespaceURI();
            }
            ++level;
        }
        return null;
    }

    @Override
    public String getPIData() {
        if (this.current.isProcessingInstruction()) {
            ProcessingInstruction pi = (ProcessingInstruction)this.current;
            return pi.getData();
        }
        throw new IllegalStateException(this.current.toString());
    }

    @Override
    public String getPITarget() {
        if (this.current.isProcessingInstruction()) {
            ProcessingInstruction pi = (ProcessingInstruction)this.current;
            return pi.getTarget();
        }
        throw new IllegalStateException(this.current.toString());
    }

    @Override
    public String getPrefix() {
        this.checkElementState();
        if (this.current.isStartElement()) {
            return this.current.asStartElement().getName().getPrefix();
        }
        return null;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    @Override
    public String getText() {
        if (this.current.isCharacters()) {
            return this.current.asCharacters().getData();
        }
        throw new IllegalStateException(this.current.toString());
    }

    @Override
    public char[] getTextCharacters() {
        if (this.current.isCharacters()) {
            return this.current.asCharacters().getData().toCharArray();
        }
        throw new IllegalStateException(this.current.toString());
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return 0;
    }

    @Override
    public int getTextLength() {
        if (this.current.isCharacters()) {
            return this.current.asCharacters().getData().length();
        }
        throw new IllegalStateException(this.current.toString());
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean hasName() {
        return false;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.iterator.hasNext() || this.state != 8;
    }

    @Override
    public boolean hasText() {
        return false;
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return false;
    }

    @Override
    public boolean isCharacters() {
        return this.current.isCharacters();
    }

    @Override
    public boolean isEndElement() {
        return this.current.isEndElement();
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean isStartElement() {
        return this.current.isStartElement();
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more events");
        }
        if (!this.iterator.hasNext()) {
            this.state = 8;
            this.current = null;
            return this.state;
        }
        this.current = this.iterator.next();
        this.state = this.current.getEventType();
        return this.state;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        return this.iterator.next().getEventType();
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        boolean require = false;
        String uri = this.getNamespaceURI();
        String name = this.getLocalName();
        if (this.state == type && namespaceURI.equals(uri) && localName.equals(name)) {
            require = true;
        }
        if (!require) {
            throw new XMLStreamException();
        }
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }
}

