/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.resolver;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelResolverExtensionPoint
implements ModelResolverExtensionPoint {
    private final ExtensionPointRegistry registry;
    private final Map<Class<?>, Class<? extends ModelResolver>> resolvers = new HashMap();
    private Map<String, ServiceDeclaration> loadedResolvers;

    public DefaultModelResolverExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void addResolver(Class<?> modelType, Class<? extends ModelResolver> resolver) {
        this.resolvers.put(modelType, resolver);
    }

    @Override
    public void removeResolver(Class<?> modelType) {
        this.resolvers.remove(modelType);
    }

    @Override
    public Class<? extends ModelResolver> getResolver(Class<?> modelType) {
        ServiceDeclaration resolverClass;
        Class<?>[] classes;
        this.loadModelResolvers();
        for (Class<?> c : classes = modelType.getInterfaces()) {
            Class<? extends ModelResolver> resolver = this.resolvers.get(c);
            if (resolver == null) {
                ServiceDeclaration resolverClass2 = this.loadedResolvers.get(c.getName());
                if (resolverClass2 == null) continue;
                try {
                    return resolverClass2.loadClass();
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return resolver;
        }
        Class<? extends ModelResolver> resolver = this.resolvers.get(modelType);
        if (resolver == null && (resolverClass = this.loadedResolvers.get(modelType.getName())) != null) {
            try {
                return resolverClass.loadClass();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return resolver;
    }

    private synchronized void loadModelResolvers() {
        Set<ServiceDeclaration> modelResolverDeclarations;
        if (this.loadedResolvers != null) {
            return;
        }
        this.loadedResolvers = new HashMap<String, ServiceDeclaration>();
        try {
            modelResolverDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(ModelResolver.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration modelResolverDeclaration : modelResolverDeclarations) {
            Map<String, String> attributes = modelResolverDeclaration.getAttributes();
            String model = attributes.get("model");
            this.loadedResolvers.put(model, modelResolverDeclaration);
        }
    }
}

