/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.xml;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionMetadataProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<ContributionMetadata> {
    private static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";
    private static final QName CONTRIBUTION_QNAME = new QName("http://www.osoa.org/xmlns/sca/1.0", "contribution");
    private static final QName DEPLOYABLE_QNAME = new QName("http://www.osoa.org/xmlns/sca/1.0", "deployable");
    private final AssemblyFactory assemblyFactory;
    private final ContributionFactory contributionFactory;
    private final ExtensionFactory extensionFactory;
    private final StAXArtifactProcessor<Object> extensionProcessor;
    private final StAXAttributeProcessor<Object> attributeProcessor;
    private Monitor monitor;

    public ContributionMetadataProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, StAXAttributeProcessor<Object> attributeProcessor, Monitor monitor) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.contributionFactory = modelFactories.getFactory(ContributionFactory.class);
        this.extensionFactory = modelFactories.getFactory(ExtensionFactory.class);
        this.extensionProcessor = extensionProcessor;
        this.attributeProcessor = attributeProcessor;
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-xml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return CONTRIBUTION_QNAME;
    }

    @Override
    public Class<ContributionMetadata> getModelType() {
        return ContributionMetadata.class;
    }

    @Override
    public ContributionMetadata read(XMLStreamReader reader) throws ContributionReadException {
        ContributionMetadata contribution = null;
        QName name = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        name = reader.getName();
                        if (CONTRIBUTION_QNAME.equals(name)) {
                            contribution = this.contributionFactory.createContributionMetadata();
                            contribution.setUnresolved(true);
                            this.readExtendedAttributes(reader, contribution, this.attributeProcessor, this.extensionFactory);
                            break;
                        }
                        if (DEPLOYABLE_QNAME.equals(name)) {
                            QName compositeName = this.getQName(reader, "composite");
                            if (compositeName == null) {
                                this.error("AttributeCompositeMissing", (Object)reader, new Object[0]);
                                break;
                            }
                            if (contribution == null) break;
                            Composite composite = this.assemblyFactory.createComposite();
                            composite.setName(compositeName);
                            composite.setUnresolved(true);
                            contribution.getDeployables().add(composite);
                            break;
                        }
                        Object extension = this.extensionProcessor.read(reader);
                        if (extension == null || contribution == null) break;
                        if (extension instanceof Import) {
                            contribution.getImports().add((Import)extension);
                            break;
                        }
                        if (extension instanceof Export) {
                            contribution.getExports().add((Export)extension);
                            break;
                        }
                        contribution.getExtensions().add(extension);
                        break;
                    }
                    case 2: {
                        if (!CONTRIBUTION_QNAME.equals(reader.getName())) break;
                        return contribution;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException(e);
            this.error("XMLStreamException", (Object)reader, ex);
        }
        return contribution;
    }

    @Override
    public void write(ContributionMetadata contribution, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStartDocument(writer, CONTRIBUTION_QNAME.getNamespaceURI(), CONTRIBUTION_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
        this.writeExtendedAttributes(writer, contribution, this.attributeProcessor);
        for (Import imp : contribution.getImports()) {
            this.extensionProcessor.write(imp, writer);
        }
        for (Export export : contribution.getExports()) {
            this.extensionProcessor.write(export, writer);
        }
        for (Composite deployable : contribution.getDeployables()) {
            this.writeStart(writer, DEPLOYABLE_QNAME.getNamespaceURI(), DEPLOYABLE_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr("composite", deployable.getName()));
            this.writeEnd(writer);
        }
        this.writeEndDocument(writer);
    }

    @Override
    public void resolve(ContributionMetadata contribution, ModelResolver resolver) throws ContributionResolveException {
        for (Export export : contribution.getExports()) {
            this.extensionProcessor.resolve(export, resolver);
        }
        for (Import import_ : contribution.getImports()) {
            this.extensionProcessor.resolve(import_, resolver);
        }
        List<Composite> deployables = contribution.getDeployables();
        int n = deployables.size();
        for (int i = 0; i < n; ++i) {
            Composite deployable = deployables.get(i);
            Composite resolved = resolver.resolveModel(Composite.class, deployable);
            if (resolved == deployable) continue;
            deployables.set(i, resolved);
        }
        for (Object ext : contribution.getExtensions()) {
            this.extensionProcessor.resolve(ext, resolver);
        }
        contribution.setUnresolved(false);
    }
}

