/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.OptimizableBinding;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.assembly.ActivationException;
import org.apache.tuscany.sca.core.assembly.CompositeActivator;
import org.apache.tuscany.sca.core.assembly.EndpointReferenceImpl;
import org.apache.tuscany.sca.core.assembly.EndpointWireImpl;
import org.apache.tuscany.sca.core.assembly.RuntimeWireImpl;
import org.apache.tuscany.sca.core.context.ComponentContextHelper;
import org.apache.tuscany.sca.core.context.ComponentContextImpl;
import org.apache.tuscany.sca.core.conversation.ConversationManager;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.scope.ConversationalScopeContainer;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.ScopeContainer;
import org.apache.tuscany.sca.core.scope.ScopeRegistry;
import org.apache.tuscany.sca.core.scope.ScopedRuntimeComponent;
import org.apache.tuscany.sca.endpointresolver.EndpointResolver;
import org.apache.tuscany.sca.endpointresolver.EndpointResolverFactory;
import org.apache.tuscany.sca.endpointresolver.EndpointResolverFactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProviderFactory;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.provider.PolicyProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;
import org.apache.tuscany.sca.work.WorkScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeActivatorImpl
implements CompositeActivator {
    private static final Logger logger = Logger.getLogger(CompositeActivatorImpl.class.getName());
    private final AssemblyFactory assemblyFactory;
    private final MessageFactory messageFactory;
    private final InterfaceContractMapper interfaceContractMapper;
    private final ScopeRegistry scopeRegistry;
    private final WorkScheduler workScheduler;
    private final RuntimeWireProcessor wireProcessor;
    private final ProviderFactoryExtensionPoint providerFactories;
    private final EndpointResolverFactoryExtensionPoint endpointResolverFactories;
    private final RequestContextFactory requestContextFactory;
    private final ProxyFactory proxyFactory;
    private final JavaInterfaceFactory javaInterfaceFactory;
    private final ConversationManager conversationManager;
    private final ComponentContextHelper componentContextHelper;
    private Composite domainComposite;

    public CompositeActivatorImpl(AssemblyFactory assemblyFactory, MessageFactory messageFactory, JavaInterfaceFactory javaInterfaceFactory, SCABindingFactory scaBindingFactory, InterfaceContractMapper interfaceContractMapper, ScopeRegistry scopeRegistry, WorkScheduler workScheduler, RuntimeWireProcessor wireProcessor, RequestContextFactory requestContextFactory, ProxyFactory proxyFactory, ProviderFactoryExtensionPoint providerFactories, EndpointResolverFactoryExtensionPoint endpointResolverFactories, StAXArtifactProcessorExtensionPoint processors, ConversationManager conversationManager) {
        this.assemblyFactory = assemblyFactory;
        this.messageFactory = messageFactory;
        this.interfaceContractMapper = interfaceContractMapper;
        this.scopeRegistry = scopeRegistry;
        this.workScheduler = workScheduler;
        this.wireProcessor = wireProcessor;
        this.providerFactories = providerFactories;
        this.endpointResolverFactories = endpointResolverFactories;
        this.javaInterfaceFactory = javaInterfaceFactory;
        this.requestContextFactory = requestContextFactory;
        this.proxyFactory = proxyFactory;
        this.conversationManager = conversationManager;
        this.componentContextHelper = new ComponentContextHelper(assemblyFactory, javaInterfaceFactory, processors);
    }

    @Override
    public void activate(RuntimeComponent component, RuntimeComponentReference ref) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Activating component reference: " + component.getURI() + "#" + ref.getName());
        }
        this.resolveTargets(ref);
        for (Binding binding : ref.getBindings()) {
            this.addReferenceBindingProvider(component, ref, binding);
        }
        for (Endpoint endpoint : ref.getEndpoints()) {
            endpoint.setSourceComponent(component);
            this.addEndpointResolver(component, ref, endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(RuntimeComponent component, RuntimeComponentReference ref) {
        RuntimeComponentReference runtimeComponentReference = ref;
        synchronized (runtimeComponentReference) {
            this.resolveTargets(ref);
            for (Binding binding : ref.getBindings()) {
                ReferenceBindingProvider provider = ref.getBindingProvider(binding);
                if (provider == null) {
                    provider = this.addReferenceBindingProvider(component, ref, binding);
                }
                if (provider != null) {
                    provider.start();
                }
                this.addReferenceWire(component, ref, binding);
            }
            for (Endpoint endpoint : ref.getEndpoints()) {
                this.addReferenceEndpointWire(component, ref, endpoint);
            }
        }
    }

    public void stop(Component component, ComponentReference reference) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Stopping component reference: " + component.getURI() + "#" + reference.getName());
        }
        RuntimeComponentReference runtimeRef = (RuntimeComponentReference)reference;
        for (Binding binding : reference.getBindings()) {
            ReferenceBindingProvider bindingProvider = runtimeRef.getBindingProvider(binding);
            if (bindingProvider == null) continue;
            bindingProvider.stop();
        }
    }

    @Override
    public void deactivate(RuntimeComponent component, RuntimeComponentReference ref) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Deactivating component reference: " + component.getURI() + "#" + ref.getName());
        }
        this.removeReferenceWires(ref);
        for (Binding binding : ref.getBindings()) {
            this.removeReferenceBindingProvider(component, ref, binding);
        }
    }

    private EndpointResolver addEndpointResolver(RuntimeComponent component, RuntimeComponentReference reference, Endpoint endpoint) {
        if (!endpoint.isUnresolved()) {
            return null;
        }
        if (this.endpointResolverFactories == null) {
            return null;
        }
        EndpointResolverFactory resolverFactory = this.endpointResolverFactories.getEndpointResolverFactory(endpoint.getClass());
        if (resolverFactory != null) {
            EndpointResolver endpointResolver = resolverFactory.createEndpointResolver(endpoint, null);
            if (endpointResolver != null) {
                reference.setEndpointResolver(endpoint, endpointResolver);
            }
            return endpointResolver;
        }
        return null;
    }

    public void addReferenceBindingProviderForEndpoint(Endpoint endpoint) {
        this.addReferenceBindingProvider((RuntimeComponent)endpoint.getSourceComponent(), (RuntimeComponentReference)endpoint.getSourceComponentReference(), endpoint.getSourceBinding());
    }

    private ReferenceBindingProvider addReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, Binding binding) {
        BindingProviderFactory providerFactory = (BindingProviderFactory)this.providerFactories.getProviderFactory(binding.getClass());
        if (providerFactory != null) {
            ReferenceBindingProvider bindingProvider = providerFactory.createReferenceBindingProvider(component, reference, binding);
            if (bindingProvider != null) {
                reference.setBindingProvider(binding, bindingProvider);
            }
            for (PolicyProviderFactory f : this.providerFactories.getPolicyProviderFactories()) {
                PolicyProvider policyProvider = f.createReferencePolicyProvider(component, reference, binding);
                if (policyProvider == null) continue;
                reference.addPolicyProvider(binding, policyProvider);
            }
            return bindingProvider;
        }
        throw new IllegalStateException("Provider factory not found for class: " + binding.getClass().getName());
    }

    private void resolveTargets(RuntimeComponentReference reference) {
    }

    private void addReferenceEndpointWire(Component component, ComponentReference reference, Endpoint endpoint) {
        if (((RuntimeComponentReference)reference).getEndpointResolver(endpoint) == null) {
            return;
        }
        Reference ctref = endpoint.getSourceComponentReference().getReference();
        if (ctref != null && ctref.getInterfaceContract() == null) {
            ctref.setInterfaceContract(reference.getInterfaceContract());
        }
        EndpointWireImpl wire = new EndpointWireImpl(endpoint, this);
        RuntimeComponentReference runtimeRef = (RuntimeComponentReference)reference;
        runtimeRef.getRuntimeWires().add(wire);
    }

    private void addReferenceWire(Component component, ComponentReference reference, Binding binding) {
        if (!(reference instanceof RuntimeComponentReference)) {
            return;
        }
        Component targetComponent = null;
        ComponentService targetComponentService = null;
        Binding targetBinding = null;
        if (binding instanceof OptimizableBinding) {
            OptimizableBinding endpoint = (OptimizableBinding)binding;
            targetComponent = endpoint.getTargetComponent();
            targetComponentService = endpoint.getTargetComponentService();
            targetBinding = endpoint.getTargetBinding();
            if (!reference.isCallback() && binding.getURI() == null && targetComponentService == null) {
                return;
            }
        }
        this.addReferenceWire(component, reference, binding, targetComponent, targetComponentService, targetBinding);
    }

    public void addReferenceWireForEndpoint(Endpoint endpoint) {
        this.addReferenceWire(endpoint.getSourceComponent(), endpoint.getSourceComponentReference(), endpoint.getSourceBinding(), endpoint.getTargetComponent(), endpoint.getTargetComponentService(), endpoint.getTargetBinding());
    }

    private RuntimeWire addReferenceWire(Component refComponent, ComponentReference reference, Binding refBinding, Component serviceComponent, ComponentService service, Binding serviceBinding) {
        RuntimeComponentReference runtimeRef = (RuntimeComponentReference)reference;
        InterfaceContract bindingContract = this.getInterfaceContract(reference, refBinding);
        Reference componentTypeRef = reference.getReference();
        InterfaceContract sourceContract = componentTypeRef == null || componentTypeRef.getInterfaceContract() == null ? reference.getInterfaceContract() : componentTypeRef.getInterfaceContract();
        sourceContract = sourceContract.makeUnidirectional(false);
        EndpointReferenceImpl wireSource = new EndpointReferenceImpl((RuntimeComponent)refComponent, reference, refBinding, sourceContract);
        ComponentService callbackService = reference.getCallbackService();
        if (callbackService != null) {
            Binding callbackBinding = null;
            for (Binding binding : callbackService.getBindings()) {
                if (!refBinding.getName().startsWith(binding.getName())) continue;
                callbackBinding = binding;
                break;
            }
            if (callbackBinding == null) {
                callbackBinding = (Binding)callbackService.getBinding(refBinding.getClass());
            }
            InterfaceContract callbackContract = callbackService.getInterfaceContract();
            EndpointReferenceImpl callbackEndpoint = new EndpointReferenceImpl((RuntimeComponent)refComponent, callbackService, callbackBinding, callbackContract);
            wireSource.setCallbackEndpoint(callbackEndpoint);
        }
        EndpointReferenceImpl wireTarget = new EndpointReferenceImpl((RuntimeComponent)serviceComponent, service, serviceBinding, bindingContract);
        if (serviceBinding != null) {
            wireTarget.setURI(serviceBinding.getURI());
        }
        RuntimeWireImpl wire = new RuntimeWireImpl(wireSource, wireTarget, this.interfaceContractMapper, this.workScheduler, this.wireProcessor, this.messageFactory, this.conversationManager);
        runtimeRef.getRuntimeWires().add(wire);
        return wire;
    }

    private void addImplementationProvider(RuntimeComponent component, Implementation implementation) {
        ImplementationProviderFactory providerFactory = (ImplementationProviderFactory)this.providerFactories.getProviderFactory(implementation.getClass());
        if (providerFactory != null) {
            ImplementationProvider implementationProvider = providerFactory.createImplementationProvider(component, implementation);
            if (implementationProvider != null) {
                component.setImplementationProvider(implementationProvider);
            }
        } else {
            throw new IllegalStateException("Provider factory not found for class: " + implementation.getClass().getName());
        }
        for (PolicyProviderFactory f : this.providerFactories.getPolicyProviderFactories()) {
            PolicyProvider policyProvider = f.createImplementationPolicyProvider(component, implementation);
            if (policyProvider == null) continue;
            component.addPolicyProvider(policyProvider);
        }
    }

    private void removeImplementationProvider(RuntimeComponent component) {
        component.setImplementationProvider(null);
        component.getPolicyProviders().clear();
    }

    private ServiceBindingProvider addServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, Binding binding) {
        BindingProviderFactory providerFactory = (BindingProviderFactory)this.providerFactories.getProviderFactory(binding.getClass());
        if (providerFactory != null) {
            ServiceBindingProvider bindingProvider = providerFactory.createServiceBindingProvider(component, service, binding);
            if (bindingProvider != null) {
                service.setBindingProvider(binding, bindingProvider);
            }
            for (PolicyProviderFactory f : this.providerFactories.getPolicyProviderFactories()) {
                PolicyProvider policyProvider = f.createServicePolicyProvider(component, service, binding);
                if (policyProvider == null) continue;
                service.addPolicyProvider(binding, policyProvider);
            }
            return bindingProvider;
        }
        throw new IllegalStateException("Provider factory not found for class: " + binding.getClass().getName());
    }

    private void removeServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, Binding binding) {
        service.setBindingProvider(binding, null);
        for (Binding b : service.getBindings()) {
            List<PolicyProvider> pps = service.getPolicyProviders(b);
            if (pps == null) continue;
            pps.clear();
        }
    }

    private void removeReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, Binding binding) {
        reference.setBindingProvider(binding, null);
        for (Binding b : reference.getBindings()) {
            List<PolicyProvider> pps = reference.getPolicyProviders(b);
            if (pps == null) continue;
            pps.clear();
        }
    }

    @Override
    public void start(Composite composite) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Starting composite: " + composite.getName());
        }
        for (Component component : composite.getComponents()) {
            this.start(component);
        }
    }

    @Override
    public void stop(Composite composite) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Stopping composite: " + composite.getName());
        }
        for (Component component : composite.getComponents()) {
            this.stop(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Component component) {
        RuntimeComponent runtimeComponent;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Starting component: " + component.getURI());
        }
        if ((runtimeComponent = (RuntimeComponent)component).isStarted()) {
            return;
        }
        this.configureComponentContext(runtimeComponent);
        final ArrayList<Object> providers = new ArrayList<Object>();
        try {
            ScopedRuntimeComponent scopedRuntimeComponent;
            ScopeContainer scopeContainer;
            Object bindingProvider;
            for (ComponentReference reference : component.getReferences()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Starting component reference: " + component.getURI() + "#" + reference.getName());
                }
                RuntimeComponentReference runtimeRef = (RuntimeComponentReference)reference;
                runtimeRef.setComponent(runtimeComponent);
                for (Endpoint endpoint : reference.getEndpoints()) {
                    final EndpointResolver endpointResolver = runtimeRef.getEndpointResolver(endpoint);
                    if (endpointResolver == null) continue;
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            endpointResolver.start();
                            providers.add(endpointResolver);
                            return null;
                        }
                    });
                }
                for (Binding binding : reference.getBindings()) {
                    bindingProvider = runtimeRef.getBindingProvider(binding);
                    if (bindingProvider == null) continue;
                    AccessController.doPrivileged(new PrivilegedAction<Object>((ReferenceBindingProvider)bindingProvider, providers){
                        final /* synthetic */ ReferenceBindingProvider val$bindingProvider;
                        final /* synthetic */ List val$providers;
                        {
                            this.val$bindingProvider = referenceBindingProvider;
                            this.val$providers = list;
                        }

                        @Override
                        public Object run() {
                            this.val$bindingProvider.start();
                            this.val$providers.add(this.val$bindingProvider);
                            return null;
                        }
                    });
                }
            }
            for (ComponentService service : component.getServices()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Starting component service: " + component.getURI() + "#" + service.getName());
                }
                RuntimeComponentService runtimeService = (RuntimeComponentService)service;
                for (Binding binding : service.getBindings()) {
                    bindingProvider = runtimeService.getBindingProvider(binding);
                    if (bindingProvider == null) continue;
                    AccessController.doPrivileged(new PrivilegedAction<Object>((ServiceBindingProvider)bindingProvider, providers){
                        final /* synthetic */ ServiceBindingProvider val$bindingProvider;
                        final /* synthetic */ List val$providers;
                        {
                            this.val$bindingProvider = serviceBindingProvider;
                            this.val$providers = list;
                        }

                        @Override
                        public Object run() {
                            this.val$bindingProvider.start();
                            this.val$providers.add(this.val$bindingProvider);
                            return null;
                        }
                    });
                }
            }
            Implementation implementation = component.getImplementation();
            if (implementation instanceof Composite) {
                try {
                    this.start((Composite)implementation);
                }
                catch (Throwable e) {
                    try {
                        this.stop((Composite)implementation);
                    }
                    catch (Throwable e1) {
                        logger.log(Level.SEVERE, e1.getMessage(), e1);
                    }
                    this.rethrow(e);
                }
            } else {
                ImplementationProvider implementationProvider = runtimeComponent.getImplementationProvider();
                if (implementationProvider != null) {
                    implementationProvider.start();
                    providers.add(implementationProvider);
                }
            }
            if (component instanceof ScopedRuntimeComponent && (scopeContainer = (scopedRuntimeComponent = (ScopedRuntimeComponent)component).getScopeContainer()) != null) {
                scopeContainer.start();
                providers.add(scopeContainer);
            }
        }
        catch (Throwable e) {
            this.stopProviders(providers);
            this.rethrow(e);
        }
        finally {
            providers.clear();
        }
        runtimeComponent.setStarted(true);
    }

    private void rethrow(Throwable e) throws Error {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
    }

    private void stopProviders(List<Object> providers) {
        for (int i = providers.size() - 1; i >= 0; --i) {
            Object provider = providers.get(i);
            try {
                if (provider instanceof ImplementationProvider) {
                    ((ImplementationProvider)provider).stop();
                    continue;
                }
                if (provider instanceof ReferenceBindingProvider) {
                    ((ReferenceBindingProvider)provider).stop();
                    continue;
                }
                if (provider instanceof ServiceBindingProvider) {
                    ((ServiceBindingProvider)provider).stop();
                    continue;
                }
                if (provider instanceof EndpointResolver) {
                    ((EndpointResolver)provider).stop();
                    continue;
                }
                if (!(provider instanceof ScopeContainer)) continue;
                ((ScopeContainer)provider).stop();
                continue;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    @Override
    public void configureComponentContext(RuntimeComponent runtimeComponent) {
        ComponentContextImpl componentContext = new ComponentContextImpl(this, this.assemblyFactory, this.proxyFactory, this.interfaceContractMapper, this.requestContextFactory, this.javaInterfaceFactory, runtimeComponent);
        runtimeComponent.setComponentContext(componentContext);
    }

    @Override
    public void stop(Component component) {
        ScopedRuntimeComponent runtimeComponent;
        if (!((RuntimeComponent)component).isStarted()) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Stopping component: " + component.getURI());
        }
        for (ComponentService service : component.getServices()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Stopping component service: " + component.getURI() + "#" + service.getName());
            }
            for (Binding binding : service.getBindings()) {
                final ServiceBindingProvider bindingProvider = ((RuntimeComponentService)service).getBindingProvider(binding);
                if (bindingProvider == null) continue;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        bindingProvider.stop();
                        return null;
                    }
                });
            }
        }
        for (ComponentReference reference : component.getReferences()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting component reference: " + component.getURI() + "#" + reference.getName());
            }
            RuntimeComponentReference runtimeRef = (RuntimeComponentReference)reference;
            for (Binding binding : reference.getBindings()) {
                final ReferenceBindingProvider bindingProvider = runtimeRef.getBindingProvider(binding);
                if (bindingProvider == null) continue;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        bindingProvider.stop();
                        return null;
                    }
                });
            }
            for (Endpoint endpoint : reference.getEndpoints()) {
                final EndpointResolver endpointResolver = runtimeRef.getEndpointResolver(endpoint);
                if (endpointResolver == null) continue;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        endpointResolver.stop();
                        return null;
                    }
                });
            }
        }
        Implementation implementation = component.getImplementation();
        if (implementation instanceof Composite) {
            this.stop((Composite)implementation);
        } else {
            final ImplementationProvider implementationProvider = ((RuntimeComponent)component).getImplementationProvider();
            if (implementationProvider != null) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        implementationProvider.stop();
                        return null;
                    }
                });
            }
        }
        if (component instanceof ScopedRuntimeComponent && (runtimeComponent = (ScopedRuntimeComponent)component).getScopeContainer() != null && runtimeComponent.getScopeContainer().getLifecycleState() != 6) {
            runtimeComponent.getScopeContainer().stop();
        }
        ((RuntimeComponent)component).setStarted(false);
    }

    private InterfaceContract getInterfaceContract(ComponentReference reference, Binding binding) {
        InterfaceContract bindingContract;
        InterfaceContract interfaceContract = reference.getInterfaceContract();
        ReferenceBindingProvider provider = ((RuntimeComponentReference)reference).getBindingProvider(binding);
        if (provider != null && (bindingContract = provider.getBindingInterfaceContract()) != null) {
            interfaceContract = bindingContract;
        }
        return interfaceContract.makeUnidirectional(false);
    }

    private void removeReferenceWires(ComponentReference reference) {
        if (!(reference instanceof RuntimeComponentReference)) {
            return;
        }
    }

    private InterfaceContract getInterfaceContract(ComponentService service, Binding binding) {
        InterfaceContract bindingContract;
        InterfaceContract interfaceContract = service.getInterfaceContract();
        ServiceBindingProvider provider = ((RuntimeComponentService)service).getBindingProvider(binding);
        if (provider != null && (bindingContract = provider.getBindingInterfaceContract()) != null) {
            interfaceContract = bindingContract;
        }
        return interfaceContract.makeUnidirectional(false);
    }

    private void removeServiceWires(ComponentService service) {
        if (!(service instanceof RuntimeComponentService)) {
            return;
        }
        RuntimeComponentService runtimeService = (RuntimeComponentService)service;
        runtimeService.getRuntimeWires().clear();
    }

    private RuntimeWire addServiceWire(Component serviceComponent, ComponentService service, Binding serviceBinding) {
        if (!(service instanceof RuntimeComponentService)) {
            return null;
        }
        RuntimeComponentService runtimeService = (RuntimeComponentService)service;
        Service targetService = service.getService();
        if (targetService == null) {
            targetService = service;
        }
        InterfaceContract targetContract = targetService.getInterfaceContract().makeUnidirectional(false);
        InterfaceContract sourceContract = this.getInterfaceContract(service, serviceBinding);
        EndpointReferenceImpl wireSource = new EndpointReferenceImpl(null, null, serviceBinding, sourceContract);
        EndpointReferenceImpl wireTarget = new EndpointReferenceImpl((RuntimeComponent)serviceComponent, (RuntimeComponentService)service, serviceBinding, targetContract);
        RuntimeWireImpl wire = new RuntimeWireImpl(wireSource, wireTarget, this.interfaceContractMapper, this.workScheduler, this.wireProcessor, this.messageFactory, this.conversationManager);
        runtimeService.getRuntimeWires().add(wire);
        return wire;
    }

    @Override
    public void activate(RuntimeComponent component, RuntimeComponentService service) {
        if (service.getService() == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Skipping component service not defined in the component type: " + component.getURI() + "#" + service.getName());
            }
            return;
        }
        if (service.getService() instanceof CompositeService) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Activating component service: " + component.getURI() + "#" + service.getName());
        }
        for (Binding binding : service.getBindings()) {
            this.addServiceBindingProvider(component, service, binding);
            this.addServiceWire(component, service, binding);
        }
    }

    @Override
    public void deactivate(RuntimeComponent component, RuntimeComponentService service) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Deactivating component service: " + component.getURI() + "#" + service.getName());
        }
        this.removeServiceWires(service);
        for (Binding binding : service.getBindings()) {
            this.removeServiceBindingProvider(component, service, binding);
        }
    }

    private void addScopeContainer(Component component) {
        if (!(component instanceof ScopedRuntimeComponent)) {
            return;
        }
        ScopedRuntimeComponent runtimeComponent = (ScopedRuntimeComponent)component;
        ScopeContainer scopeContainer = this.scopeRegistry.getScopeContainer(runtimeComponent);
        if (scopeContainer != null && scopeContainer.getScope() == Scope.CONVERSATION) {
            this.conversationManager.addListener((ConversationalScopeContainer)scopeContainer);
        }
        runtimeComponent.setScopeContainer(scopeContainer);
    }

    private void removeScopeContainer(Component component) {
        if (!(component instanceof ScopedRuntimeComponent)) {
            return;
        }
        ScopedRuntimeComponent runtimeComponent = (ScopedRuntimeComponent)component;
        ScopeContainer scopeContainer = runtimeComponent.getScopeContainer();
        if (scopeContainer != null && scopeContainer.getScope() == Scope.CONVERSATION) {
            this.conversationManager.removeListener((ConversationalScopeContainer)scopeContainer);
        }
        runtimeComponent.setScopeContainer(null);
    }

    public void activateComponent(Component component) throws ActivationException {
        try {
            Implementation implementation;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Activating component: " + component.getURI());
            }
            if ((implementation = component.getImplementation()) instanceof Composite) {
                this.activate((Composite)implementation);
            } else if (implementation != null) {
                this.addImplementationProvider((RuntimeComponent)component, implementation);
                this.addScopeContainer(component);
            }
            for (ComponentService service : component.getServices()) {
                this.activate((RuntimeComponent)component, (RuntimeComponentService)service);
            }
            for (ComponentReference reference : component.getReferences()) {
                this.activate((RuntimeComponent)component, (RuntimeComponentReference)reference);
            }
        }
        catch (Exception e) {
            throw new ActivationException(e);
        }
    }

    public void deactivateComponent(Component component) throws ActivationException {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Deactivating component: " + component.getURI());
            }
            for (ComponentService service : component.getServices()) {
                this.deactivate((RuntimeComponent)component, (RuntimeComponentService)service);
            }
            for (ComponentReference reference : component.getReferences()) {
                this.deactivate((RuntimeComponent)component, (RuntimeComponentReference)reference);
            }
            Implementation implementation = component.getImplementation();
            if (implementation instanceof Composite) {
                this.deactivate((Composite)implementation);
            } else if (implementation != null) {
                this.removeImplementationProvider((RuntimeComponent)component);
                this.removeScopeContainer(component);
            }
        }
        catch (Exception e) {
            throw new ActivationException(e);
        }
    }

    @Override
    public void activate(Composite composite) throws ActivationException {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Activating composite: " + composite.getName());
            }
            for (Component component : composite.getComponents()) {
                Implementation implementation;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Activating component: " + component.getURI());
                }
                if ((implementation = component.getImplementation()) instanceof Composite) {
                    this.activate((Composite)implementation);
                } else if (implementation != null) {
                    this.addImplementationProvider((RuntimeComponent)component, implementation);
                    this.addScopeContainer(component);
                }
                for (ComponentService service : component.getServices()) {
                    this.activate((RuntimeComponent)component, (RuntimeComponentService)service);
                }
                for (ComponentReference reference : component.getReferences()) {
                    this.activate((RuntimeComponent)component, (RuntimeComponentReference)reference);
                }
            }
        }
        catch (Exception e) {
            throw new ActivationException(e);
        }
    }

    @Override
    public void deactivate(Composite composite) throws ActivationException {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Deactivating composite: " + composite.getName());
            }
            for (Component component : composite.getComponents()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Deactivating component: " + component.getURI());
                }
                for (ComponentService service : component.getServices()) {
                    this.deactivate((RuntimeComponent)component, (RuntimeComponentService)service);
                }
                for (ComponentReference reference : component.getReferences()) {
                    this.deactivate((RuntimeComponent)component, (RuntimeComponentReference)reference);
                }
                Implementation implementation = component.getImplementation();
                if (implementation instanceof Composite) {
                    this.deactivate((Composite)implementation);
                    continue;
                }
                if (implementation == null) continue;
                this.removeImplementationProvider((RuntimeComponent)component);
                this.removeScopeContainer(component);
            }
        }
        catch (Exception e) {
            throw new ActivationException(e);
        }
    }

    @Override
    public ComponentContextHelper getComponentContextHelper() {
        return this.componentContextHelper;
    }

    @Override
    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    @Override
    public Composite getDomainComposite() {
        return this.domainComposite;
    }

    @Override
    public void setDomainComposite(Composite domainComposite) {
        this.domainComposite = domainComposite;
    }

    @Override
    public Component resolve(String componentURI) {
        for (Composite composite : this.domainComposite.getIncludes()) {
            Component component = this.resolve(composite, componentURI);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    public Component resolve(Composite composite, String componentURI) {
        for (Component component : composite.getComponents()) {
            String uri = component.getURI();
            if (uri.equals(componentURI)) {
                return component;
            }
            if (!componentURI.startsWith(uri)) continue;
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) {
                return null;
            }
            return this.resolve((Composite)implementation, componentURI);
        }
        return null;
    }

    @Override
    public JavaInterfaceFactory getJavaInterfaceFactory() {
        return this.javaInterfaceFactory;
    }

    @Override
    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }
}

