/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.core.assembly.ReferenceParametersImpl;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class EndpointReferenceImpl
implements EndpointReference {
    private RuntimeComponent component;
    private Contract contract;
    private Binding binding;
    private InterfaceContract interfaceContract;
    private String uri;
    private EndpointReference callbackEndpoint;
    private ReferenceParameters parameters = new ReferenceParametersImpl();

    public EndpointReferenceImpl(RuntimeComponent component, Contract contract, Binding binding, InterfaceContract interfaceContract) {
        this.component = component;
        this.contract = contract;
        this.binding = binding;
        this.interfaceContract = interfaceContract;
        this.uri = (component != null ? component.getURI() : "") + '/' + (contract != null ? contract.getName() : "");
    }

    public EndpointReferenceImpl(String uri) {
        this.uri = uri;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public RuntimeComponent getComponent() {
        return this.component;
    }

    public void setComponent(RuntimeComponent component) {
        this.component = component;
    }

    public Contract getContract() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    public InterfaceContract getInterfaceContract() {
        return this.interfaceContract;
    }

    public void setInterfaceContract(InterfaceContract interfaceContract) {
        this.interfaceContract = interfaceContract;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public EndpointReference getCallbackEndpoint() {
        return this.callbackEndpoint;
    }

    public void setCallbackEndpoint(EndpointReference callbackEndpoint) {
        this.callbackEndpoint = callbackEndpoint;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndpointReferenceImpl other = (EndpointReferenceImpl)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public Object clone() throws CloneNotSupportedException {
        EndpointReferenceImpl copy = (EndpointReferenceImpl)super.clone();
        if (this.parameters != null) {
            copy.parameters = (ReferenceParameters)this.parameters.clone();
        }
        return copy;
    }

    public ReferenceParameters getReferenceParameters() {
        return this.parameters;
    }

    public void setReferenceParameters(ReferenceParameters parameters) {
        this.parameters = parameters;
    }

    public void mergeEndpoint(EndpointReference epr) {
        this.component = epr.getComponent();
        this.contract = epr.getContract();
        this.binding = epr.getBinding();
        this.interfaceContract = epr.getInterfaceContract();
        this.uri = epr.getURI();
        this.callbackEndpoint = epr.getCallbackEndpoint();
    }
}

